<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <h4 class="no-margin"><?php echo _l('team_group_list'); ?></h4>
            <hr class="hr-panel-heading" />

            <a href="<?php echo admin_url('team_group/create'); ?>" class="btn btn-primary mbot15">
              <i class="fa fa-plus"></i> <?php echo _l('create_team_group'); ?>
            </a>

            <?php
              $table_data = [
                  _l('#'),
                  _l('group_name'),
                  _l('managers'),
                  _l('team_leaders'),
                  _l('status'),
                  _l('options'),
              ];
              render_datatable($table_data, 'team-group', [], [
                'id' => 'team-group-table',
                'data-last-order-identifier' => 'team-group',
                'data-default-order' => get_table_last_order('team-group'),
              ]);
            ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>
<script>
  $(function() {
    initDataTable('.table-team-group', admin_url + 'team_group/table', [0], [0]);
  });
</script>
