<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <div class="tw-flex tw-justify-between tw-items-center">
              <h4 class="tw-m-0"><?php echo _l('deals_kanban'); ?></h4>
              <a href="<?php echo admin_url('deals'); ?>" class="btn btn-default"><i class="fa fa-list"></i> <?php echo _l('switch_to_list_view'); ?></a>
            </div>
            <hr class="hr-panel-heading" />
            <div class="kanban-wrapper">
              <div class="row">
                <?php foreach ($stages as $stage) { ?>
                  <div class="col-md-3">
                    <div class="kanban-col">
                      <div class="kanban-col-header">
                        <strong><?php echo html_entity_decode($stage['name']); ?></strong>
                      </div>
                      <div class="kanban-items">
                        <?php foreach ($stage['deals'] as $deal) { ?>
                          <?php $this->load->view('_kan_ban_card', ['deal' => $deal, 'base_currency' => get_base_currency()]); ?>
                        <?php } ?>
                      </div>
                    </div>
                  </div>
                <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>