<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="_buttons tw-mb-2 sm:tw-mb-4">
                    <a href="<?php echo admin_url('deals/create'); ?>"
                        class="btn btn-primary mright5 pull-left display-block">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('new_deal'); ?>
                    </a>
                    <a href="<?php echo admin_url('deals/import'); ?>"
                        class="btn btn-primary pull-left display-block mleft5">
                        <i class="fa-solid fa-upload tw-mr-1"></i>
                        <?php echo _l('import_deals'); ?>
                    </a>
                    <a href="<?php echo admin_url('deals?view=kanban'); ?>"
                        class="btn btn-default pull-left display-block mleft5">
                        <i class="fa-solid fa-grip-vertical tw-mr-1"></i>
                        <?php echo _l('deals_kanban'); ?>
                    </a>
                    <div class="row">
                        <div class="col-sm-5">
                            <a href="#" class="btn btn-default btn-with-tooltip" data-toggle="tooltip"
                                data-title="<?php echo _l('deals_summary'); ?>" data-placement="top"
                                onclick="slideToggle('.deals-overview'); return false;">
                                <i class="fa fa-bar-chart"></i>
                            </a>
                        </div>
                        <div class="col-sm-4 col-xs-12 pull-right deals-search">
                            <div class="tw-inline pull-right">
                                <div class="tw-flex tw-items-center tw-space-x-1 tw-mr-2">
                                    <a href="#" class="btn btn-default deals-table-order-btn" data-toggle="modal"
                                        data-target="#deals-table-order-modal"
                                        title="<?php echo _l('deals_table_order_configure'); ?>">
                                        <i class="fa fa-columns tw-mr-1"></i>
                                        <?php echo _l('deals_table_order_configure'); ?>
                                    </a>
                                    <?php if (class_exists('App_table') && App_table::find('deals')) { ?>
                                        <a href="#" class="btn btn-default" onclick="filtersModal('deals'); return false;">
                                            <i class="fa-regular fa-filter tw-mr-1"></i>
                                            <?php echo _l('filter_by'); ?>
                                        </a>
                                        <script>
                                            if (typeof window.tableFilters === 'undefined') { window.tableFilters = {}; }
                                            window.tableFilters.deals = {
                                                rules: <?php echo App_table::find('deals')->rulesJs(); ?>,
                                                filters: <?php echo App_table::find('deals')->filtersJs(); ?>
                                            };
                                        </script>
                                    <?php } ?>
                                </div>
                            </div>
                            <?php echo form_hidden('sort_type'); ?>
                            <?php echo form_hidden('sort', ''); ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <!-- Deals Summary Overview -->
                    <div class="hide deals-overview tw-mt-2 sm:tw-mt-4 tw-mb-4 sm:tw-mb-0">
                        <h4 class="tw-mt-0 tw-font-semibold tw-text-lg">
                            <?php echo _l('deals_summary'); ?>
                        </h4>
                        <div class="tw-flex tw-flex-wrap tw-flex-col lg:tw-flex-row tw-w-full tw-gap-3 lg:tw-gap-6">
                            <div
                                class="lg:tw-border-r lg:tw-border-solid lg:tw-border-neutral-300 tw-flex-1 tw-flex tw-items-center last:tw-border-r-0">
                                <span class="tw-font-semibold tw-mr-3 rtl:tw-ml-3 tw-text-lg">
                                    <?php echo count($deals); ?>
                                </span>
                                <span class="tw-text-neutral-600"><?php echo _l('total_deals'); ?></span>
                            </div>
                            <div
                                class="lg:tw-border-r lg:tw-border-solid lg:tw-border-neutral-300 tw-flex-1 tw-flex tw-items-center last:tw-border-r-0">
                                <span class="tw-font-semibold tw-mr-3 rtl:tw-ml-3 tw-text-lg">
                                    <?php
                                    $total_value = 0;
                                    foreach ($deals as $deal) {
                                        $total_value += (float) $deal['deal_value'];
                                    }
                                    echo app_format_money($total_value, get_base_currency());
                                    ?>
                                </span>
                                <span class="tw-text-neutral-600"><?php echo _l('total_value'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row" id="deals-table">
                            <div class="col-md-12">
                                <!-- Bulk Actions Modal -->
                                <div class="modal fade bulk_actions" id="deals_bulk_actions" tabindex="-1"
                                    role="dialog">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                                <h4 class="modal-title"><?php echo _l('bulk_actions'); ?></h4>
                                            </div>
                                            <div class="modal-body">
                                                <div class="checkbox checkbox-danger">
                                                    <input type="checkbox" name="mass_delete" id="mass_delete">
                                                    <label for="mass_delete"><?php echo _l('mass_delete'); ?></label>
                                                </div>
                                                <hr class="mass_delete_separator" />
                                                <div id="bulk_change">
                                                    <div class="form-group">
                                                        <label
                                                            for="move_to_pipeline_bulk"><?php echo _l('move_to_pipeline'); ?></label>
                                                        <select name="move_to_pipeline_bulk" id="move_to_pipeline_bulk"
                                                            class="selectpicker" data-width="100%">
                                                            <option value=""><?php echo _l('select_pipeline'); ?>
                                                            </option>
                                                            <?php foreach ($pipelines ?? [] as $pipeline) { ?>
                                                                <option value="<?php echo $pipeline['id']; ?>">
                                                                    <?php echo $pipeline['name']; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default"
                                                    data-dismiss="modal"><?php echo _l('close'); ?></button>
                                                <a href="#" class="btn btn-primary"
                                                    onclick="deals_bulk_action(this); return false;"><?php echo _l('confirm'); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Deals Table -->
                                <div class="panel-table-full">
                                    <div class="table-responsive">
                                        <table class="table dt-table table-deals" data-order-col="0"
                                            data-order-type="desc">
                                            <thead>
                                                <tr>
                                                    <th><input type="checkbox" id="mass_select_all"
                                                            data-to-table="deals"></th>
                                                    <th class="th-deal-number"><?php echo _l('the_number_sign'); ?></th>
                                                    <th class="th-deal-name"><?php echo _l('deal_name'); ?></th>
                                                    <th class="th-deal-company"><?php echo _l('company'); ?></th>
                                                    <th class="th-deal-pipeline"><?php echo _l('pipeline'); ?></th>
                                                    <th class="th-deal-stage"><?php echo _l('stage'); ?></th>
                                                    <th class="th-deal-all-pipelines"><?php echo _l('pipelines'); ?> / <?php echo _l('stage'); ?> / <?php echo _l('score'); ?></th>
                                                    <th class="th-deal-value"><?php echo _l('deal_value'); ?></th>
                                                    <th class="th-deal-assigned"><?php echo _l('assigned_to'); ?></th>
                                                    <th class="th-deal-status"><?php echo _l('status'); ?></th>
                                                    <th class="th-deal-created"><?php echo _l('dateadded'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($deals as $deal) { ?>
                                                    <tr>
                                                        <td><input type="checkbox" class="individual" data-to-table="deals"
                                                                value="<?php echo $deal['id']; ?>"></td>
                                                        <td><?php echo '#' . $deal['id']; ?></td>
                                                        <td>
                                                            <a href="<?php echo admin_url('deals/view/' . $deal['id']); ?>"
                                                                class="tw-font-medium">
                                                                <?php echo html_entity_decode($deal['name']); ?>
                                                            </a>
                                                            <div class="row-options">
                                                                <a
                                                                    href="<?php echo admin_url('deals/view/' . $deal['id']); ?>"><?php echo _l('view'); ?></a>
                                                                <span> | </span>
                                                                <a
                                                                    href="<?php echo admin_url('deals/edit/' . $deal['id']); ?>"><?php echo _l('edit'); ?></a>
                                                                <span> | </span>
                                                                <a href="<?php echo admin_url('deals/delete/' . $deal['id']); ?>"
                                                                    class="text-danger _delete"><?php echo _l('delete'); ?></a>
                                                            </div>
                                                        </td>
                                                        <td><?php echo html_entity_decode($deal['company']); ?></td>
                                                        <td>
                                                            <?php echo isset($deal['pipeline']['label']) ? $deal['pipeline']['label'] : '-'; ?>
                                                        </td>
                                                        <td>
                                                            <?php echo isset($deal['stage']['label']) ? $deal['stage']['label'] : '-'; ?>
                                                        </td>
                                                        <td>
                                                            <?php if (!empty($deal['pipelines'])) { ?>
                                                                <?php foreach ($deal['pipelines'] as $rel) { ?>
                                                                    <div>
                                                                        <span class="label label-default"><?php echo e($rel['pipeline']['label']); ?></span>
                                                                        <span> - <?php echo e($rel['stage']['label']); ?></span>
                                                                        <?php if ($rel['score'] !== null) { ?>
                                                                            <span class="tw-ml-1">(<?php echo (int) $rel['score']; ?>)</span>
                                                                        <?php } ?>
                                                                    </div>
                                                                <?php } ?>
                                                            <?php } else { ?>
                                                                -
                                                            <?php } ?>
                                                        </td>
                                                        <td><?php echo app_format_money((float) $deal['deal_value'], get_base_currency()); ?>
                                                        </td>
                                                        <td><?php echo isset($deal['assigned']['label']) ? $deal['assigned']['label'] : '-'; ?>
                                                        </td>
                                                        <td>
                                                            <span
                                                                class="label label-<?php echo ($deal['status_final'] == 'won' ? 'success' : ($deal['status_final'] == 'lost' ? 'danger' : 'default')); ?>">
                                                                <?php echo ucfirst($deal['status_final']); ?>
                                                            </span>
                                                        </td>
                                                        <td><?php echo _dt($deal['dateadded']); ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
    $(function () {
        // Initialize DataTable
        $('.table-deals').DataTable({
            "order": [[1, "desc"]],
            "pageLength": 25,
            "responsive": true,
            "columnDefs": [
                { "orderable": false, "targets": 0 }
            ]
        });

        // Handle mass select all
        $('#mass_select_all').on('change', function () {
            var checked = $(this).prop('checked');
            $('.individual').prop('checked', checked);
            toggleBulkActions();
        });

        // Handle individual checkboxes
        $('.individual').on('change', function () {
            toggleBulkActions();
            var allChecked = $('.individual:checked').length === $('.individual').length;
            $('#mass_select_all').prop('checked', allChecked);
        });

        function toggleBulkActions() {
            var checkedBoxes = $('.individual:checked').length;
            if (checkedBoxes > 0) {
                $('.bulk-actions-btn').removeClass('hide');
            } else {
                $('.bulk-actions-btn').addClass('hide');
            }
        }
    });

    function deals_bulk_action(button) {
        var checkedIds = [];
        $('.individual:checked').each(function () {
            checkedIds.push($(this).val());
        });

        if (checkedIds.length === 0) {
            alert('<?php echo _l('no_action_selected'); ?>');
            return;
        }

        var massDelete = $('#mass_delete').prop('checked');
        var pipelineId = $('#move_to_pipeline_bulk').val();

        if (massDelete) {
            if (confirm('<?php echo _l('confirm_bulk_delete'); ?>')) {
                // Perform delete action
                $.post(admin_url + 'deals/bulk_delete', { ids: checkedIds }, function (response) {
                    if (response.success) {
                        location.reload();
                    }
                });
            }
        } else if (pipelineId) {
            // Move to pipeline
            $.post(admin_url + 'deals/bulk_move', { ids: checkedIds, pipeline_id: pipelineId }, function (response) {
                if (response.success) {
                    location.reload();
                }
            });
        }
    }
</script>