<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
$CI = &get_instance();
if (!isset($reasons)) {
  $CI->load->model('deals/deals_model');
  $reasons = $CI->deals_model->get_lost_reasons();
}
?>

<div class="panel_s">
  <div class="panel-body">
    <div class="row">
      <div class="col-md-6">
        <div class="input-group">
          <input type="text" id="lost_reason_name" class="form-control" placeholder="<?php echo _l('lost_reason'); ?>">
          <span class="input-group-btn">
            <button class="btn btn-primary" onclick="lrCreate()"><?php echo _l('add'); ?></button>
          </span>
        </div>
        <ul class="list-group tw-mt-3">
          <?php foreach (($reasons ?? []) as $r) { ?>
            <li class="list-group-item tw-flex tw-justify-between tw-items-center">
              <span><?php echo html_entity_decode($r['name']); ?></span>
              <span>
                <button class="btn btn-xs btn-default" onclick="lrEdit(<?php echo (int)$r['id']; ?>,'<?php echo html_escape($r['name']); ?>')"><i class="fa fa-pencil"></i></button>
                <button class="btn btn-xs btn-danger" onclick="lrDelete(<?php echo (int)$r['id']; ?>)"><i class="fa fa-trash"></i></button>
              </span>
            </li>
          <?php } ?>
        </ul>
      </div>
    </div>
  </div>
</div>

<script>
var CSRF = { name: '<?php echo $this->security->get_csrf_token_name(); ?>', value: '<?php echo $this->security->get_csrf_hash(); ?>' };
function lrCreate(){
  var name = document.getElementById('lost_reason_name').value.trim();
  if(!name) return;
  var f = new FormData(); f.append('action','create'); f.append('name', name); f.append(CSRF.name, CSRF.value);
  fetch('<?php echo admin_url('deals/settings/lost_reasons'); ?>',{method:'POST',body:f,credentials:'same-origin'}).then(()=>location.reload());
}
function lrEdit(id, prev){
  var name = prompt('Lost reason', prev || '');
  if(name===null) return;
  var f = new FormData(); f.append('action','update'); f.append('id', id); f.append('name', name); f.append(CSRF.name, CSRF.value);
  fetch('<?php echo admin_url('deals/settings/lost_reasons'); ?>',{method:'POST',body:f,credentials:'same-origin'}).then(()=>location.reload());
}
function lrDelete(id){
  if(!confirm('Delete?')) return;
  var f = new FormData(); f.append('action','delete'); f.append('id', id); f.append(CSRF.name, CSRF.value);
  fetch('<?php echo admin_url('deals/settings/lost_reasons'); ?>',{method:'POST',body:f,credentials:'same-origin'}).then(()=>location.reload());
}
</script>