<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2">
                    <a href="#" onclick="new_business_category(); return false;" class="btn btn-primary">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?= _l('new_business_category'); ?>
                    </a>
                </div>
                <div class="panel_s">
                    <div class="panel-body panel-table-full">
                        <?php if (count($business_categories) > 0) { ?>
                            <table class="table dt-table" data-order-col="1" data-order-type="asc">
                                <thead>
                                    <th><?= _l('id'); ?></th>
                                    <th><?= _l('business_category_name'); ?></th>
                                    <th><?= _l('options'); ?></th>
                                </thead>
                                <tbody>
                                    <?php foreach ($business_categories as $category) { ?>
                                        <tr>
                                            <td><?= e($category['id']); ?></td>
                                            <td><a href="#" class="tw-font-medium"
                                                    onclick="edit_business_category(this,<?= e($category['id']); ?>); return false"
                                                    data-name="<?= e($category['name']); ?>"><?= e($category['name']); ?></a><br />
                                                <span class="text-muted">
                                                    <?= _l('deals_table_total', total_rows(db_prefix() . 'deals', ['business_category' => $category['id']])); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <div class="tw-flex tw-items-center tw-space-x-2">
                                                    <a href="#"
                                                        onclick="edit_business_category(this,<?= e($category['id']); ?>); return false"
                                                        data-name="<?= e($category['name']); ?>"
                                                        class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
                                                        <i class="fa-regular fa-pen-to-square fa-lg"></i>
                                                    </a>
                                                    <a href="<?= admin_url('deals/settings/business_categories?action=delete&id=' . $category['id']); ?>"
                                                        class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                                        <i class="fa-regular fa-trash-can fa-lg"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        <?php } else { ?>
                            <p class="no-margin">
                                <?= _l('business_categories_not_found'); ?>
                            </p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="business_category_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('deals/settings/business_categories')); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?= _l('edit_business_category'); ?></span>
                    <span class="add-title"><?= _l('new_business_category'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?= render_input('name', 'business_category_name'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(function () {
        appValidateForm($('form'), { name: 'required' }, manage_business_categories);
        $('#business_category_modal').on('hidden.bs.modal', function () {
            $('#additional').html('');
            $('input[name="name"]').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });
    });

    function manage_business_categories(form) {
        var data = $(form).serialize();
        var url = form.action;
        $.post(url, data).done(function (response) {
            window.location.reload();
        });
        return false;
    }

    function new_business_category() {
        $('#business_category_modal').modal('show');
        $('.edit-title').addClass('hide');
    }

    function edit_business_category(invoker, id) {
        var name = $(invoker).data('name');
        $('#additional').append(hidden_input('id', id));
        $('input[name="name"]').val(name);
        $('#business_category_modal').modal('show');
        $('.add-title').addClass('hide');
    }
</script>