<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_activity_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <?php echo form_open(admin_url('deals/add_deal_activity/' . $deal_id), ['id' => 'add_activity_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('add_activity'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="title" class="control-label"><?php echo _l('activity_title'); ?> <span class="text-danger">*</span></label>
                    <input type="text" name="title" id="activity_title" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="description" class="control-label"><?php echo _l('activity_description'); ?> <span class="text-danger">*</span></label>
                    <textarea name="description" id="activity_description" class="form-control" rows="4" required></textarea>
                </div>
                <div class="form-group">
                    <label for="type" class="control-label"><?php echo _l('activity_type'); ?></label>
                    <select name="type" id="activity_type" class="form-control">
                        <option value="activity"><?php echo _l('general_activity'); ?></option>
                        <option value="call"><?php echo _l('call'); ?></option>
                        <option value="email"><?php echo _l('email'); ?></option>
                        <option value="meeting"><?php echo _l('meeting'); ?></option>
                        <option value="note"><?php echo _l('note'); ?></option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="date" class="control-label"><?php echo _l('activity_date'); ?></label>
                    <div class="input-group">
                        <input type="text" name="date" id="activity_date" class="form-control datetimepicker" value="<?php echo date('Y-m-d H:i:s'); ?>">
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    appValidateForm($('#add_activity_form'), {
        title: 'required',
        description: 'required'
    });
    
    $('#add_activity_modal').on('hidden.bs.modal', function() {
        $('#add_activity_form')[0].reset();
        $('#activity_date').val('<?php echo date('Y-m-d H:i:s'); ?>');
        $('#activity_type').val('activity');
    });
    
    // Initialize datetimepicker
    if (typeof($.fn.datetimepicker) !== 'undefined') {
        $('#activity_date').datetimepicker({
            format: 'YYYY-MM-DD HH:mm:ss'
        });
    }
});
</script>
