<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_reminder_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <?php echo form_open(admin_url('deals/add_deal_reminder/' . $deal_id), ['id' => 'add_reminder_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('set_deal_reminder'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="date" class="control-label"><?php echo _l('date_to_be_notified'); ?> <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <input type="text" name="date" id="reminder_date" class="form-control datetimepicker" required>
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="notify_by_email" class="control-label"><?php echo _l('set_reminder_to'); ?> <span class="text-danger">*</span></label>
                    <select name="notify_by_email" id="notify_by_email" class="form-control selectpicker" required>
                        <option value=""><?php echo _l('nothing_selected'); ?></option>
                        <?php foreach ($staff as $member) { ?>
                        <option value="<?php echo $member['staffid']; ?>"><?php echo $member['firstname'] . ' ' . $member['lastname']; ?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="description" class="control-label"><?php echo _l('description'); ?> <span class="text-danger">*</span></label>
                    <textarea name="description" id="reminder_description" class="form-control" rows="3" required></textarea>
                </div>
                <div class="checkbox checkbox-primary">
                    <input type="checkbox" name="send_email" id="send_email">
                    <label for="send_email"><?php echo _l('send_also_an_email_for_this_reminder'); ?></label>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    appValidateForm($('#add_reminder_form'), {
        date: 'required',
        notify_by_email: 'required',
        description: 'required'
    });
    
    $('#add_reminder_modal').on('hidden.bs.modal', function() {
        $('#add_reminder_form')[0].reset();
        $('#add_reminder_form .selectpicker').selectpicker('refresh');
    });
    
    // Initialize datetimepicker
    if (typeof($.fn.datetimepicker) !== 'undefined') {
        $('#reminder_date').datetimepicker({
            format: 'YYYY-MM-DD HH:mm',
            minDate: moment()
        });
    }
});
</script>
