<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2">
                    <a href="#" onclick="new_rating(); return false;" class="btn btn-primary">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?= _l('new_rating'); ?>
                    </a>
                </div>
                <div class="panel_s">
                    <div class="panel-body panel-table-full">
                        <?php if (count($ratings) > 0) { ?>
                            <table class="table dt-table" data-order-col="2" data-order-type="desc">
                                <thead>
                                    <th><?= _l('id'); ?></th>
                                    <th><?= _l('name'); ?></th>
                                    <th><?= _l('score'); ?></th>
                                    <th><?= _l('options'); ?></th>
                                </thead>
                                <tbody>
                                    <?php foreach ($ratings as $rating) { ?>
                                        <tr>
                                            <td><?= e($rating['id']); ?></td>
                                            <td><a href="#" class="tw-font-medium"
                                                    onclick="edit_rating(this,<?= e($rating['id']); ?>); return false"
                                                    data-name="<?= e($rating['name']); ?>"
                                                    data-score="<?= e($rating['score']); ?>"><?= e($rating['name']); ?></a></td>
                                            <td><?= e($rating['score']); ?></td>
                                            <td>
                                                <div class="tw-flex tw-items-center tw-space-x-2">
                                                    <a href="#"
                                                        onclick="edit_rating(this,<?= e($rating['id']); ?>); return false"
                                                        data-name="<?= e($rating['name']); ?>" data-score="<?= e($rating['score']); ?>"
                                                        class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
                                                        <i class="fa-regular fa-pen-to-square fa-lg"></i>
                                                    </a>
                                                    <a href="<?= admin_url('deals/settings/ratings?action=delete&id=' . $rating['id']); ?>"
                                                        class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                                        <i class="fa-regular fa-trash-can fa-lg"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        <?php } else { ?>
                            <p class="no-margin">
                                <?= _l('not_found'); ?>
                            </p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="rating_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('deals/settings/ratings')); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?= _l('edit'); ?></span>
                    <span class="add-title"><?= _l('new_rating'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?= render_input('name', 'name'); ?>
                        <?= render_input('score', 'score', '', 'number'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(function () {
        appValidateForm($('form'), { name: 'required', score: 'required' }, manage_ratings);
        $('#rating_modal').on('hidden.bs.modal', function () {
            $('#additional').html('');
            $('input[name="name"]').val('');
            $('input[name="score"]').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });
    });

    function manage_ratings(form) {
        var data = $(form).serialize();
        var url = form.action;
        $.post(url, data).done(function (response) {
            window.location.reload();
        });
        return false;
    }

    function new_rating() {
        $('#rating_modal').modal('show');
        $('.edit-title').addClass('hide');
    }

    function edit_rating(invoker, id) {
        var name = $(invoker).data('name');
        var score = $(invoker).data('score');
        $('#additional').append(hidden_input('id', id));
        $('input[name="name"]').val(name);
        $('input[name="score"]').val(score);
        $('#rating_modal').modal('show');
        $('.add-title').addClass('hide');
    }
</script>


