<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
use app\services\imap\Imap;
use app\services\CampaignProfileBadges;
use app\services\campaigns\CampaignsKanban;
use app\services\imap\ConnectionErrorException;
use Ddeboer\Imap\Exception\MailboxDoesNotExistException;

header('Content-Type: text/html; charset=utf-8');
defined('BASEPATH') or exit('No direct script access allowed');

class Campaigns extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('campaigns_model');
    }

    /* List all campaigns */
public function index($id = '')
{
    close_setup_menu();

    if (!is_staff_member()) {
        access_denied('Campaigns');
    }

    $this->load->model('campaigns_model');
	$id = $this->input->get('from_form_id');
    if (!empty($id)) {
        // SHOW ONLY CAMPAIGNS SUBMITTED FROM THIS FORM ID
        $data['campaigns'] = $this->campaigns_model->get_campaigns_by_form_id($id);
        $data['form_id']   = $id;
        $data['statuses']  = $this->campaigns_model->get_status();
		 $data['table']    = App_table::find('campaigns_form');
		
        $data['title']     = _l('Campaign Submissions from Form');
		//print_r($data['table']); die;
        $this->load->view('admin/campaigns/campaigns_from_form', $data); 
        return;
    }

    // SHOW ALL WEB CAMPAIGN FORMS
    $data['switch_kanban'] = true;
    if ($this->session->userdata('campaigns_kanban_view') == 'true') {
        $data['switch_kanban'] = false;
        $data['bodyclass']     = 'kan-ban-body';
    }

    $data['staff']    = $this->staff_model->get('', ['active' => 1]);
    $data['statuses'] = $this->campaigns_model->get_status();
    $data['sources']  = $this->campaigns_model->get_source();
    $data['summary']  = get_campaigns_summary();
    $data['title']    = _l('Campaign Forms');
    $data['table']    = App_table::find('campaigns');
    $data['campaignid'] = $id;
    $data['isKanBan'] = $this->session->has_userdata('campaigns_kanban_view') &&
                        $this->session->userdata('campaigns_kanban_view') == 'true';

    // Get web_to_campaign data
    $aColumns = [
        db_prefix() . 'web_to_campaign.id',
        db_prefix() . 'web_to_campaign.name',
        db_prefix() . 'web_to_campaign.responsible',
        '(SELECT COUNT(id) FROM ' . db_prefix() . 'campaigns WHERE ' . db_prefix() . 'campaigns.from_form_id = ' . db_prefix() . 'web_to_campaign.id) as total_submissions',
        '(SELECT MAX(dateadded) FROM ' . db_prefix() . 'campaigns WHERE ' . db_prefix() . 'campaigns.from_form_id = ' . db_prefix() . 'web_to_campaign.id) as last_submission_time',
        db_prefix() . 'web_to_campaign.dateadded',
    ];

    $sIndexColumn = 'id';
    $sTable = db_prefix() . 'web_to_campaign';
    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'web_to_campaign.responsible',
    ];

    $additionalSelect = [
        'form_key',
        db_prefix() . 'web_to_campaign.id',
        db_prefix() . 'staff.firstname as staff_firstname',
        db_prefix() . 'staff.lastname as staff_lastname',
    ];

    $where = []; // show all

    $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalSelect);
    $data['web_campaign_forms'] = $result['rResult'];

    $this->load->view('admin/campaigns/manage_campaigns', $data);
}


  /*  public function index($id = '')
    {
        close_setup_menu();

        if (!is_staff_member()) {
            access_denied('Campaigns');
        }

        $data['switch_kanban'] = true;

        if ($this->session->userdata('campaigns_kanban_view') == 'true') {
            $data['switch_kanban'] = false;
            $data['bodyclass']     = 'kan-ban-body';
        }

        $data['staff'] = $this->staff_model->get('', ['active' => 1]);
        if (is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1') {
            $this->load->model('gdpr_model');
            $data['consent_purposes'] = $this->gdpr_model->get_consent_purposes();
        }
        $data['summary']  = get_campaigns_summary();
        $data['statuses'] = $this->campaigns_model->get_status();
        $data['sources']  = $this->campaigns_model->get_source();
        $data['title']    = _l('campaigns');
        $data['table'] = App_table::find('campaigns');
        // in case accesed the url campaigns/index/ directly with id - used in search
        $data['campaignid']   = $id;
        $data['isKanBan'] = $this->session->has_userdata('campaigns_kanban_view') &&
            $this->session->userdata('campaigns_kanban_view') == 'true';

        $this->load->view('admin/campaigns/manage_campaigns', $data);
    } */
public function data_form($form_id = '')
{
    if (!is_staff_member()) {
        ajax_access_denied();
    }

    $this->load->model('campaigns_model');
    $statuses = $this->campaigns_model->get_status();
    $has_permission_delete = staff_can('delete', 'campaigns');
    $lockAfterConvert = get_option('campaign_lock_after_convert_to_customer');

    $aColumns = [
        db_prefix() . 'campaigns.id as id',
        db_prefix() . 'campaigns.name as name',
        db_prefix() . 'campaigns.email as email',
        db_prefix() . 'campaigns.phonenumber as phonenumber',
        'company',
        'campaign_value',
        'firstname as assigned_firstname',
        db_prefix() . 'campaigns_status.name as status_name',
        db_prefix() . 'campaigns_sources.name as source_name',
        'dateadded',
        '1', // Actions placeholder
    ];

    $sIndexColumn = 'id';
    $sTable = db_prefix() . 'campaigns';

    $join = [
        'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'campaigns.assigned',
        'LEFT JOIN ' . db_prefix() . 'campaigns_status ON ' . db_prefix() . 'campaigns_status.id = ' . db_prefix() . 'campaigns.status',
        'JOIN ' . db_prefix() . 'campaigns_sources ON ' . db_prefix() . 'campaigns_sources.id = ' . db_prefix() . 'campaigns.source',
    ];

    $where = [db_prefix() . 'campaigns.from_form_id = ' . $this->db->escape_str($form_id)];

if (staff_cant('view', 'campaigns')) {
    $where[] = '(' . db_prefix() . 'campaigns.assigned =' . get_staff_user_id() . ' OR ' . db_prefix() . 'campaigns.addedfrom = ' . get_staff_user_id() . ' OR ' . db_prefix() . 'campaigns.is_public = 1)';
}

if (!empty($filters) && is_array($filters)) {
    if (!empty($filters['status'])) {
        $status_ids = array_map('intval', (array) $filters['status']);
        $where[] = db_prefix() . 'campaigns.status IN (' . implode(',', $status_ids) . ')';
    }

    if (!empty($filters['source'])) {
        $source_ids = array_map('intval', (array) $filters['source']);
        $where[] = db_prefix() . 'campaigns.source IN (' . implode(',', $source_ids) . ')';
    }

    if (!empty($filters['assigned'])) {
        $assigned_ids = array_map('intval', (array) $filters['assigned']);
        $where[] = db_prefix() . 'campaigns.assigned IN (' . implode(',', $assigned_ids) . ')';
    }

    if (!empty($filters['date_added_from']) && !empty($filters['date_added_to'])) {
        $from = to_sql_date($filters['date_added_from']);
        $to   = to_sql_date($filters['date_added_to']);
        $where[] = "DATE(" . db_prefix() . "campaigns.dateadded) BETWEEN '$from' AND '$to'";
    }
}


    $additionalColumns = [
        'junk',
        'lost',
        'color',
        'status',
        'assigned',
        'lastname as assigned_lastname',
        db_prefix() . 'campaigns.addedfrom as addedfrom',
        '(SELECT count(campaignid) FROM ' . db_prefix() . 'clients WHERE ' . db_prefix() . 'clients.campaignid=' . db_prefix() . 'campaigns.id) as is_converted',
        'zip',
    ];

    $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalColumns);
    $output = $result['output'];
    $rResult = $result['rResult'];

    $output['aaData'] = [];

    foreach ($rResult as $aRow) {
        $row = [];

        $row['id'] = $aRow['id'];
        $row['name'] = '<a href="' . admin_url('campaigns/index/' . $aRow['id']) . '" onclick="init_campaign(' . $aRow['id'] . ');return false;">' . e($aRow['name']) . '</a>';
        $row['email'] = ($aRow['email'] ? '<a href="mailto:' . e($aRow['email']) . '">' . e($aRow['email']) . '</a>' : '');
        $row['phone'] = ($aRow['phonenumber'] ? '<a href="tel:' . e($aRow['phonenumber']) . '">' . e($aRow['phonenumber']) . '</a>' : '');
        $row['company'] = e($aRow['company']);

        $base_currency = get_base_currency();
        $row['value'] = e(($aRow['campaign_value'] != 0 ? app_format_money($aRow['campaign_value'], $base_currency->id) : ''));

        // Assigned
        $assignedOutput = '';
        if ($aRow['assigned'] != 0) {
            $full_name = e($aRow['assigned_firstname'] . ' ' . $aRow['assigned_lastname']);
            $assignedOutput = '<a data-toggle="tooltip" data-title="' . $full_name . '" href="' . admin_url('profile/' . $aRow['assigned']) . '">' . staff_profile_image($aRow['assigned'], ['staff-profile-image-small']) . '</a>';
            $assignedOutput .= '<span class="hide">' . $full_name . '</span>';
        }
        $row['assigned'] = $assignedOutput;

        // Status
        $locked = $aRow['is_converted'] > 0 && !is_admin() && $lockAfterConvert == 1;
        $outputStatus = '';
        if (!$aRow['status_name']) {
            if ($aRow['lost'] == 1) {
                $outputStatus = '<span class="label label-danger">' . _l('campaign_lost') . '</span>';
            } elseif ($aRow['junk'] == 1) {
                $outputStatus = '<span class="label label-warning">' . _l('campaign_junk') . '</span>';
            }
        } else {
            $outputStatus = '<span class="campaign-status-' . $aRow['status'] . ' label" style="color:' . $aRow['color'] . ';border:1px solid ' . adjust_hex_brightness($aRow['color'], 0.4) . ';background: ' . adjust_hex_brightness($aRow['color'], 0.04) . ';">' . e($aRow['status_name']);
            if (!$locked) {
                $outputStatus .= '<div class="dropdown inline-block mleft5 table-export-exclude">';
                $outputStatus .= '<a href="#" style="font-size:14px;vertical-align:middle;" class="dropdown-toggle text-dark" id="tableCampaignsStatus-' . $aRow['id'] . '" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
                $outputStatus .= '<span data-toggle="tooltip" title="' . _l('ticket_single_change_status') . '"><i class="fa fa-chevron-down"></i></span>';
                $outputStatus .= '</a>';
                $outputStatus .= '<ul class="dropdown-menu dropdown-menu-right" aria-labelledby="tableCampaignsStatus-' . $aRow['id'] . '">';
                foreach ($statuses as $s) {
                    if ($s['id'] != $aRow['status']) {
                        $outputStatus .= '<li><a href="#" onclick="campaign_mark_as(' . $s['id'] . ', ' . $aRow['id'] . '); return false;">' . e($s['name']) . '</a></li>';
                    }
                }
                $outputStatus .= '</ul></div>';
            }
            $outputStatus .= '</span>';
        }
        $row['status'] = $outputStatus;

        $row['source'] = e($aRow['source_name']);
        $row['date_added'] = '<span data-toggle="tooltip" data-title="' . e(_dt($aRow['dateadded'])) . '" class="text-has-action is-date">' . e(time_ago($aRow['dateadded'])) . '</span>';

        // Actions
        $actions = '<div class="row-options">';
        $actions .= '<a href="#" onclick="init_campaign(' . $aRow['id'] . '); return false;">' . _l('view') . '</a>';
        if (!$locked) {
            $actions .= ' | <a href="#" onclick="init_campaign(' . $aRow['id'] . ', true); return false;">' . _l('edit') . '</a>';
        }
        if ($aRow['addedfrom'] == get_staff_user_id() || $has_permission_delete) {
            $actions .= ' | <a href="' . admin_url('campaigns/delete/' . $aRow['id']) . '" class="text-danger _delete">' . _l('delete') . '</a>';
        }
        $actions .= '</div>';
        $row['actions'] = $actions;

        $output['aaData'][] = $row;
    }

    echo json_encode($output);
    die();
}

	
   public function table()
	{
		if (!is_staff_member()) {
			ajax_access_denied();
		}

		$table = App_table::find('campaigns');

		$table->output();
	}
	
    public function kanban()
    {
        if (!is_staff_member()) {
            ajax_access_denied();
        }

        $data['statuses']      = $this->campaigns_model->get_status();
        $data['base_currency'] = get_base_currency();
        $data['summary']       = get_campaigns_summary();

        echo $this->load->view('admin/campaigns/kan-ban', $data, true);
    }

    /* Add or update campaign */
    public function campaign($id = '')
    {
        if (!is_staff_member() || ($id != '' && !$this->campaigns_model->staff_can_access_campaign($id))) {
            ajax_access_denied();
        }

        if ($this->input->post()) {
            if ($id == '') {
                $id      = $this->campaigns_model->add($this->input->post());
                $message = $id ? _l('added_successfully', _l('campaign')) : '';

                echo json_encode([
                    'success'  => $id ? true : false,
                    'id'       => $id,
                    'message'  => $message,
                    'campaignView' => $id ? $this->_get_campaign_data($id) : [],
                ]);
            } else {
                $emailOriginal   = $this->db->select('email')->where('id', $id)->get(db_prefix() . 'campaigns')->row()->email;
                $proposalWarning = false;
                $message         = '';
                $success         = $this->campaigns_model->update($this->input->post(), $id);

                if ($success) {
                    $emailNow = $this->db->select('email')->where('id', $id)->get(db_prefix() . 'campaigns')->row()->email;

                    $proposalWarning = (total_rows(db_prefix() . 'proposals', [
                        'rel_type' => 'campaign',
                        'rel_id'   => $id, ]) > 0 && ($emailOriginal != $emailNow) && $emailNow != '') ? true : false;

                    $message = _l('updated_successfully', _l('campaign'));
                }
                echo json_encode([
                    'success'          => $success,
                    'message'          => $message,
                    'id'               => $id,
                    'proposal_warning' => $proposalWarning,
                    'campaignView'         => $this->_get_campaign_data($id),
                ]);
            }
            die;
        }

        echo json_encode([
            'campaignView' => $this->_get_campaign_data($id),
        ]);
    }

    private function _get_campaign_data($id = '')
    {
        $reminder_data         = '';
        $data['campaign_locked']   = false;
        $data['openEdit']      = $this->input->get('edit') ? true : false;
        $data['members']       = $this->staff_model->get('', ['is_not_staff' => 0, 'active' => 1]);
        $data['status_id']     = $this->input->get('status_id') ? $this->input->get('status_id') : get_option('campaigns_default_status');
        $data['base_currency'] = get_base_currency();

        if (is_numeric($id)) {
            $campaignWhere = (staff_can('view',  'campaigns') ? [] : '(assigned = ' . get_staff_user_id() . ' OR addedfrom=' . get_staff_user_id() . ' OR is_public=1)');

            $campaign = $this->campaigns_model->get($id, $campaignWhere);

            if (!$campaign) {
                header('HTTP/1.0 404 Not Found');
                echo _l('campaign_not_found');
                die;
            }

            if (total_rows(db_prefix() . 'clients', ['campaignid' => $id ]) > 0) {
                $data['campaign_locked'] = ((!is_admin() && get_option('campaign_lock_after_convert_to_customer') == 1) ? true : false);
            }

            $reminder_data = $this->load->view('admin/includes/modals/reminder', [
                    'id'             => $campaign->id,
                    'name'           => 'campaign',
                    'members'        => $data['members'],
                    'reminder_title' => _l('campaign_set_reminder_title'),
                ], true);

            $data['campaign']          = $campaign;
            $data['mail_activity'] = $this->campaigns_model->get_mail_activity($id);
            $data['notes']         = $this->misc_model->get_notes($id, 'campaign');
            $data['activity_log']  = $this->campaigns_model->get_campaign_activity_log($id);

            if (is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1') {
                $this->load->model('gdpr_model');
                $data['purposes'] = $this->gdpr_model->get_consent_purposes($campaign->id, 'campaign');
                $data['consents'] = $this->gdpr_model->get_consents(['campaign_id' => $campaign->id]);
            }

            $campaignProfileBadges         = new CampaignProfileBadges($id);
            $data['total_reminders']   = $campaignProfileBadges->getCount('reminders');
            $data['total_notes']       = $campaignProfileBadges->getCount('notes');
            $data['total_attachments'] = $campaignProfileBadges->getCount('attachments');
            $data['total_tasks']       = $campaignProfileBadges->getCount('tasks');
            $data['total_proposals']   = $campaignProfileBadges->getCount('proposals');
        }


        $data['statuses'] = $this->campaigns_model->get_status();
        $data['sources']  = $this->campaigns_model->get_source();

        $data = hooks()->apply_filters('campaign_view_data', $data);

        return [
            'data'          => $this->load->view('admin/campaigns/campaign', $data, true),
            'reminder_data' => $reminder_data,
        ];
    }

    public function campaigns_kanban_load_more()
    {
        if (!is_staff_member()) {
            ajax_access_denied();
        }

        $status = $this->input->get('status');
        $page   = $this->input->get('page');

        $this->db->where('id', $status);
        $status = $this->db->get(db_prefix() . 'campaigns_status')->row_array();

        $campaigns = (new CampaignsKanban($status['id']))
        ->search($this->input->get('search'))
        ->sortBy(
            $this->input->get('sort_by'),
            $this->input->get('sort')
        )
        ->page($page)->get();

        foreach ($campaigns as $campaign) {
            $this->load->view('admin/campaigns/_kan_ban_card', [
                'campaign'   => $campaign,
                'status' => $status,
            ]);
        }
    }

    public function switch_kanban($set = 0)
    {
        if ($set == 1) {
            $set = 'true';
        } else {
            $set = 'false';
        }
        $this->session->set_userdata([
            'campaigns_kanban_view' => $set,
        ]);
        redirect(previous_url() ?: $_SERVER['HTTP_REFERER']);
    }

    public function export($id)
    {
        if (is_admin()) {
            $this->load->library('gdpr/gdpr_campaign');
            $this->gdpr_campaign->export($id);
        }
    }

    /* Delete campaign from database */
    public function delete($id)
    {
        if (!$id) {
            redirect(admin_url('campaigns'));
        }

        if (staff_cant('delete', 'campaigns')) {
            access_denied('Delete Campaign');
        }

        $response = $this->campaigns_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('campaign_lowercase')));
        } elseif ($response === true) {
            set_alert('success', _l('deleted', _l('campaign')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('campaign_lowercase')));
        }

        $ref = $_SERVER['HTTP_REFERER'];

        // if user access campaigns/inded/ID to prevent redirecting on the same url because will throw 404
        if (!$ref || strpos($ref, 'index/' . $id) !== false) {
            redirect(admin_url('campaigns'));
        }

        redirect($ref);
    }

    public function mark_as_lost($id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($id)) {
            ajax_access_denied();
        }
        $message = '';
        $success = $this->campaigns_model->mark_as_lost($id);
        if ($success) {
            $message = _l('campaign_marked_as_lost');
        }
        echo json_encode([
            'success'  => $success,
            'message'  => $message,
            'campaignView' => $this->_get_campaign_data($id),
            'id'       => $id,
        ]);
    }

    public function unmark_as_lost($id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($id)) {
            ajax_access_denied();
        }
        $message = '';
        $success = $this->campaigns_model->unmark_as_lost($id);
        if ($success) {
            $message = _l('campaign_unmarked_as_lost');
        }
        echo json_encode([
            'success'  => $success,
            'message'  => $message,
            'campaignView' => $this->_get_campaign_data($id),
            'id'       => $id,
        ]);
    }

    public function mark_as_junk($id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($id)) {
            ajax_access_denied();
        }
        $message = '';
        $success = $this->campaigns_model->mark_as_junk($id);
        if ($success) {
            $message = _l('campaign_marked_as_junk');
        }
        echo json_encode([
            'success'  => $success,
            'message'  => $message,
            'campaignView' => $this->_get_campaign_data($id),
            'id'       => $id,
        ]);
    }

    public function unmark_as_junk($id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($id)) {
            ajax_access_denied();
        }
        $message = '';
        $success = $this->campaigns_model->unmark_as_junk($id);
        if ($success) {
            $message = _l('campaign_unmarked_as_junk');
        }
        echo json_encode([
            'success'  => $success,
            'message'  => $message,
            'campaignView' => $this->_get_campaign_data($id),
            'id'       => $id,
        ]);
    }

    public function add_activity()
    {
        $campaignid = $this->input->post('campaignid');
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($campaignid)) {
            ajax_access_denied();
        }
        if ($this->input->post()) {
            $message = $this->input->post('activity');
            $aId     = $this->campaigns_model->log_campaign_activity($campaignid, $message);
            if ($aId) {
                $this->db->where('id', $aId);
                $this->db->update(db_prefix() . 'campaign_activity_log', ['custom_activity' => 1]);
            }
            echo json_encode(['campaignView' => $this->_get_campaign_data($campaignid), 'id' => $campaignid]);
        }
    }

    public function get_convert_data($id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($id)) {
            ajax_access_denied();
        }
        if (is_gdpr() && get_option('gdpr_enable_consent_for_contacts') == '1') {
            $this->load->model('gdpr_model');
            $data['purposes'] = $this->gdpr_model->get_consent_purposes($id, 'campaign');
        }
        $data['campaign'] = $this->campaigns_model->get($id);
        $this->load->view('admin/campaigns/convert_to_customer', $data);
    }

    /**
     * Convert campaign to client
     * @since  version 1.0.1
     * @return mixed
     */
    public function convert_to_customer()
    {
        if (!is_staff_member()) {
            access_denied('Campaign Convert to Customer');
        }

        if ($this->input->post()) {
            $default_country  = get_option('customer_default_country');
            $data             = $this->input->post();
            $data['password'] = $this->input->post('password', false);

            $original_campaign_email = $data['original_campaign_email'];
            unset($data['original_campaign_email']);

            if (isset($data['transfer_notes'])) {
                $notes = $this->misc_model->get_notes($data['campaignid'], 'campaign');
                unset($data['transfer_notes']);
            }

            if (isset($data['transfer_consent'])) {
                $this->load->model('gdpr_model');
                $consents = $this->gdpr_model->get_consents(['campaign_id' => $data['campaignid']]);
                unset($data['transfer_consent']);
            }

            if (isset($data['merge_db_fields'])) {
                $merge_db_fields = $data['merge_db_fields'];
                unset($data['merge_db_fields']);
            }

            if (isset($data['merge_db_contact_fields'])) {
                $merge_db_contact_fields = $data['merge_db_contact_fields'];
                unset($data['merge_db_contact_fields']);
            }

            if (isset($data['include_campaigns_custom_fields'])) {
                $include_campaigns_custom_fields = $data['include_campaigns_custom_fields'];
                unset($data['include_campaigns_custom_fields']);
            }

            if ($data['country'] == '' && $default_country != '') {
                $data['country'] = $default_country;
            }

            $data['billing_street']  = $data['address'];
            $data['billing_city']    = $data['city'];
            $data['billing_state']   = $data['state'];
            $data['billing_zip']     = $data['zip'];
            $data['billing_country'] = $data['country'];

            $data['is_primary'] = 1;
            $id                 = $this->clients_model->add($data, true);
            if ($id) {
                $primary_contact_id = get_primary_contact_user_id($id);

                if (isset($notes)) {
                    foreach ($notes as $note) {
                        $this->db->insert(db_prefix() . 'notes', [
                            'rel_id'         => $id,
                            'rel_type'       => 'customer',
                            'dateadded'      => $note['dateadded'],
                            'addedfrom'      => $note['addedfrom'],
                            'description'    => $note['description'],
                            'date_contacted' => $note['date_contacted'],
                            ]);
                    }
                }
                if (isset($consents)) {
                    foreach ($consents as $consent) {
                        unset($consent['id']);
                        unset($consent['purpose_name']);
                        $consent['campaign_id']    = 0;
                        $consent['contact_id'] = $primary_contact_id;
                        $this->gdpr_model->add_consent($consent);
                    }
                }
                if (staff_cant('view', 'customers') && get_option('auto_assign_customer_admin_after_campaign_convert') == 1) {
                    $this->db->insert(db_prefix() . 'customer_admins', [
                        'date_assigned' => date('Y-m-d H:i:s'),
                        'customer_id'   => $id,
                        'staff_id'      => get_staff_user_id(),
                    ]);
                }
                $this->campaigns_model->log_campaign_activity($data['campaignid'], 'not_campaign_activity_converted', false, serialize([
                    get_staff_full_name(),
                ]));
                $default_status = $this->campaigns_model->get_status('', [
                    'isdefault' => 1,
                ]);
                $this->db->where('id', $data['campaignid']);
                $this->db->update(db_prefix() . 'campaigns', [
                    'date_converted' => date('Y-m-d H:i:s'),
                    'status'         => $default_status[0]['id'],
                    'junk'           => 0,
                    'lost'           => 0,
                ]);
                // Check if campaign email is different then client email
                $contact = $this->clients_model->get_contact(get_primary_contact_user_id($id));
                if ($contact->email != $original_campaign_email) {
                    if ($original_campaign_email != '') {
                        $this->campaigns_model->log_campaign_activity($data['campaignid'], 'not_campaign_activity_converted_email', false, serialize([
                            $original_campaign_email,
                            $contact->email,
                        ]));
                    }
                }
                if (isset($include_campaigns_custom_fields)) {
                    foreach ($include_campaigns_custom_fields as $fieldid => $value) {
                        // checked don't merge
                        if ($value == 5) {
                            continue;
                        }
                        // get the value of this campaigns custom fiel
                        $this->db->where('relid', $data['campaignid']);
                        $this->db->where('fieldto', 'campaigns');
                        $this->db->where('fieldid', $fieldid);
                        $campaign_custom_field_value = $this->db->get(db_prefix() . 'customfieldsvalues')->row()->value;
                        // Is custom field for contact ot customer
                        if ($value == 1 || $value == 4) {
                            if ($value == 4) {
                                $field_to = 'contacts';
                            } else {
                                $field_to = 'customers';
                            }
                            $this->db->where('id', $fieldid);
                            $field = $this->db->get(db_prefix() . 'customfields')->row();
                            // check if this field exists for custom fields
                            $this->db->where('fieldto', $field_to);
                            $this->db->where('name', $field->name);
                            $exists               = $this->db->get(db_prefix() . 'customfields')->row();
                            $copy_custom_field_id = null;
                            if ($exists) {
                                $copy_custom_field_id = $exists->id;
                            } else {
                                // there is no name with the same custom field for campaigns at the custom side create the custom field now
                                $this->db->insert(db_prefix() . 'customfields', [
                                    'fieldto'        => $field_to,
                                    'name'           => $field->name,
                                    'required'       => $field->required,
                                    'type'           => $field->type,
                                    'options'        => $field->options,
                                    'display_inline' => $field->display_inline,
                                    'field_order'    => $field->field_order,
                                    'slug'           => slug_it($field_to . '_' . $field->name, [
                                        'separator' => '_',
                                    ]),
                                    'active'        => $field->active,
                                    'only_admin'    => $field->only_admin,
                                    'show_on_table' => $field->show_on_table,
                                    'bs_column'     => $field->bs_column,
                                ]);
                                $new_customer_field_id = $this->db->insert_id();
                                if ($new_customer_field_id) {
                                    $copy_custom_field_id = $new_customer_field_id;
                                }
                            }
                            if ($copy_custom_field_id != null) {
                                $insert_to_custom_field_id = $id;
                                if ($value == 4) {
                                    $insert_to_custom_field_id = get_primary_contact_user_id($id);
                                }
                                $this->db->insert(db_prefix() . 'customfieldsvalues', [
                                    'relid'   => $insert_to_custom_field_id,
                                    'fieldid' => $copy_custom_field_id,
                                    'fieldto' => $field_to,
                                    'value'   => $campaign_custom_field_value,
                                ]);
                            }
                        } elseif ($value == 2) {
                            if (isset($merge_db_fields)) {
                                $db_field = $merge_db_fields[$fieldid];
                                // in case user don't select anything from the db fields
                                if ($db_field == '') {
                                    continue;
                                }
                                if ($db_field == 'country' || $db_field == 'shipping_country' || $db_field == 'billing_country') {
                                    $this->db->where('iso2', $campaign_custom_field_value);
                                    $this->db->or_where('short_name', $campaign_custom_field_value);
                                    $this->db->or_like('long_name', $campaign_custom_field_value);
                                    $country = $this->db->get(db_prefix() . 'countries')->row();
                                    if ($country) {
                                        $campaign_custom_field_value = $country->country_id;
                                    } else {
                                        $campaign_custom_field_value = 0;
                                    }
                                }
                                $this->db->where('userid', $id);
                                $this->db->update(db_prefix() . 'clients', [
                                    $db_field => $campaign_custom_field_value,
                                ]);
                            }
                        } elseif ($value == 3) {
                            if (isset($merge_db_contact_fields)) {
                                $db_field = $merge_db_contact_fields[$fieldid];
                                if ($db_field == '') {
                                    continue;
                                }
                                $this->db->where('id', $primary_contact_id);
                                $this->db->update(db_prefix() . 'contacts', [
                                    $db_field => $campaign_custom_field_value,
                                ]);
                            }
                        }
                    }
                }
                // set the campaign to status client in case is not status client
                $this->db->where('isdefault', 1);
                $status_client_id = $this->db->get(db_prefix() . 'campaigns_status')->row()->id;
                $this->db->where('id', $data['campaignid']);
                $this->db->update(db_prefix() . 'campaigns', [
                    'status' => $status_client_id,
                ]);

                set_alert('success', _l('campaign_to_client_base_converted_success'));

                if (is_gdpr() && get_option('gdpr_after_campaign_converted_delete') == '1') {
                    // When campaign is deleted
                    // move all proposals to the actual customer record
                    $this->db->where('rel_id', $data['campaignid']);
                    $this->db->where('rel_type', 'campaign');
                    $this->db->update('proposals', [
                        'rel_id'   => $id,
                        'rel_type' => 'customer',
                    ]);

                    $this->campaigns_model->delete($data['campaignid']);

                    $this->db->where('userid', $id);
                    $this->db->update(db_prefix() . 'clients', ['campaignid' => null]);
                }

                log_activity('Created Campaign Client Profile [CampaignID: ' . $data['campaignid'] . ', ClientID: ' . $id . ']');
                hooks()->do_action('campaign_converted_to_customer', ['campaign_id' => $data['campaignid'], 'customer_id' => $id]);
                redirect(admin_url('clients/client/' . $id));
            }
        }
    }

    /* Used in kanban when dragging and mark as */
    public function update_campaign_status()
    {
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->campaigns_model->update_campaign_status($this->input->post());
        }
    }

    public function update_status_order()
    {
        if ($post_data = $this->input->post()) {
            $this->campaigns_model->update_status_order($post_data);
        }
    }

    public function add_campaign_attachment()
    {
        $id       = $this->input->post('id');
        $lastFile = $this->input->post('last_file');

        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($id)) {
            ajax_access_denied();
        }

        handle_campaign_attachments($id);
        echo json_encode(['campaignView' => $lastFile ? $this->_get_campaign_data($id) : [], 'id' => $id]);
    }

    public function add_external_attachment()
    {
        if ($this->input->post()) {
            $this->campaigns_model->add_attachment_to_database(
                $this->input->post('campaign_id'),
                $this->input->post('files'),
                $this->input->post('external')
            );
        }
    }

    public function delete_attachment($id, $campaign_id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($campaign_id)) {
            ajax_access_denied();
        }
        echo json_encode([
            'success'  => $this->campaigns_model->delete_campaign_attachment($id),
            'campaignView' => $this->_get_campaign_data($campaign_id),
            'id'       => $campaign_id,
        ]);
    }

    public function delete_note($id, $campaign_id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($campaign_id)) {
            ajax_access_denied();
        }
        echo json_encode([
            'success'  => $this->misc_model->delete_note($id),
            'campaignView' => $this->_get_campaign_data($campaign_id),
            'id'       => $campaign_id,
        ]);
    }

    public function update_all_proposal_emails_linked_to_campaign($id)
    {
        $success = false;
        $email   = '';
        if ($this->input->post('update')) {
            $this->load->model('proposals_model');

            $this->db->select('email');
            $this->db->where('id', $id);
            $email = $this->db->get(db_prefix() . 'campaigns')->row()->email;

            $proposals = $this->proposals_model->get('', [
                'rel_type' => 'campaign',
                'rel_id'   => $id,
            ]);
            $affected_rows = 0;

            foreach ($proposals as $proposal) {
                $this->db->where('id', $proposal['id']);
                $this->db->update(db_prefix() . 'proposals', [
                    'email' => $email,
                ]);
                if ($this->db->affected_rows() > 0) {
                    $affected_rows++;
                }
            }

            if ($affected_rows > 0) {
                $success = true;
            }
        }

        echo json_encode([
            'success' => $success,
            'message' => _l('proposals_emails_updated', [
                _l('campaign_lowercase'),
                $email,
            ]),
        ]);
    }

    public function save_form_data()
    {
        $data = $this->input->post();

        // form data should be always sent to the request and never should be empty
        // this code is added to prevent losing the old form in case any errors
        if (!isset($data['formData']) || isset($data['formData']) && !$data['formData']) {
            echo json_encode([
                'success' => false,
            ]);
            die;
        }

        // If user paste with styling eq from some editor word and the Codeigniter XSS feature remove and apply xss=remove, may break the json.
        $data['formData'] = preg_replace('/=\\\\/m', "=''", $data['formData']);

        $this->db->where('id', $data['id']);
        $this->db->update(db_prefix() . 'web_to_campaign', [
            'form_data' => $data['formData'],
        ]);
        if ($this->db->affected_rows() > 0) {
            echo json_encode([
                'success' => true,
                'message' => _l('updated_successfully', _l('web_to_campaign_form')),
            ]);
        } else {
            echo json_encode([
                'success' => false,
            ]);
        }
    }

    public function form($id = '')
    {
        if (!is_admin()) {
            access_denied('Web To Campaign Access');
        }
        if ($this->input->post()) {
            if ($id == '') {
                $data = $this->input->post();
				
                $id   = $this->campaigns_model->add_form($data);
				
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('web_to_campaign_form')));
                    redirect(admin_url('campaigns/form/' . $id));
                }
            } else {
                $success = $this->campaigns_model->update_form($id, $this->input->post());
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('web_to_campaign_form')));
                }
                redirect(admin_url('campaigns/form/' . $id));
            }
        }

        $data['formData'] = [];
        $custom_fields    = get_custom_fields('campaigns', 'type != "link"');

        $cfields       = format_external_form_custom_fields($custom_fields);
        $data['title'] = _l('web_to_campaign');

        if ($id != '') {
            $data['form'] = $this->campaigns_model->get_form([
                'id' => $id,
            ]);
            $data['title']    = $data['form']->name . ' - ' . _l('web_to_campaign_form');
            $data['formData'] = $data['form']->form_data;
        }

        $this->load->model('roles_model');
        $data['roles']    = $this->roles_model->get();
        $data['sources']  = $this->campaigns_model->get_source();
        $data['statuses'] = $this->campaigns_model->get_status();

        $data['members'] = $this->staff_model->get('', [
            'active'       => 1,
            'is_not_staff' => 0,
        ]);

		$this->db->select('userid, company');
		$this->db->where('active', 1);
		$data['clients'] = $this->db->get(db_prefix() . 'clients')->result_array();
		
        $data['languages'] = $this->app->get_available_languages();
        $data['cfields']   = $cfields;

        $db_fields = [];
        $fields    = [
            'name',
            'title',
            'email',
            'phonenumber',
            'campaign_value',
            'company',
            'address',
            'city',
            'state',
            'country',
            'zip',
            'description',
            'website',
        ];

        $fields = hooks()->apply_filters('campaign_form_available_database_fields', $fields);

        $className = 'form-control';

        foreach ($fields as $f) {
            $_field_object = new stdClass();
            $type          = 'text';
            $subtype       = '';
            if ($f == 'email') {
                $subtype = 'email';
            } elseif ($f == 'description' || $f == 'address') {
                $type = 'textarea';
            } elseif ($f == 'country') {
                $type = 'select';
            }

            if ($f == 'name') {
                $label = _l('campaign_add_edit_name');
            } elseif ($f == 'email') {
                $label = _l('campaign_add_edit_email');
            } elseif ($f == 'phonenumber') {
                $label = _l('campaign_add_edit_phonenumber');
            } elseif ($f == 'campaign_value') {
                $label = _l('campaign_add_edit_campaign_value');
                $type  = 'number';
            } else {
                $label = _l('campaign_' . $f);
            }

            $field_array = [
                'subtype'   => $subtype,
                'type'      => $type,
                'label'     => $label,
                'className' => $className,
                'name'      => $f,
            ];

            if ($f == 'country') {
                $field_array['values'] = [];

                $field_array['values'][] = [
                    'label'    => '',
                    'value'    => '',
                    'selected' => false,
                ];

                $countries = get_all_countries();
                foreach ($countries as $country) {
                    $selected = false;
                    if (get_option('customer_default_country') == $country['country_id']) {
                        $selected = true;
                    }
                    array_push($field_array['values'], [
                        'label'    => $country['short_name'],
                        'value'    => (int) $country['country_id'],
                        'selected' => $selected,
                    ]);
                }
            }

            if ($f == 'name') {
                $field_array['required'] = true;
            }

            $_field_object->label    = $label;
            $_field_object->name     = $f;
            $_field_object->fields   = [];
            $_field_object->fields[] = $field_array;
            $db_fields[]             = $_field_object;
        }
        $data['bodyclass'] = 'web-to-campaign-form';
        $data['db_fields'] = $db_fields;
        $this->load->view('admin/campaigns/formbuilder', $data);
    }

    public function forms($id = '')
    {
        if (!is_admin()) {
            access_denied('Web To Campaign Access');
        }

        if ($this->input->is_ajax_request()) {			
           $this->app->get_table_data('web_to_campaign');			
        }

        $data['title'] = _l('web_to_campaign');
		
        $this->load->view('admin/campaigns/forms', $data);
    }

    public function delete_form($id)
    {
        if (!is_admin()) {
            access_denied('Web To Campaign Access');
        }

        $success = $this->campaigns_model->delete_form($id);
        if ($success) {
            set_alert('success', _l('deleted', _l('web_to_campaign_form')));
        }

        redirect(admin_url('campaigns/forms'));
    }

    // Sources
    /* Manage campaigns sources */
    public function sources()
    {
        if (!is_admin()) {
            access_denied('Campaigns Sources');
        }
        $data['sources'] = $this->campaigns_model->get_source();
        $data['title']   = 'Campaigns sources';
        $this->load->view('admin/campaigns/manage_sources', $data);
    }

    /* Add or update campaigns sources */
    public function source()
    {
        if (!is_admin() && get_option('staff_members_create_inline_campaign_source') == '0') {
            access_denied('Campaigns Sources');
        }
        if ($this->input->post()) {
            $data = $this->input->post();
            if (!$this->input->post('id')) {
                $inline = isset($data['inline']);
                if (isset($data['inline'])) {
                    unset($data['inline']);
                }

                $id = $this->campaigns_model->add_source($data);

                if (!$inline) {
                    if ($id) {
                        set_alert('success', _l('added_successfully', _l('campaign_source')));
                    }
                } else {
                    echo json_encode(['success' => $id ? true : false, 'id' => $id]);
                }
            } else {
                $id = $data['id'];
                unset($data['id']);
                $success = $this->campaigns_model->update_source($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('campaign_source')));
                }
            }
        }
    }

    /* Delete campaigns source */
    public function delete_source($id)
    {
        if (!is_admin()) {
            access_denied('Delete Campaign Source');
        }
        if (!$id) {
            redirect(admin_url('campaigns/sources'));
        }
        $response = $this->campaigns_model->delete_source($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('campaign_source_lowercase')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('campaign_source')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('campaign_source_lowercase')));
        }
        redirect(admin_url('campaigns/sources'));
    }

    // Statuses
    /* View campaigns statuses */
    public function statuses()
    {
        if (!is_admin()) {
            access_denied('Campaigns Statuses');
        }
        $data['statuses'] = $this->campaigns_model->get_status();
        $data['title']    = 'Campaigns statuses';
        $this->load->view('admin/campaigns/manage_statuses', $data);
    }

    /* Add or update campaigns status */
    public function status()
    {
        if (!is_admin() && get_option('staff_members_create_inline_campaign_status') == '0') {
            access_denied('Campaigns Statuses');
        }
        if ($this->input->post()) {
            $data = $this->input->post();
            if (!$this->input->post('id')) {
                $inline = isset($data['inline']);
                if (isset($data['inline'])) {
                    unset($data['inline']);
                }
                $id = $this->campaigns_model->add_status($data);
                if (!$inline) {
                    if ($id) {
                        set_alert('success', _l('added_successfully', _l('campaign_status')));
                    }
                } else {
                    echo json_encode(['success' => $id ? true : false, 'id' => $id]);
                }
            } else {
                $id = $data['id'];
                unset($data['id']);
                $success = $this->campaigns_model->update_status($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('campaign_status')));
                }
            }
        }
    }

    /* Delete campaigns status from databae */
    public function delete_status($id)
    {
        if (!is_admin()) {
            access_denied('Campaigns Statuses');
        }
        if (!$id) {
            redirect(admin_url('campaigns/statuses'));
        }
        $response = $this->campaigns_model->delete_status($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('campaign_status_lowercase')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('campaign_status')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('campaign_status_lowercase')));
        }
        redirect(admin_url('campaigns/statuses'));
    }

    /* Add new campaign note */
    public function add_note($rel_id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($rel_id)) {
            ajax_access_denied();
        }

        if ($this->input->post()) {
            $data = $this->input->post();

            if ($data['contacted_indicator'] == 'yes') {
                $contacted_date         = to_sql_date($data['custom_contact_date'], true);
                $data['date_contacted'] = $contacted_date;
            }

            unset($data['contacted_indicator']);
            unset($data['custom_contact_date']);

            // Causing issues with duplicate ID or if my prefixed file for campaign.php is used
            $data['description'] = isset($data['campaign_note_description']) ? $data['campaign_note_description'] : $data['description'];

            if (isset($data['campaign_note_description'])) {
                unset($data['campaign_note_description']);
            }

            $note_id = $this->misc_model->add_note($data, 'campaign', $rel_id);

            if ($note_id) {
                if (isset($contacted_date)) {
                    $this->db->where('id', $rel_id);
                    $this->db->update(db_prefix() . 'campaigns', [
                        'lastcontact' => $contacted_date,
                    ]);
                    if ($this->db->affected_rows() > 0) {
                        $this->campaigns_model->log_campaign_activity($rel_id, 'not_campaign_activity_contacted', false, serialize([
                            get_staff_full_name(get_staff_user_id()),
                            _dt($contacted_date),
                        ]));
                    }
                }
            }
        }
        echo json_encode(['campaignView' => $this->_get_campaign_data($rel_id), 'id' => $rel_id]);
    }

    public function email_integration_folders()
    {
        if (!is_admin()) {
            ajax_access_denied('Campaigns Test Email Integration');
        }

        app_check_imap_open_function();

        $imap = new Imap(
            $this->input->post('email'),
            $this->input->post('password', false),
            $this->input->post('imap_server'),
            $this->input->post('encryption')
        );

        try {
            echo json_encode($imap->getSelectableFolders());
        } catch (ConnectionErrorException $e) {
            echo json_encode([
                'alert_type' => 'warning',
                'message'    => $e->getMessage(),
            ]);
        }
    }

    public function test_email_integration()
    {
        if (!is_admin()) {
            access_denied('Campaigns Test Email Integration');
        }

        app_check_imap_open_function(admin_url('campaigns/email_integration'));

        $mail     = $this->campaigns_model->get_email_integration();
        $password = $mail->password;

        if (false == $this->encryption->decrypt($password)) {
            set_alert('danger', _l('failed_to_decrypt_password'));
            redirect(admin_url('campaigns/email_integration'));
        }

        $imap = new Imap(
            $mail->email,
            $this->encryption->decrypt($password),
            $mail->imap_server,
            $mail->encryption
        );

        try {
            $connection = $imap->testConnection();

            try {
                $connection->getMailbox($mail->folder);
                set_alert('success', _l('campaign_email_connection_ok'));
            } catch (MailboxDoesNotExistException $e) {
                set_alert('danger', str_replace(["\n", 'Mailbox'], ['<br />', 'Folder'], addslashes($e->getMessage())));
            }
        } catch (ConnectionErrorException $e) {
            $error = str_replace("\n", '<br />', addslashes($e->getMessage()));
            set_alert('danger', _l('campaign_email_connection_not_ok') . '<br /><br /><b>' . $error . '</b>');
        }

        redirect(admin_url('campaigns/email_integration'));
    }

    public function email_integration()
    {
        if (!is_admin()) {
            access_denied('Campaigns Email Intregration');
        }
        if ($this->input->post()) {
            $data             = $this->input->post();
            $data['password'] = $this->input->post('password', false);

            if (isset($data['fakeusernameremembered'])) {
                unset($data['fakeusernameremembered']);
            }
            if (isset($data['fakepasswordremembered'])) {
                unset($data['fakepasswordremembered']);
            }

            $success = $this->campaigns_model->update_email_integration($data);
            if ($success) {
                set_alert('success', _l('campaigns_email_integration_updated'));
            }
            redirect(admin_url('campaigns/email_integration'));
        }
        $data['roles']    = $this->roles_model->get();		
        $data['sources']  = $this->campaigns_model->get_source();		
        $data['statuses'] = $this->campaigns_model->get_status();

        $data['members'] = $this->staff_model->get('', [
            'active'       => 1,
            'is_not_staff' => 0,
        ]);

        $data['title'] = _l('campaigns_email_integration');
		
        $data['mail']  = $this->campaigns_model->get_email_integration();

        $data['bodyclass'] = 'campaigns-email-integration';
		
        $this->load->view('admin/campaigns/email_integration', $data);
    }

    public function change_status_color()
    {
        if ($this->input->post() && is_admin()) {
            $this->campaigns_model->change_status_color($this->input->post());
        }
    }

    public function import()
    {
        if (!is_admin() && get_option('allow_non_admin_members_to_import_campaigns') != '1') {
            access_denied('Campaigns Import');
        }

        $dbFields = $this->db->list_fields(db_prefix() . 'campaigns');
        array_push($dbFields, 'tags');

        $this->load->library('import/import_campaigns', [], 'import');
        $this->import->setDatabaseFields($dbFields)
        ->setCustomFields(get_custom_fields('campaigns'));

        if ($this->input->post('download_sample') === 'true') {
            $this->import->downloadSample();
        }

        if ($this->input->post()
            && isset($_FILES['file_csv']['name']) && $_FILES['file_csv']['name'] != '') {
            $this->import->setSimulation($this->input->post('simulate'))
                          ->setTemporaryFileLocation($_FILES['file_csv']['tmp_name'])
                          ->setFilename($_FILES['file_csv']['name'])
                          ->perform();

            $data['total_rows_post'] = $this->import->totalRows();

            if (!$this->import->isSimulation()) {
                set_alert('success', _l('import_total_imported', $this->import->totalImported()));
            }
        }

        $data['statuses'] = $this->campaigns_model->get_status();
        $data['sources']  = $this->campaigns_model->get_source();
        $data['members']  = $this->staff_model->get('', ['is_not_staff' => 0, 'active' => 1]);

        $data['title'] = _l('import');
        $this->load->view('admin/campaigns/import', $data);
    }

    public function validate_unique_field()
    {
        if ($this->input->post()) {

            // First we need to check if the field is the same
            $campaign_id = $this->input->post('campaign_id');
            $field   = $this->input->post('field');
            $value   = $this->input->post($field);

            if ($campaign_id != '') {
                $this->db->select($field);
                $this->db->where('id', $campaign_id);
                $row = $this->db->get(db_prefix() . 'campaigns')->row();
                if ($row->{$field} == $value) {
                    echo json_encode(true);
                    die();
                }
            }

            echo total_rows(db_prefix() . 'campaigns', [ $field => $value ]) > 0 ? 'false' : 'true';
        }
    }

    public function bulk_action()
    {
        if (!is_staff_member()) {
            ajax_access_denied();
        }

        hooks()->do_action('before_do_bulk_action_for_campaigns');
        $total_deleted = 0;
        if ($this->input->post()) {
            $ids                   = $this->input->post('ids');
            $status                = $this->input->post('status');
            $source                = $this->input->post('source');
            $assigned              = $this->input->post('assigned');
            $visibility            = $this->input->post('visibility');
            $tags                  = $this->input->post('tags');
            $last_contact          = $this->input->post('last_contact');
            $lost                  = $this->input->post('lost');
            $has_permission_delete = staff_can('delete',  'campaigns');
            if (is_array($ids)) {
                foreach ($ids as $id) {
                    if ($this->input->post('mass_delete')) {
                        if ($has_permission_delete) {
                            if ($this->campaigns_model->delete($id)) {
                                $total_deleted++;
                            }
                        }
                    } else {
                        if ($status || $source || $assigned || $last_contact || $visibility) {
                            $update = [];
                            if ($status) {
                                // We will use the same function to update the status
                                $this->campaigns_model->update_campaign_status([
                                    'status' => $status,
                                    'campaignid' => $id,
                                ]);
                            }
                            if ($source) {
                                $update['source'] = $source;
                            }
                            if ($assigned) {
                                $update['assigned'] = $assigned;
                            }
                            if ($last_contact) {
                                $last_contact          = to_sql_date($last_contact, true);
                                $update['lastcontact'] = $last_contact;
                            }

                            if ($visibility) {
                                if ($visibility == 'public') {
                                    $update['is_public'] = 1;
                                } else {
                                    $update['is_public'] = 0;
                                }
                            }

                            if (count($update) > 0) {
                                $this->db->where('id', $id);
                                $this->db->update(db_prefix() . 'campaigns', $update);
                            }
                        }
                        if ($tags) {
                            handle_tags_save($tags, $id, 'campaign');
                        }
                        if ($lost == 'true') {
                            $this->campaigns_model->mark_as_lost($id);
                        }
                    }
                }
            }
        }

        if ($this->input->post('mass_delete')) {
            set_alert('success', _l('total_campaigns_deleted', $total_deleted));
        }
    }

    public function download_files($campaign_id)
    {
        if (!is_staff_member() || !$this->campaigns_model->staff_can_access_campaign($campaign_id)) {
            ajax_access_denied();
        }

        $files = $this->campaigns_model->get_campaign_attachments($campaign_id);

        if (count($files) == 0) {
            redirect(previous_url() ?: $_SERVER['HTTP_REFERER']);
        }

        $path = get_upload_path_by_type('campaign') . $campaign_id;

        $this->load->library('zip');

        foreach ($files as $file) {
            $this->zip->read_file($path . '/' . $file['file_name']);
        }

        $this->zip->download('files.zip');
        $this->zip->clear_data();
    }
	
	public function copy_form($id)
	{
		if (!is_admin()) {
			access_denied('Web To Campaign Access');
		}

		if (!$id) {
			set_alert('warning', _l('campaign_form_not_found'));
			redirect(admin_url('campaigns/forms'));
		}

		// Fetch the original form
		$form = $this->campaigns_model->get_form(['id' => $id]);
		if (!$form) {
			set_alert('warning', _l('campaign_form_not_found'));
			redirect(admin_url('campaigns/forms'));
		}

		// Prepare data for the new form
		$data = (array) $form;
		$data['name'] = $form->name . ' copy'; // Append " copy" to the name
		unset($data['id']); // Remove ID to create a new record
		$data['dateadded'] = date('Y-m-d H:i:s'); // Set new creation date
		$data['form_key'] = app_generate_hash(); // Generate new unique form key

		// Ensure notification settings are preserved
		if ($form->notify_campaign_imported) {
			$data['notify_campaign_imported'] = 1;
			$data['notify_type'] = $form->notify_type;
			$data['notify_ids'] = $form->notify_ids;
		}

		// Insert the new form
		$new_form_id = $this->campaigns_model->add_form($data);

		if ($new_form_id) {
			set_alert('success', _l('campaign_copied_successfully', _l('web_to_campaign_form')));
		} else {
			set_alert('warning', _l('campaign_problem_copying', _l('web_to_campaign_form')));
		}

		redirect(admin_url('campaigns/forms'));
	}
	
	   public function get_column_order()
    {
        if (!is_staff_member()) {
            ajax_access_denied();
        }
 
        $staff_id = get_staff_user_id();
        $columns = $this->get_table_columns();
        $saved_order = $this->db->get_where(db_prefix() . 'campaigns_table_order', ['staff_id' => $staff_id])->row();
 
        $column_order = $saved_order ? json_decode($saved_order->column_order, true) : array_column($columns, 'id');
 
        // Validate saved order
        $valid_order = array_intersect($column_order, array_column($columns, 'id'));
        if (count($valid_order) !== count($column_order)) {
            $column_order = array_column($columns, 'id');
        }
 
        echo json_encode([
            'success' => true,
            'columns' => $columns,
            'column_order' => $column_order,
        ]);
    }
 
    public function save_column_order()
    {
        if (!is_staff_member()) {
            ajax_access_denied();
        }
 
        $staff_id = get_staff_user_id();
        $column_order = $this->input->post('column_order', false);
 
        if (!$column_order || !is_array($column_order)) {
            echo json_encode(['success' => false, 'message' => _l('campaigns_table_order_invalid_data')]);
            return;
        }
 
        // Validate column IDs
        $valid_columns = array_column($this->get_table_columns(), 'id');
        $invalid_columns = array_diff($column_order, $valid_columns);
        if (!empty($invalid_columns)) {
            echo json_encode(['success' => false, 'message' => _l('campaigns_table_order_invalid_columns')]);
            return;
        }
 
        $data = [
            'staff_id' => $staff_id,
            'column_order' => json_encode($column_order),
            'updated_at' => date('Y-m-d H:i:s'),
        ];
 
        $this->db->where('staff_id', $staff_id);
        if ($this->db->get(db_prefix() . 'campaigns_table_order')->num_rows() > 0) {
            $this->db->update(db_prefix() . 'campaigns_table_order', $data);
        } else {
            $this->db->insert(db_prefix() . 'campaigns_table_order', $data);
        }
 
        echo json_encode(['success' => true, 'message' => _l('campaigns_table_order_updated')]);
    }
 
    private function get_table_columns()
    {
        $columns = [
            ['id' => 'name', 'name' => _l('campaigns_dt_name')],
            ['id' => 'date-created', 'name' => _l('campaigns_dt_datecreated')],
            ['id' => 'phone', 'name' => _l('campaigns_dt_phonenumber')],
            ['id' => 'number', 'name' => _l('the_number_sign')],
            ['id' => 'email', 'name' => _l('campaigns_dt_email')],
            ['id' => 'last-contact', 'name' => _l('campaigns_dt_last_contact')],
            ['id' => 'tags', 'name' => _l('tags')],
            ['id' => 'company', 'name' => _l('campaign_company')],
            ['id' => 'checkbox', 'name' => _l('checkbox')],
            ['id' => 'campaign-value', 'name' => _l('campaigns_dt_campaign_value')],
            ['id' => 'assigned', 'name' => _l('campaigns_dt_assigned')],
            ['id' => 'status', 'name' => _l('campaigns_dt_status')],
            ['id' => 'source', 'name' => _l('campaigns_source')],
        ];
 
        if (is_gdpr() && get_option('gdpr_enable_consent_for_campaigns') == '1') {
            $columns[] = ['id' => 'consent', 'name' => _l('gdpr_consent')];
        }
 
        $custom_fields = get_custom_fields('campaigns', ['show_on_table' => 1]);
        foreach ($custom_fields as $field) {
            $columns[] = ['id' => 'custom_field_' . $field['id'], 'name' => $field['name']];
        }
 
        return hooks()->apply_filters('campaigns_table_order_columns', $columns);
    }
}
