<?php
defined('BASEPATH') or exit('No direct script access allowed');

include_once(APPPATH . '/App_pdf.php');

class Restoration_project_pdf extends App_pdf
{
	
    protected $project_id;

    public function __construct($project_id)
    {
        parent::__construct();
			
        $this->project_id = $project_id;
    }

    public function prepare()
    {
		
        // Load required models
        $this->ci->load->model('restoration/projects_model');
        $this->ci->load->model('restoration/task_model');
        $this->ci->load->model('restoration/task_template_table_model');

	

        // Get project data
        $project = $this->ci->projects_model->get($this->project_id);
		
			/*if (isset($this->ci->projects_model)) {
			echo '<pre>';
			print_r(get_class_methods($this->ci->projects_model));
			die;
		}
		
        if (empty($project)) {
            throw new Exception('Restoration project not found');
        }*/

        // Set PDF title
        $this->SetTitle($project->name . ' - Restoration Report');

        // Get tasks data
        $tasks = $this->ci->task_model->all(["project_id" => $this->project_id, "client_report" => 1]);
        if ($tasks) {
            foreach ($tasks as $task_key => $task_value) {
                $template_table = $this->ci->task_template_table_model->all(["task_id" => $task_value["id"]]);
                foreach ($template_table as $key => $value) {
                    $template_table[$key]["column_data"] = !empty($value["column_data"]) ? json_decode($value["column_data"], true) : [];
                    $template_table[$key]["row_data"] = !empty($value["row_data"]) ? json_decode($value["row_data"], true) : [];
                    $template_table[$key]["value_data"] = !empty($value["value_data"]) ? json_decode($value["value_data"], true) : [];
                }
                $tasks[$task_key]['template_table'] = $template_table;
            }
        }
		
        // Prepare data for the view
        $data['tasks'] = $tasks;
        $data['staff_notes'] = $this->ci->projects_model->get_staff_notes($this->project_id);
		
        $data['project'] = $project;

        $this->set_view_vars($data);

        return $this->build();
    }

    protected function type()
    {
        return 'restoration-project';
    }

    protected function file_path()
    {
        $actualPath = FCPATH . 'restoration/projects/report_pdf.php';
        return $actualPath;
    }

    public function get_format_array()
    {
        return [
            'orientation' => 'P',
            'format'      => 'A4',
        ];
    }
}