<?php

namespace app\services\campaigns;

use app\services\AbstractKanban;

class CampaignsKanban extends AbstractKanban
{
    protected function table(): string
    {
        return 'campaigns';
    }

    public function defaultSortDirection()
    {
        return get_option('default_campaigns_kanban_sort_type');
    }

    public function defaultSortColumn()
    {
        return get_option('default_campaigns_kanban_sort');
    }

    public function limit()
    {
        return get_option('campaigns_kanban_limit');
    }

    protected function applySearchQuery($q): self
    {
        if (!startsWith($q, '#')) {
            $q = $this->ci->db->escape_like_str($this->q);
            $this->ci->db->where('(' . db_prefix() . 'campaigns.name LIKE "%' . $q . '%" ESCAPE \'!\' OR ' . db_prefix() . 'campaigns_sources.name LIKE "%' . $q . '%" ESCAPE \'!\' OR ' . db_prefix() . 'campaigns.email LIKE "%' . $q . '%" ESCAPE \'!\' OR ' . db_prefix() . 'campaigns.phonenumber LIKE "%' . $q . '%" ESCAPE \'!\' OR ' . db_prefix() . 'campaigns.company LIKE "%' . $q . '%" ESCAPE \'!\' OR CONCAT(' . db_prefix() . 'staff.firstname, \' \', ' . db_prefix() . 'staff.lastname) LIKE "%' . $q . '%" ESCAPE \'!\')');
        } else {
            $this->ci->db->where(db_prefix() . 'campaigns.id IN
                (SELECT rel_id FROM ' . db_prefix() . 'taggables WHERE tag_id IN
                (SELECT id FROM ' . db_prefix() . 'tags WHERE name="' . $this->ci->db->escape_str(strafter($q, '#')) . '")
                AND ' . db_prefix() . 'taggables.rel_type=\'campaign\' GROUP BY rel_id HAVING COUNT(tag_id) = 1)
                ');
        }

        return $this;
    }

    protected function initiateQuery(): self
    {
        $this->ci->db->select(db_prefix() . 'campaigns.title, ' . db_prefix() . 'campaigns.website, ' . db_prefix() . 'campaigns.campaign_value, ' . db_prefix() . 'campaigns.address, ' . db_prefix() . 'campaigns.city, ' . db_prefix() . 'campaigns.state, ' . db_prefix() . 'campaigns.country, ' . db_prefix() . 'campaigns.zip, ' . db_prefix() . 'campaigns.name as campaign_name,' . db_prefix() . 'campaigns_sources.name as source_name,' . db_prefix() . 'campaigns.id as id,' . db_prefix() . 'campaigns.assigned,' . db_prefix() . 'campaigns.email,' . db_prefix() . 'campaigns.phonenumber,' . db_prefix() . 'campaigns.company,' . db_prefix() . 'campaigns.dateadded,' . db_prefix() . 'campaigns.status,' . db_prefix() . 'campaigns.lastcontact,(SELECT COUNT(*) FROM ' . db_prefix() . 'clients WHERE campaignid=' . db_prefix() . 'campaigns.id) as is_campaign_client, (SELECT COUNT(id) FROM ' . db_prefix() . 'files WHERE rel_id=' . db_prefix() . 'campaigns.id AND rel_type="campaign") as total_files, (SELECT COUNT(id) FROM ' . db_prefix() . 'notes WHERE rel_id=' . db_prefix() . 'campaigns.id AND rel_type="campaign") as total_notes,(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'campaigns.id and rel_type="campaign" ORDER by tag_order ASC) as tags');
        $this->ci->db->from('campaigns');
        $this->ci->db->join(db_prefix() . 'campaigns_sources', db_prefix() . 'campaigns_sources.id=' . db_prefix() . 'campaigns.source');
        $this->ci->db->join(db_prefix() . 'staff', db_prefix() . 'staff.staffid=' . db_prefix() . 'campaigns.assigned', 'left');
        $this->ci->db->where('status', $this->status);

        if (staff_cant('view', 'campaigns')) {
            $this->ci->db->where('(assigned = ' . get_staff_user_id() . ' OR addedfrom=' . get_staff_user_id() . ' OR is_public=1)');
        }

        return $this;
    }
}
