<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2">
                    <a href="<?php echo admin_url('campaigns/form'); ?>" class="btn btn-primary">
                        <i class="fa-regular fa-plus tw-mr-1"></i>
                        <?php echo _l('new_form'); ?>
                    </a>
                </div>
                <div class="panel_s">
                    <div class="panel-body panel-table-full">
                        <?php hooks()->do_action('forms_table_start'); ?>
                        <?php render_datatable([
                              _l('id'),
                              _l('form_name'),
							  _l('campaigns_import_assignee'),
                              _l('campaigns_import_customer'),
							  _l('campaigns_dt_datecreated'),
                              _l('total_submissions'),
                              _l('created_forms'),
                              ], 'web-to-campaign'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(function() {
    initDataTable('.table-web-to-campaign', window.location.href);
});
	

$(function() {
    initDataTable('.table-web-to-campaign', window.location.href);

    // Add confirmation for copy action
    $(document).on('click', '.copy-form', function(e) {
        if (!confirm('<?php echo _l('campaign_confirm_copy_form'); ?>')) {
            e.preventDefault();
        }
    });
});

</script>
</body>

</html>