<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="widget<?php if (empty($projects_activity)) {
    echo ' hide';
} ?>" id="widget-<?php echo create_widget_id(); ?>" data-name="<?php echo _l('home_kpi_form_activity'); ?>">
    <div class="panel_s projects-activity">
        <div class="panel-body padding-10">
            <div class="widget-dragger"></div>
            <p class="tw-font-semibold tw-flex tw-items-center tw-mb-0 tw-space-x-1.5 rtl:tw-space-x-reverse tw-p-1.5">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="tw-w-6 tw-h-6 tw-text-neutral-500">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M8.25 6.75h12M8.25 12h12m-12 5.25h12M3.75 6.75h.007v.008H3.75V6.75zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zM3.75 12h.007v.008H3.75V12zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm-.375 5.25h.007v.008H3.75v-.008zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                </svg>
                <span class="tw-text-neutral-700">
                    <?php echo _l('home_kpi_form_activity'); ?>
                </span>
            </p>
            <hr class="-tw-mx-3 tw-mt-3 tw-mb-6">
            <div class="activity-feed">
                <?php
                    // Load database library if not already loaded (optional, uncomment if needed)
                    // $CI =& get_instance();
                    // $CI->load->database();

                    // Fetch activities from tblkpi_activity_log
                    $kpi_activity_log = [];
                    $query = $this->db->select('description, date, full_name, kpiformid')
                                      ->from('tblkpi_activity_log')
									  ->order_by('date', 'DESC')
                                      ->get();
                    if ($query && $query->num_rows() > 0) {
                        $kpi_activity_log = $query->result_array();
                        // Fetch name from tblkpi_team_report for each activity
                        foreach ($kpi_activity_log as &$activity) {
                            $activity['form_name'] = 'No form name found';
                            if (!empty($activity['kpiformid'])) {
                                $this->db->select('name');
                                $this->db->from('tblkpi_team_report');
                                $this->db->where('id', $activity['kpiformid']);
                                $form_query = $this->db->get();
                                if ($form_query && $form_query->num_rows() > 0 && isset($form_query->row()->name)) {
                                    $activity['form_name'] = html_escape($form_query->row()->name);
                                } else {
                                    log_message('error', 'No form name found for kpiformid: ' . $activity['kpiformid']);
                                }
                            }
                        }
                    }

                    // Set projects_activity to prevent widget hiding
                    $projects_activity = !empty($kpi_activity_log);

                    // Debug: Check $kpi_activity_log content (uncomment to inspect)
                    // echo '<pre>kpi_activity_log: '; var_dump($kpi_activity_log); echo '</pre>';

                    $filtered_activities = 0;
                    foreach ($kpi_activity_log as $activity) {
                        $filtered_activities++;
                        $name = html_escape($activity['full_name'] ?? '[SYSTEM]');
                        $form_name = html_escape($activity['form_name'] ?? 'No form name found');

                        // Format description to be human-readable
                      $description = $activity['description'] ?? 'No description';

if ($description === 'not_kpi_activity_form_added') {
    $description = 'Added KPI form';
} elseif ($description === 'not_kpi_activity_form_data_updated') {
    $description = 'Updated KPI form';
} elseif ($description === 'not_kpi_activity_form_deleted') {
    $description = 'Deleted KPI form';
} elseif ($description === 'not_kpi_activity_form_submitted') {
    $description = 'Submitted KPI form';
}

                ?>
                <div class="feed-item">
                    <div class="date"><span class="text-has-action" data-toggle="tooltip"
                            data-title="<?php echo html_escape(_dt($activity['date'])); ?>">
                            <?php echo html_escape(time_ago($activity['date'])); ?>
                        </span>
                    </div>
                    <div class="text">
                        <p class="bold no-mbot">
                            <?php echo $name; ?> - <?php echo html_escape($description); ?> (Form: <?php echo $form_name; ?>)
                        </p>
                    </div>
                </div>
                <?php } ?>
                <?php if ($filtered_activities == 0) { ?>
                    <p>No KPI form activities found.</p>
                <?php } ?>
            </div>
        </div>
    </div>
</div>