<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-inline-flex tw-items-center tw-space-x-4 tw-mb-4">
    <a href="<?php echo admin_url('reports/campaigns?type=staff'); ?>" class="btn btn-primary">
        <?php echo _l('switch_to_general_campaign_report'); // make sure this lang key exists ?>
    </a>
    <p class="tw-m-0" data-placement="bottom" data-toggle="tooltip"
       data-title="<?php echo _l('campaigns_report_converted_notice'); ?>">
        <i class="fa-regular fa-circle-question fa-lg"></i>
    </p>
</div>

            </div>
            <div class="col-md-6 animated fadeIn">
                <div class="panel_s">
                    <div class="panel-heading">
                        <h3 class="panel-title"><?php echo _l('report_this_week_campaigns_conversions'); ?></h3>
                    </div>
                    <div class="panel-body">
                       <canvas class="campaigns-this-week" height="150" id="campaigns-this-week"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6 animated fadeIn">
                <div class="panel_s">
                    <div class="panel-heading">
                         <h3 class="panel-title"><?php echo _l('report_campaigns_sources_conversions'); ?></h3>
                    </div>
                    <div class="panel-body">
                       <canvas class="campaigns-sources-report" height="150" id="campaigns-sources-report"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-12 animated fadeIn">
                <div class="panel_s">
                    <div class="panel-heading">
                        <h3 class="panel-title"><?php echo _l('report_leads_monthly_conversions'); ?></h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-3">
                                <?php
                            echo '<select name="month" class="selectpicker" data-none-selected-text="' . _l('dropdown_non_selected_tex') . '">' . PHP_EOL;
                            for ($m = 1; $m <= 12; $m++) {
                                $_selected = '';
                                if ($m == date('m')) {
                                    $_selected = ' selected';
                                }
                                echo '  <option value="' . $m . '"' . $_selected . '>' . _l(date('F', mktime(0, 0, 0, $m, 1))) . '</option>' . PHP_EOL;
                            }
                      echo '</select>' . PHP_EOL;
                      ?>
                            </div>
                        </div>
                        <div class="relative" style="max-height:400px;">
                            <canvas class="campaigns-monthly chart mtop20" id="campaigns-monthly" height="400"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
var MonthlyLeadsChart;
$(function() {
	$.get(admin_url + 'reports/campaigns_monthly_report/' + $('select[name="month"]').val(), function(response) {
        var ctx = $('#campaigns-monthly').get(0).getContext('2d');
        MonthlyLeadsChart = new Chart(ctx, {
            'type': 'bar',
            data: response,
            options: {
                responsive: true,
                legend: {
                    display: false,
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                        }
                    }]
                },
            },
        });
    }, 'json');
    $('select[name="month"]').on('change', function() {
        MonthlyLeadsChart.destroy();
        $.get(admin_url + 'reports/campaigns_monthly_report/' + $('select[name="month"]').val(), function(
            response) {
            var ctx = $('#leads-monthly').get(0).getContext('2d');
            MonthlyLeadsChart = new Chart(ctx, {
                'type': 'bar',
                data: response,
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    legend: {
                        display: false,
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true,
                            }
                        }]
                    },
                },
            });
        }, 'json');
    });

    new Chart($("#campaigns-this-week"), {
    type: 'pie',
    data: <?php echo $campaigns_this_week_report; ?>,
    options: { responsive: true }
});

new Chart($('#campaigns-sources-report'), {
    type: 'bar',
    data: <?php echo $campaigns_sources_report; ?>,
    options: {
        responsive: true,
        legend: { display: false },
        scales: {
            yAxes: [{ ticks: { beginAtZero: true } }]
        },
    },
});

});
</script>
</body>

</html>
