<?php

defined('BASEPATH') or exit('No direct script access allowed');

return App_table::find('restoration_projects')
    ->outputUsing(function ($params) {
		
        extract($params);
		
		$clientid = $params['clientid'];
        $hasPermissionEdit = staff_can('edit', 'restoration_projects');
        $hasPermissionDelete = staff_can('delete', 'restoration_projects');
        $hasPermissionCreate = staff_can('create', 'restoration_projects');

        $aColumns = [
            db_prefix() . 'restoration_projects.id as id',
            'name',
            'imo_number',
            get_sql_select_client_company(),
            'start_date',
            'deadline',
            '(SELECT GROUP_CONCAT(CONCAT(firstname, \' \', lastname) SEPARATOR ",") FROM ' . db_prefix() . 'project_members JOIN ' . db_prefix() . 'staff on ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'project_members.staff_id WHERE restoration_project_id=' . db_prefix() . 'restoration_projects.id ORDER BY staff_id) as members',
            'status',
            'project_cost',
        ];

        $sIndexColumn = 'id';
        $sTable = db_prefix() . 'restoration_projects';

        $join = [
            'JOIN ' . db_prefix() . 'clients ON ' . db_prefix() . 'clients.userid = ' . db_prefix() . 'restoration_projects.clientid',
        ];

        $where = [];

        if ($filtersWhere = $this->getWhereFromRules()) {
            $where[] = $filtersWhere;
        }

        if ($clientid != '') {
            array_push($where, ' AND clientid=' . $this->ci->db->escape_str($clientid));
        }

        if (staff_cant('view', 'restoration_projects')) {
            array_push($where, ' AND ' . db_prefix() . 'restoration_projects.id IN (SELECT restoration_project_id FROM ' . db_prefix() . 'project_members WHERE staff_id=' . get_staff_user_id() . ')');
        }

        $custom_fields = get_table_custom_fields('restoration_projects');
		
        foreach ($custom_fields as $key => $field) {
            $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
            array_push($customFieldsColumns, $selectAs);
            array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
            array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'restoration_projects.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
        }

        $aColumns = hooks()->apply_filters('restoration_projects_table_sql_columns', $aColumns);
		
        if (count($custom_fields) > 4) {
            @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
        }

        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
            'clientid',
            '(SELECT GROUP_CONCAT(staff_id SEPARATOR ",") FROM ' . db_prefix() . 'project_members WHERE restoration_project_id=' . db_prefix() . 'restoration_projects.id ORDER BY staff_id) as members_ids',
        ]);

        $output = $result['output'];
        $rResult = $result['rResult'];
		
        foreach ($rResult as $aRow) {
            $row = [];

            $link = admin_url('restoration/projects/view/' . $aRow['id']);

            $row[] = '<a href="' . $link . '" class="tw-font-medium">' . $aRow['id'] . '</a>';

            $name = '<a href="' . $link . '" class="tw-font-medium">' . e($aRow['name']) . '</a>';
            $name .= '<div class="row-options">';
            $name .= '<a href="' . $link . '">' . _l('view') . '</a>';

            if ($hasPermissionCreate && !$clientid) {
                $name .= ' | <a href="#" data-name="' . e($aRow['name']) . '" onclick="copy_restoration_project(' . $aRow['id'] . ', this);return false;">' . _l('copy_restoration_project') . '</a>';
            }

            if ($hasPermissionEdit) {
                $name .= ' | <a href="' . admin_url('restoration/projects/project/' . $aRow['id']) . '">' . _l('edit') . '</a>';
            }

            if ($hasPermissionDelete) {
                $name .= ' | <a href="' . admin_url('restoration/' . $aRow['id']) . '" class="_delete">' . _l('delete') . '</a>';
            }

            $name .= '</div>';
            $row[] = $name;

            $row[] = e($aRow['imo_number']);
            $row[] = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '">' . e($aRow['company']) . '</a>';
            $row[] = e(_d($aRow['start_date']));
            $row[] = e(_d($aRow['deadline']));

            $membersOutput = '<div class="tw-flex -tw-space-x-1">';
            $members = explode(',', $aRow['members']);
            $exportMembers = '';

            foreach ($members as $key => $member) {
                if ($member != '') {
                    $members_ids = explode(',', $aRow['members_ids']);
                    $member_id = $members_ids[$key];
                    $membersOutput .= '<a href="' . admin_url('profile/' . $member_id) . '">' .
                        staff_profile_image($member_id, [
                            'tw-inline-block tw-h-7 tw-w-7 tw-rounded-full tw-ring-2 tw-ring-white',
                        ], 'small', [
                            'data-toggle' => 'tooltip',
                            'data-title' => $member,
                        ]) . '</a>';
                    $exportMembers .= $member . ', ';
                }
            }

            $membersOutput .= '<span class="hide">' . trim($exportMembers, ', ') . '</span>';
            $membersOutput .= '</div>';
            $row[] = $membersOutput;
			
            $status = get_restoration_project_status_by_id($aRow['status']);
			
            $row[] = '<span class="label restoration-project-status-' . $aRow['status'] . '" style="color:' . $status['color'] . ';border:1px solid ' . adjust_hex_brightness($status['color'], 0.4) . ';background: ' . adjust_hex_brightness($status['color'], 0.04) . ';">' . e($status['name']) . '</span>';

            $row[] = format_money($aRow['project_cost']);

            foreach ($customFieldsColumns as $customFieldColumn) {
                $row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
            }

            $row['DT_RowClass'] = 'has-row-options';
            $row = hooks()->apply_filters('restoration_projects_table_row_data', $row, $aRow);

            $output['aaData'][] = $row;
        }

        return $output;
    })->setRules([
        App_table_filter::new('name', 'TextRule')->label(_l('restoration_project_name')),
        App_table_filter::new('imo_number', 'TextRule')->label(_l('restoration_project_imo_number')),
        App_table_filter::new('start_date', 'DateRule')->label(_l('restoration_project_start_date')),
        App_table_filter::new('deadline', 'DateRule')->label(_l('restoration_project_deadline')),
        App_table_filter::new('billing_type', 'SelectRule')->label(_l('restoration_project_billing_type'))->options(function ($ci) {
            return [
                ['value' => 1, 'label' => _l('project_billing_type_fixed_cost')],
                ['value' => 2, 'label' => _l('project_billing_type_project_hours')],
                ['value' => 3, 'label' => _l('project_billing_type_project_task_hours_hourly_rate')],
            ];
        }),
        App_table_filter::new('status', 'MultiSelectRule')->label(_l('restoration_project_status'))->options(function ($ci) {
            return collect($ci->restoration_projects_model->get_restoration_project_statuses())->map(fn ($data) => [
                'value' => $data['id'],
                'label' => $data['name'],
            ])->all();
        }),
        App_table_filter::new('members', 'MultiSelectRule')->label(_l('restoration_project_members'))
            ->isVisible(fn () => staff_can('view', 'restoration_projects'))
            ->options(function ($ci) {
                return collect($ci->restoration_projects_model->get_distinct_restoration_projects_members())->map(function ($staff) {
                    return [
                        'value' => $staff['staff_id'],
                        'label' => get_staff_full_name($staff['staff_id'])
                    ];
                })->all();
            })->raw(function ($value, $operator, $sqlOperator) {
                $dbPrefix = db_prefix();
                $sqlOperator = $sqlOperator['operator'];
                return "({$dbPrefix}restoration_projects.id IN (SELECT restoration_project_id FROM {$dbPrefix}project_members WHERE staff_id $sqlOperator ('" . implode("','", $value) . "')))";
            })
    ]);