<?php

/*defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = ['id', 'name', '(SELECT COUNT(id) FROM ' . db_prefix() . 'campaigns WHERE ' . db_prefix() . 'campaigns.from_form_id = ' . db_prefix() . 'web_to_campaign.id)', 'dateadded'];

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'web_to_campaign';

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], [], ['form_key', 'id']);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == 'name') {
            $_data = '<a href="' . admin_url('campaigns/form/' . $aRow['id']) . '" class="tw-font-medium">' . e($_data) . '</a>';
            $_data .= '<div class="row-options">';
            $_data .= '<a href="' . site_url('forms/wtc/' . $aRow['form_key']) . '" target="_blank">' . _l('view') . '</a>';
            $_data .= ' | <a href="' . admin_url('campaigns/form/' . $aRow['id']) . '">' . _l('edit') . '</a>';
            $_data .= ' | <a href="' . admin_url('campaigns/delete_form/' . $aRow['id']) . '" class="_delete">' . _l('delete') . '</a>';
            $_data .= '</div>';
        } elseif ($aColumns[$i] == 'dateadded') {
            $_data = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>';
        }

        $row[] = $_data;
    }
    $row['DT_RowClass'] = 'has-row-options';

    $output['aaData'][] = $row;
}*/


defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    db_prefix() . 'web_to_campaign.id',
    db_prefix() . 'web_to_campaign.name',
    db_prefix() . 'web_to_campaign.responsible',
    db_prefix() . 'web_to_campaign.responsible_client',
    db_prefix() . 'web_to_campaign.dateadded',

];

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'web_to_campaign';

$join = [
    'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'web_to_campaign.responsible',
    'LEFT JOIN ' . db_prefix() . 'clients ON ' . db_prefix() . 'clients.userid = ' . db_prefix() . 'web_to_campaign.responsible_client',
];

$additionalSelect = [
    'form_key',
    db_prefix() . 'web_to_campaign.id',
    db_prefix() . 'staff.firstname as staff_firstname',
    db_prefix() . 'staff.lastname as staff_lastname',
    db_prefix() . 'clients.company as client_company',
	'(SELECT COUNT(id) FROM ' . db_prefix() . 'campaigns WHERE ' . db_prefix() . 'campaigns.from_form_id = ' . db_prefix() . 'web_to_campaign.id) as total_submissions',
'(SELECT dateadded FROM ' . db_prefix() . 'campaigns WHERE ' . db_prefix() . 'campaigns.from_form_id = ' . db_prefix() . 'web_to_campaign.id ORDER BY dateadded DESC LIMIT 1) as created_forms'
];

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, [], $additionalSelect);

$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == db_prefix() . 'web_to_campaign.id') {
            $_data = $aRow[db_prefix() . 'web_to_campaign.id'];
        } elseif ($aColumns[$i] == db_prefix() . 'web_to_campaign.name') {
            $_data = '<a href="' . admin_url('campaigns/form/' . $aRow['id']) . '" class="tw-font-medium">' . e($_data) . '</a>';
            $_data .= '<div class="row-options">';
            $_data .= '<a href="' . site_url('forms/wtc/' . $aRow['form_key']) . '" target="_blank">' . _l('view') . '</a>';
            $_data .= ' | <a href="' . admin_url('campaigns/form/' . $aRow['id']) . '">' . _l('edit') . '</a>';
            $_data .= ' | <a href="' . admin_url('campaigns/delete_form/' . $aRow['id']) . '" class="_delete">' . _l('delete') . '</a>';
			$_data .= ' | <a href="' . admin_url('campaigns/copy_form/' . $aRow['id']) . '" class="copy-form">' . _l('copy') . '</a>';
            $_data .= '</div>';
        } elseif ($aColumns[$i] == db_prefix() . 'web_to_campaign.responsible') {
$staff_ids = json_decode($aRow[db_prefix() . 'web_to_campaign.responsible'], true);
$_data = '-';

if (is_array($staff_ids) && count($staff_ids) > 0) {
    $staff_names = [];
    foreach ($staff_ids as $sid) {
        $staff_names[] = get_staff_full_name($sid);
    }
    $_data = implode(', ', $staff_names);
}

} elseif ($aColumns[$i] == db_prefix() . 'web_to_campaign.responsible_client') {
$client_ids = json_decode($aRow[db_prefix() . 'web_to_campaign.responsible_client'], true);
$_data = '-';

if (is_array($client_ids) && count($client_ids) > 0) {
    $CI = &get_instance();
    $CI->load->model('clients_model');
    $client_names = [];

    foreach ($client_ids as $cid) {
        $client = $CI->clients_model->get($cid);
        if ($client) {
            $client_names[] = $client->company;
        }
    }

    $_data = implode(', ', $client_names);
}

}
 elseif ($aColumns[$i] == db_prefix() . 'web_to_campaign.dateadded') {
            $_data = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>';
        }

        $row[] = $_data;
    }
	
	$row[] = $aRow['total_submissions'];
	$row[] = $aRow['created_forms'];
    $row['DT_RowClass'] = 'has-row-options';

    $output['aaData'][] = $row;
}