<?php

/*defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = ['id', 'name', '(SELECT COUNT(id) FROM ' . db_prefix() . 'leads WHERE ' . db_prefix() . 'leads.from_form_id = ' . db_prefix() . 'web_to_lead.id)', 'dateadded'];

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'web_to_lead';

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], [], ['form_key', 'id']);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == 'name') {
            $_data = '<a href="' . admin_url('leads/form/' . $aRow['id']) . '" class="tw-font-medium">' . e($_data) . '</a>';
            $_data .= '<div class="row-options">';
            $_data .= '<a href="' . site_url('forms/wtl/' . $aRow['form_key']) . '" target="_blank">' . _l('view') . '</a>';
            $_data .= ' | <a href="' . admin_url('leads/form/' . $aRow['id']) . '">' . _l('edit') . '</a>';
            $_data .= ' | <a href="' . admin_url('leads/delete_form/' . $aRow['id']) . '" class="_delete">' . _l('delete') . '</a>';
            $_data .= '</div>';
        } elseif ($aColumns[$i] == 'dateadded') {
            $_data = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>';
        }

        $row[] = $_data;
    }
    $row['DT_RowClass'] = 'has-row-options';

    $output['aaData'][] = $row;
}*/


defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    db_prefix() . 'web_to_lead.id',
    db_prefix() . 'web_to_lead.name',
    db_prefix() . 'web_to_lead.responsible',
    db_prefix() . 'web_to_lead.responsible_client',
	'(SELECT COUNT(id) FROM ' . db_prefix() . 'leads WHERE ' . db_prefix() . 'leads.from_form_id = ' . db_prefix() . 'web_to_lead.id) as total_submissions',
    db_prefix() . 'web_to_lead.dateadded',
];

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'web_to_lead';

$join = [
    'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'web_to_lead.responsible',
    'LEFT JOIN ' . db_prefix() . 'clients ON ' . db_prefix() . 'clients.userid = ' . db_prefix() . 'web_to_lead.responsible_client',
];

$additionalSelect = [
    'form_key',
    db_prefix() . 'web_to_lead.id',
    db_prefix() . 'staff.firstname as staff_firstname',
    db_prefix() . 'staff.lastname as staff_lastname',
    db_prefix() . 'clients.company as client_company',
];

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, [], $additionalSelect);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == db_prefix() . 'web_to_lead.id') {
            $_data = $aRow[db_prefix() . 'web_to_lead.id'];
        } elseif ($aColumns[$i] == db_prefix() . 'web_to_lead.name') {
            $_data = '<a href="' . admin_url('leads/form/' . $aRow['id']) . '" class="tw-font-medium">' . e($_data) . '</a>';
            $_data .= '<div class="row-options">';
            $_data .= '<a href="' . site_url('forms/wtl/' . $aRow['form_key']) . '" target="_blank">' . _l('view') . '</a>';
            $_data .= ' | <a href="' . admin_url('leads/form/' . $aRow['id']) . '">' . _l('edit') . '</a>';
            $_data .= ' | <a href="' . admin_url('leads/delete_form/' . $aRow['id']) . '" class="_delete">' . _l('delete') . '</a>';
            $_data .= '</div>';
        } elseif ($aColumns[$i] == db_prefix() . 'web_to_lead.responsible') {
            $_data = trim($aRow['staff_firstname'] . ' ' . $aRow['staff_lastname']) ?: '-';
        } elseif ($aColumns[$i] == db_prefix() . 'web_to_lead.responsible_client') {
            $_data = $aRow['client_company'] ?: '-';
		} elseif ($aColumns[$i] == '(SELECT COUNT(id) FROM ' . db_prefix() . 'leads WHERE ' . db_prefix() . 'leads.from_form_id = ' . db_prefix() . 'web_to_lead.id) as total_submissions') {
            $_data = $aRow['total_submissions'];
        } elseif ($aColumns[$i] == db_prefix() . 'web_to_lead.dateadded') {
            $_data = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>';
        }

        $row[] = $_data;
    }
    $row['DT_RowClass'] = 'has-row-options';

    $output['aaData'][] = $row;
}