<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Deals extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('deals_model');
        $this->load->helper('deals/deals');
    }

    public function index()
    {
        if (!staff_can('view', 'deals')) {
            access_denied('deals');
        }
        // Default pipeline
        $pipeline_id = $this->input->get('pipeline_id');
        if (!$pipeline_id) {
            $pipeline_id = (int)get_option('deals_default_pipeline');
            if (!$pipeline_id) {
                $pipeline_id = $this->deals_model->get_default_pipeline_id();
            }
        }

        $data['title']        = _l('deals');
        $data['pipelines']    = $this->deals_model->get_pipelines();
        $data['active_pipeline'] = (int)$pipeline_id;
        // Kanban as default page like campaign kanban
        $data['stages']       = $this->deals_model->get_stages($pipeline_id);
        $data['dealsGrouped'] = $this->deals_model->get_kanban($pipeline_id);
        $data['totals']       = $this->deals_model->get_pipeline_totals($pipeline_id);

        $this->load->view('deals/kanban', $data);
    }

    public function manage()
    {
        if (!staff_can('view', 'deals')) {
            access_denied('deals');
        }
        $data['title']     = _l('deals_manage');
        $data['deals']     = $this->deals_model->get_deals();
        $data['pipelines'] = $this->deals_model->get_pipelines();
        $data['stages']    = $this->deals_model->get_stages(); // for mapping stage names
        $this->load->view('deals/manage', $data);
    }

    public function deal($id = '')
    {
        if ($this->input->post()) {
            $form = $this->input->post();
            if ($id == '') {
                if (!staff_can('create', 'deals')) {
                    access_denied('deals');
                }
                $insert_id = $this->deals_model->add_deal($form);
                if ($insert_id) {
                    set_alert('success', _l('added_successfully', _l('deal')));
                } else {
                    set_alert('warning', _l('problem_adding', _l('deal')));
                }
            } else {
                if (!staff_can('edit', 'deals')) {
                    access_denied('deals');
                }
                $success = $this->deals_model->update_deal($id, $form);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('deal')));
                } else {
                    set_alert('warning', _l('problem_updating', _l('deal')));
                }
            }
            redirect(admin_url('deals/manage'));
        }

        $data['title']     = $id ? _l('deal_edit') : _l('deal_new');
        $data['deal']      = $id ? $this->deals_model->get_deal($id) : null;
        $data['pipelines'] = $this->deals_model->get_pipelines();
        $activePipelineId  = $data['deal'] ? $data['deal']->pipeline_id : $this->deals_model->get_default_pipeline_id();
        $data['stages']    = $this->deals_model->get_stages($activePipelineId);
        $this->load->view('deals/form', $data);
    }

    public function delete_deal($id)
    {
        if (!staff_can('delete', 'deals')) {
            access_denied('deals');
        }
        $deleted = $this->deals_model->delete_deal($id);
        if ($deleted) {
            set_alert('success', _l('deleted', _l('deal')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('deal')));
        }
        redirect(admin_url('deals/manage'));
    }

    public function move()
    {
        if (!staff_can('edit', 'deals')) {
            access_denied('deals');
        }
        $deal_id  = (int)$this->input->post('id');
        $stage_id = (int)$this->input->post('stage_id');
        $success  = $this->deals_model->move($deal_id, $stage_id);
        echo json_encode(['success' => (bool)$success]);
        die;
    }

    public function pipelines()
    {
        if (!staff_can('view', 'deals')) {
            access_denied('deals');
        }
        $data['title']     = _l('deals_pipelines');
        $data['pipelines'] = $this->deals_model->get_pipelines(true);
        $this->load->view('deals/manage_pipelines', $data);
    }

    public function pipeline()
    {
        $data = $this->input->post();
        if (empty($data)) {
            redirect(admin_url('deals/pipelines'));
        }

        $id = isset($data['id']) ? (int)$data['id'] : 0;

        if ($id == 0) {
            if (!staff_can('create', 'deals')) {
                access_denied('deals');
            }
            $pid = $this->deals_model->add_pipeline($data);
            if ($pid) {
                set_alert('success', _l('added_successfully', _l('deal_pipeline')));
            }
        } else {
            if (!staff_can('edit', 'deals')) {
                access_denied('deals');
            }
            $ok = $this->deals_model->update_pipeline($id, $data);
            if ($ok) {
                set_alert('success', _l('updated_successfully', _l('deal_pipeline')));
            }
        }
        redirect(admin_url('deals/pipelines'));
    }

    public function delete_pipeline($id)
    {
        if (!staff_can('delete', 'deals')) {
            access_denied('deals');
        }
        $ok = $this->deals_model->delete_pipeline((int)$id);
        if ($ok) {
            set_alert('success', _l('deleted', _l('deal_pipeline')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('deal_pipeline')));
        }
        redirect(admin_url('deals/pipelines'));
    }

    public function stage()
    {
        $data = $this->input->post();
        if (empty($data)) {
            redirect(admin_url('deals/pipelines'));
        }

        $id = isset($data['id']) ? (int)$data['id'] : 0;
        if ($id == 0) {
            if (!staff_can('create', 'deals')) {
                access_denied('deals');
            }
            $sid = $this->deals_model->add_stage($data);
            if ($sid) {
                set_alert('success', _l('added_successfully', _l('deal_stage')));
            }
        } else {
            if (!staff_can('edit', 'deals')) {
                access_denied('deals');
            }
            $ok = $this->deals_model->update_stage($id, $data);
            if ($ok) {
                set_alert('success', _l('updated_successfully', _l('deal_stage')));
            }
        }
        redirect(admin_url('deals/pipelines'));
    }

    public function delete_stage($id)
    {
        if (!staff_can('delete', 'deals')) {
            access_denied('deals');
        }
        $ok = $this->deals_model->delete_stage((int)$id);
        if ($ok) {
            set_alert('success', _l('deleted', _l('deal_stage')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('deal_stage')));
        }
        redirect(admin_url('deals/pipelines'));
    }

    public function reorder_stages()
    {
        if (!staff_can('edit', 'deals')) {
            access_denied('deals');
        }
        $order = $this->input->post('order'); // array of ids in new order
        $ok = $this->deals_model->reorder_stages($order);
        echo json_encode(['success' => (bool)$ok]);
        die;
    }

    // Optional lost reason endpoints (scaffold)
    public function lost_reason()
    {
        $data = $this->input->post();
        if (!empty($data)) {
            $id = isset($data['id']) ? (int)$data['id'] : 0;
            $ok = $id ? $this->deals_model->update_lost_reason($id, $data) : $this->deals_model->add_lost_reason($data);
            echo json_encode(['success' => (bool)$ok]);
            die;
        }
        show_404();
    }

    public function delete_lost_reason($id)
    {
        $ok = $this->deals_model->delete_lost_reason((int)$id);
        echo json_encode(['success' => (bool)$ok]);
        die;
    }
}
