function kanban_load_more(stage_id, element, url, width, height) {
    var $element = $(element);
    if ($element.hasClass('disabled')) return;

    var page = parseInt($element.data('page')) + 1;
    var $col = $element.closest('.kan-ban-col');
    var pipeline_id = $('#pipeline-filter').val() || (window.selectedPipelines && window.selectedPipelines.length > 0 ? window.selectedPipelines[0].id : '');

    $.post(admin_url + url, {
        stage_id: stage_id,
        pipeline_id: pipeline_id,
        page: page,
        filters: JSON.stringify(window.activeFilters || [])
    }).done(function (response) {
        response = JSON.parse(response);
        if (response.success) {
            $col.find('.kanban-load-more').before(response.deals);
            $col.find('.kanban-load-more').data('page', page);
            if (page >= $col.data('total-pages')) {
                $col.find('.kanban-load-more').addClass('disabled');
            }
            updateKanbanTotals();
            $('.deals-stage.sortable').sortable('refresh');
        }
    });
}

function updateKanbanTotals() {
    $('.kan-ban-col').each(function () {
        var total = $(this).find('li.deal-kan-ban').length;
        $(this).find('.total-deals').text(total);
        $(this).find('.kanban-empty').toggleClass('hide', total > 0);
    });
}