<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-8 col-md-offset-2">
        <div class="panel_s">
          <div class="panel-body">
            <h4 class="tw-mt-0"><?php echo isset($deal) ? _l('edit_deal') : _l('new_deal'); ?></h4>
            <hr class="hr-panel-heading" />
            <?php echo form_open(admin_url(isset($deal) ? 'deals/edit/' . $deal['id'] : 'deals/create')); ?>
            <div class="row">
              <div class="col-md-6">
                <?php echo render_input('name', 'name', isset($deal) ? $deal['name'] : ''); ?>
              </div>
              <div class="col-md-6">
                <?php echo render_input('company', 'company', isset($deal) ? $deal['company'] : ''); ?>
              </div>
			  <?php if (!isset($deal)) { ?>
				<div class="col-md-6">
					<?php echo render_input('email', 'email'); ?>
				</div>
				<div class="col-md-6">
					<?php echo render_input('phonenumber', 'phonenumber'); ?>
				</div>
			 <?php } ?>


              
              <div class="col-md-12">
                <div class="form-group">
                  <label class="control-label"><?php echo _l('pipelines'); ?></label>
                  <div id="deal-pipelines-list">

                    <?php if (isset($deal) && !empty($deal['id'])) { ?>
                      <?php $allPipes = $this->deals_model->get_deal_pipelines($deal['id']); ?>
                      <?php foreach ($allPipes as $idx => $rel) { ?>
                        
                        <div class="pipeline-row" style="border: 1px solid #ddd; padding: 15px; margin-bottom: 10px; border-radius: 4px; position: relative;">
                          <a href="#" class="text-danger" onclick="removePipelineRow(this); return false;" style="position: absolute; top: 10px; right: 10px;"><i class="fa-regular fa-trash-can"></i></a>
                          
                          <div class="row">
                            <div class="col-md-6">
                              <div class="form-group">
                                <label class="control-label"><?php echo _l('pipeline'); ?></label>
                                <select name="pipelines[<?php echo $idx; ?>][pipeline_id]" class="form-control pipeline-select">
                                  <?php foreach (($pipelines ?? []) as $pipeline) { ?>
                                    <option value="<?php echo (int)$pipeline['id']; ?>" <?php echo ($rel['pipeline']['id'] == $pipeline['id']) ? 'selected' : ''; ?>><?php echo html_entity_decode($pipeline['name']); ?></option>
                                  <?php } ?>
                                </select>
                              </div>
                            </div>
                            <div class="col-md-6">
                              <div class="form-group">
                                <label class="control-label"><?php echo _l('stage'); ?></label>
                                <select name="pipelines[<?php echo $idx; ?>][stage_id]" class="form-control stage-select" data-pipeline="<?php echo (int)$rel['pipeline']['id']; ?>">
                                  <?php foreach ($this->deals_model->get_stages($rel['pipeline']['id']) as $stage) { ?>
                                    <option value="<?php echo (int)$stage['id']; ?>" <?php echo ($rel['stage']['id'] == $stage['id']) ? 'selected' : ''; ?>><?php echo html_entity_decode($stage['name']); ?></option>
                                  <?php } ?>
                                </select>
                              </div>
                            </div>
                            <div class="col-md-3">
                              <div class="form-group">
                                <label class="control-label"><?php echo _l('rating'); ?></label>
                                <select name="pipelines[<?php echo $idx; ?>][score]" class="form-control">
                                  <?php for ($i = 1; $i <= 10; $i++) { ?>
                                    <option value="<?php echo $i; ?>" <?php echo (isset($rel['score']) && (int)$rel['score'] === $i) ? 'selected' : ''; ?>>
                                      <?php echo $i; ?>
                                    </option>
                                  <?php } ?>
                                </select>
                              </div>
                            </div>
                          </div>
                        </div>
                        <?php } ?>
                    <?php } else { ?>
                      
                      <div class="pipeline-row" style="border: 1px solid #ddd; padding: 15px; margin-bottom: 10px; border-radius: 4px; position: relative;">
                        <a href="#" class="text-danger" onclick="removePipelineRow(this); return false;" style="position: absolute; top: 10px; right: 10px;"><i class="fa-regular fa-trash-can"></i></a>
                        
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="control-label"><?php echo _l('pipeline'); ?></label>
                              <select name="pipelines[0][pipeline_id]" class="form-control pipeline-select">
                                <?php foreach (($pipelines ?? []) as $pipeline) { ?>
                                  <option value="<?php echo (int)$pipeline['id']; ?>"><?php echo html_entity_decode($pipeline['name']); ?></option>
                                <?php } ?>
                              </select>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <label class="control-label"><?php echo _l('stage'); ?></label>
                              <select name="pipelines[0][stage_id]" class="form-control stage-select"></select>
                            </div>
                          </div>
                          <div class="col-md-3">
                            <div class="form-group">
                              <label class="control-label"><?php echo _l('rating'); ?></label>
                              <select name="pipelines[0][score]" class="form-control">
                                <?php for ($i = 1; $i <= 10; $i++) { ?>
                                  <option value="<?php echo $i; ?>">
                                    <?php echo $i; ?>
                                  </option>
                                <?php } ?>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <?php } ?>
                  </div>
                  <a href="#" class="btn btn-default" onclick="addPipelineRow(); return false;"><i class="fa-regular fa-plus tw-mr-1"></i><?php echo _l('add'); ?></a>
                </div>
              </div>
              <div class="col-md-6">
                <?php echo render_select('source', $sources, array('id', 'name'), 'lead_add_edit_source', isset($deal) ? $deal['source'] : ''); ?>
              </div>
              <div class="col-md-6">
                <?php echo render_select('status', $statuses, array('id', 'name'), 'lead_add_edit_status', isset($deal) ? $deal['status'] : ''); ?>
              </div>
			  <div class="col-md-6">
				<?php echo render_select('interested_in',$interested_in_list,array('id', 'name'),'interested_in',isset($deal) ? $deal['interested_in'] : '');?>
			  </div>

              <div class="col-md-6">
                <?php
                  $categories = $this->db->order_by('name','asc')->get(db_prefix() . 'deals_business_categories')->result_array();
                  echo render_select('business_category', $categories, array('id', 'name'), 'business_category_name', isset($deal) ? ($deal['business_category'] ?? '') : '');
                ?>
              </div>
              <div class="col-md-6">
                <?php 
				  //echo render_select('assigned', $staff, array('staffid', array('firstname', 'lastname')), 'deal_add_edit_assigned', isset($deal) ? $deal['assigned'] : ''); 
					$loggedInStaffId = get_staff_user_id();  // Logged-in member ID

					$assignedValue = isset($deal)
						? $deal['assigned']                                // editing → use DB value
						: $loggedInStaffId;                                // creating → auto-select logged-in staff

					echo render_select(
						'assigned',
						$staff,
						array('staffid', array('firstname', 'lastname')),
						'deal_add_edit_assigned',
						$assignedValue
					);

				  ?>
              </div>
              <div class="col-md-12">
                <?php echo render_textarea('description', 'description', isset($deal) ? $deal['description'] : ''); ?>
              </div>
              <div class="col-md-4">
                <?php echo render_input('deal_value', 'deal_value', isset($deal) ? $deal['deal_value'] : '', 'number'); ?>
              </div>
              <div class="col-md-4">
                <?php echo render_date_input('expected_close_date', 'expected_close_date', isset($deal) ? $deal['expected_close_date'] : ''); ?>
              </div>
            </div>
            <div class="text-right">
              <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>

<script>
	
  	$('form').on('submit', function(e) {
		var phone = $('input[name="phonenumber"]').val().trim();

		// Check exactly 10 digits
		if (!/^[0-9]{10}$/.test(phone)) {
			alert("Phone number must be a 10-digit valid number.");
			e.preventDefault();
			return false;
		}
	});	
	
  // Ensure DOM is ready
  $(document).ready(function() {

    // Populate stage dropdowns for existing rows (on create page, this will be the first empty row)
    $('#deal-pipelines-list .pipeline-row').each(function() {
      var $row = $(this);
      var $pipelineSelect = $row.find('.pipeline-select');
      var $stageSelect = $row.find('.stage-select');
      var pipelineId = $pipelineSelect.val();
      
      // If the stage select is empty (like in 'create' mode), populate it.
      // If in 'edit' mode, the options are already rendered by PHP, so we do nothing.
      if ($stageSelect.find('option').length <= 1) {
        populateStages($stageSelect, pipelineId);
      }
    });
  });

  function addPipelineRow() {
    var idx = $('#deal-pipelines-list .pipeline-row').length;
    
    // UPDATED: This HTML variable now matches the new vertical layout
    var row = `
      <div class="pipeline-row" style="border: 1px solid #ddd; padding: 15px; margin-bottom: 10px; border-radius: 4px; position: relative;">
        <a href="#" class="text-danger" onclick="removePipelineRow(this); return false;" style="position: absolute; top: 10px; right: 10px;"><i class="fa-regular fa-trash-can"></i></a>
        
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
              <label class="control-label"><?php echo _l('pipeline'); ?></label>
              <select name="pipelines[${idx}][pipeline_id]" class="form-control pipeline-select">
                <?php foreach (($pipelines ?? []) as $pipeline) { ?>
                  <option value="<?php echo (int)$pipeline['id']; ?>"><?php echo html_entity_decode($pipeline['name']); ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
              <label class="control-label"><?php echo _l('stage'); ?></label>
              <select name="pipelines[${idx}][stage_id]" class="form-control stage-select">
                <option value=""><?php echo _l('select_stage'); ?></option>
              </select>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label class="control-label"><?php echo _l('rating'); ?></label>
              <select name="pipelines[${idx}][score]" class="form-control">
                <?php for ($i = 1; $i <= 10; $i++) { ?>
                  <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
        </div>
      </div>`;
      
    $('#deal-pipelines-list').append(row);

    // Populate stages for the new row
    var $newRow = $('#deal-pipelines-list .pipeline-row').last();
    var pipelineId = $newRow.find('.pipeline-select').val();
    var $stageSelect = $newRow.find('.stage-select');
    populateStages($stageSelect, pipelineId);
  }

  function removePipelineRow(el) {
    $(el).closest('.pipeline-row').remove();
  }

  function populateStages($stageSelect, pipelineId) {
    // Clear existing options
    $stageSelect.empty().append('<option value=""><?php echo _l('select_stage'); ?></option>');
    
    if (!pipelineId) {
      return; // No pipeline selected, just leave it empty
    }

    // Show loading state
    $stageSelect.prop('disabled', true);

    $.get(admin_url + 'deals/get_stages/' + pipelineId, function(res) {
      try {
        res = typeof res === 'string' ? JSON.parse(res) : res;
      } catch (e) {
        res = { success: false, stages: [] };
      }

      if (res.success && res.stages && res.stages.length > 0) {
        res.stages.forEach(function(stage) {
          $stageSelect.append('<option value="' + stage.id + '">' + $('<div>').text(stage.name).html() + '</option>');
        });
      } else {
        $stageSelect.append('<option value=""><?php echo _l('no_stages_found'); ?></option>');
      }

      // Re-enable 
      $stageSelect.prop('disabled', false);
      
    }).fail(function() {
      $stageSelect.append('<option value=""><?php echo _l('error_loading_stages'); ?></option>');
      $stageSelect.prop('disabled', false);
    });
  }

  // This function was already correct and does not need changes.
  $(document).on('change', '.pipeline-select', function() {
    var $row = $(this).closest('.pipeline-row');
    var pipelineId = $(this).val();
    var $stageSelect = $row.find('.stage-select');
    populateStages($stageSelect, pipelineId);
  });
</script>