<?php defined(constant_name: 'BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <div class="tw-flex tw-justify-between tw-items-center">
              <h4 class="tw-m-0"><?php echo _l('deals'); ?></h4>
              <div>
                <a href="<?php echo admin_url('deals?view=kanban'); ?>" class="btn btn-default"><i class="fa fa-th"></i> <?php echo _l('deals_kanban'); ?></a>
                <a href="<?php echo admin_url('deals/create'); ?>" class="btn btn-primary"><i class="fa-solid fa-plus"></i> <?php echo _l('new_deal'); ?></a>
              </div>
            </div>
            <hr class="hr-panel-heading" />
            <div class="table-responsive">
              <table class="table dt-table">
                <thead>
                  <tr>
                    <th><?php echo _l('id'); ?></th>
                    <th><?php echo _l('name'); ?></th>
                    <th><?php echo _l('company'); ?></th>
                    <th><?php echo _l('status'); ?></th>
                    <th><?php echo _l('deal_value'); ?></th>
                    <th><?php echo _l('dateadded'); ?></th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach($deals as $deal){ ?>
                    <tr>
                      <td>#<?php echo (int)$deal['id']; ?></td>
                      <td><?php echo html_entity_decode($deal['name']); ?></td>
                      <td><?php echo html_entity_decode($deal['company']); ?></td>
                      <td><span class="label label-default"><?php echo (int)$deal['status']; ?></span></td>
                      <td><?php echo app_format_money((float)$deal['deal_value'], get_base_currency()); ?></td>
                      <td><?php echo _dt(to_sql_date($deal['dateadded'])); ?></td>
                    </tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>


