<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <h4 class="tw-mt-0 tw-mb-3"><?php echo html_entity_decode($title); ?></h4>
            <form method="post" action="<?php echo admin_url('deals/email_template' . (isset($template['id']) ? '/' . (int)$template['id'] : '')); ?>" autocomplete="off">
              <?php if ($this->security && $this->security->get_csrf_token_name()) { ?>
              <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
              <?php } ?>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="control-label">Name</label>
                    <input type="text" name="name" class="form-control" required value="<?php echo isset($template['name']) ? html_entity_decode($template['name']) : ''; ?>">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="control-label">Slug</label>
                    <input type="text" name="slug" class="form-control" required value="<?php echo isset($template['slug']) ? html_entity_decode($template['slug']) : ''; ?>">
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="control-label"><?php echo _l('subject'); ?></label>
                    <input type="text" name="subject" class="form-control" value="<?php echo isset($template['subject']) ? html_entity_decode($template['subject']) : ''; ?>">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="control-label"><?php echo _l('description'); ?></label>
                    <input type="text" name="description" class="form-control" value="<?php echo isset($template['description']) ? html_entity_decode($template['description']) : ''; ?>">
                  </div>
                </div>
              </div>

              <div class="form-group">
                <label class="control-label"><?php echo _l('message'); ?></label>
                <textarea name="message" rows="10" class="form-control tinymce"><?php echo isset($template['message']) ? html_entity_decode($template['message']) : ''; ?></textarea>
              </div>

              <div class="form-group">
                <label class="control-label">Variables (comma separated)</label>
                <input type="text" name="variables" class="form-control" placeholder="{username}, {deal_name}, {company}" value="<?php echo isset($template['variables']) ? html_entity_decode($template['variables']) : ''; ?>">
                <span class="text-muted"><?php echo _l('use_variables_in_body'); ?></span>
              </div>

              <div class="checkbox checkbox-primary">
                <input type="checkbox" name="active" id="tpl-active" <?php echo !isset($template['active']) || !empty($template['active']) ? 'checked' : ''; ?>>
                <label for="tpl-active"><?php echo _l('active'); ?></label>
              </div>

              <div class="tw-mt-3">
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                <a href="<?php echo admin_url('deals/email_templates'); ?>" class="btn btn-default"><?php echo _l('close'); ?></a>
              </div>

              <div class="tw-mt-3 text-muted">
                <strong>Available merge fields:</strong>
                <div>{username}, {deal_name}, {company}, {deal_value}, {assigned_name}</div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>

