<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
if (!isset($items)) {
    $CI = &get_instance();
    $items = $CI->db->get(db_prefix() . 'deals_interested_in')->result_array();
}
$csrf_name = $CI->security->get_csrf_token_name();
$csrf_hash = $CI->security->get_csrf_hash();
?>
<div class="panel_s">
    <div class="panel-body">
        <a href="#" onclick="new_item(); return false;" class="btn btn-primary tw-mb-2">
            <i class="fa fa-plus"></i> New Interested In
        </a>

        <div class="panel_s">
            <div class="panel-body panel-table-full">
                <?php if (count($items) > 0) { ?>
                <table class="table dt-table" data-order-col="1" data-order-type="asc">
                    <thead>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Created At</th>
                        <th><?= _l('options'); ?></th>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $item) { ?>
                        <tr>
                            <td><?= $item['id']; ?></td>
                            <td>
                                <a href="#" onclick="edit_item(this,<?= $item['id']; ?>); return false;"
                                   data-name="<?= html_escape($item['name']); ?>">
                                    <?= $item['name']; ?>
                                </a>
                            </td>
                            <td><?= $item['created_at']; ?></td>
                            <td>
                                <a href="#" onclick="edit_item(this,<?= $item['id']; ?>); return false;"
                                   data-name="<?= html_escape($item['name']); ?>">
                                    <i class="fa fa-pencil"></i>
                                </a>

                                <!-- DELETE USING CONTROLLER (NO AJAX) -->
                                <a href="<?= admin_url('deals/delete_interested_in/' . $item['id']); ?>"
								   class="text-danger"
								   onclick="return confirm('Are you sure you want to delete this?');">
								   <i class="fa fa-trash"></i>
								</a>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
                <?php } else { ?>
                    <p>No Interested In Found</p>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- MODAL -->
<div class="modal fade" id="item_modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <span class="edit-title">Edit</span>
                    <span class="add-title">New Interested In</span>
                </h4>
            </div>
            <div class="modal-body">
                <div id="additional"></div>
                <div class="form-group">
                    <label>Name</label>
                    <input type="text" id="name" class="form-control">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-default" data-dismiss="modal">Close</button>
                <!-- <button class="btn btn-primary" onclick="manage_item()">Save</button> -->
				<button type="button" class="btn btn-primary" onclick="manage_item()">Save</button>
            </div>
        </div>
    </div>
</div>

<script>
    var CSRF = { name: '<?= $csrf_name; ?>', value: '<?= $csrf_hash; ?>' };

    function getInterestedApiUrl() {
        return (typeof admin_url !== 'undefined' ? admin_url : '<?= admin_url(); ?>') + 'deals/interested_in';
    }

    // CREATE + UPDATE still using AJAX
    function requestInterested(action, payload, callback) {
        var form = new FormData();
        form.append('action', action);

        Object.keys(payload || {}).forEach(function(k) {
            form.append(k, payload[k]);
        });

        form.append(CSRF.name, CSRF.value);

        fetch(getInterestedApiUrl(), {
            method: 'POST',
            body: form,
            credentials: 'same-origin',
            headers: { 'X-Requested-With': 'XMLHttpRequest' }
        })
        .then(r => r.json().catch(() => ({ success:false })))
        .then(function(data) {
            if (typeof callback === 'function') {
                callback(!!data.success, data);
            } else {
                if (data.success) location.reload();
                else alert('Operation failed');
            }
        });
    }

    // Handle Create / Update
    function manage_item() {
        var nameInput = document.getElementById('name');
        var idInput = document.querySelector('#additional input[name="id"]');
        var payload = {};

        if (!nameInput.value.trim()) {
            alert('Name is required.');
            return false;
        }

        payload.name = nameInput.value.trim();

        if (idInput) {
            payload.id = idInput.value;
            requestInterested('update', payload, function(success) {
                if (success) location.reload();
                else alert('Update failed');
            });
        } else {
            requestInterested('create', payload, function(success) {
                if (success) location.reload();
                else alert('Creation failed');
            });
        }
    }

    function new_item() {
        $('#item_modal').modal('show');
        $('.edit-title').addClass('hide');
        $('.add-title').removeClass('hide');
        $('#additional').html('');
        $('#name').val('');
    }

    function edit_item(invoker, id) {
        $('#item_modal').modal('show');
        $('#additional').html('<input type="hidden" name="id" value="' + id + '">');
        $('#name').val($(invoker).data('name'));
        $('.add-title').addClass('hide');
        $('.edit-title').removeClass('hide');
    }
</script>
