<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<div id="wrapper">
    <div class="content" id="vueApp">
        <div class="row">
            <div class="col-md-12">
                <div class="deals-overview tw-mb-6">
                    <h4 class="tw-my-0 tw-font-bold tw-text-xl tw-mb-2">
                        <?php echo _l('deals'); ?>
                    </h4>
                    <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                        <div class="tw-grid tw-gap-2 sm:tw-grid-flow-col sm:tw-auto-cols-max tw-overflow-x-auto" id="deals-filter-buttons">
                            <!-- Pipeline Filters -->
                            <div class="tw-mb-2">
                                <strong><?php echo _l('pipeline'); ?>:</strong>
                                <?php foreach ($pipelines ?? [] as $pipeline) { ?>
                                    <button type="button"
                                        class="tw-bg-transparent tw-border tw-border-solid tw-border-neutral-300 tw-shadow-sm tw-py-1 tw-px-2 tw-rounded-lg tw-text-sm hover:tw-bg-neutral-200/60 tw-text-neutral-600 hover:tw-text-neutral-600 focus:tw-text-neutral-600 text-left deals-pipeline-filter"
                                        data-pipeline-id="<?php echo e($pipeline['id']); ?>">
                                        <span class="tw-font-medium"><?php echo e($pipeline['name']); ?></span>
                                    </button>
                                <?php } ?>
                            </div>
                            <!-- Stage Filters (dynamically populated) -->
                            <div class="tw-mb-2" id="stage-filters-container" style="display:none;">
                                <strong><?php echo _l('stage'); ?>:</strong>
                                <div id="stage-filters-inner"></div>
                            </div>
                            <!-- Status Filters -->
                            <div class="tw-mb-2">
                                <strong><?php echo _l('status'); ?>:</strong>
                                <?php foreach ($statuses ?? [] as $status) { ?>
                                    <button type="button"
                                        class="tw-bg-transparent tw-border tw-border-solid tw-border-neutral-300 tw-shadow-sm tw-py-1 tw-px-2 tw-rounded-lg tw-text-sm hover:tw-bg-neutral-200/60 tw-text-neutral-600 hover:tw-text-neutral-600 focus:tw-text-neutral-600 text-left deals-status-filter"
                                        data-status-id="<?php echo e($status['id']); ?>">
                                        <span class="tw-font-medium"><?php echo e($status['name']); ?></span>
                                    </button>
                                <?php } ?>
                            </div>
                            <!-- Business Categories Filters -->
                            <div class="tw-mb-2">
                                <strong><?php echo _l('business_categories'); ?>:</strong>
                                <?php foreach ($business_categories ?? [] as $category) { ?>
                                    <button type="button"
                                        class="tw-bg-transparent tw-border tw-border-solid tw-border-neutral-300 tw-shadow-sm tw-py-1 tw-px-2 tw-rounded-lg tw-text-sm hover:tw-bg-neutral-200/60 tw-text-neutral-600 hover:tw-text-neutral-600 focus:tw-text-neutral-600 text-left deals-category-filter"
                                        data-category-id="<?php echo e($category['id']); ?>">
                                        <span class="tw-font-medium"><?php echo e($category['name']); ?></span>
                                    </button>
                                <?php } ?>
                            </div>
                            <!-- Sources Filters -->
                            <div class="tw-mb-2">
                                <strong><?php echo _l('sources'); ?>:</strong>
                                <?php foreach ($sources ?? [] as $source) { ?>
                                    <button type="button"
                                        class="tw-bg-transparent tw-border tw-border-solid tw-border-neutral-300 tw-shadow-sm tw-py-1 tw-px-2 tw-rounded-lg tw-text-sm hover:tw-bg-neutral-200/60 tw-text-neutral-600 hover:tw-text-neutral-600 focus:tw-text-neutral-600 text-left deals-source-filter"
                                        data-source-id="<?php echo e($source['id']); ?>">
                                        <span class="tw-font-medium"><?php echo e($source['name']); ?></span>
                                    </button>
                                <?php } ?>
                            </div>
                            <!-- Ratings Filters -->
                            <div class="tw-mb-2">
                                <strong><?php echo _l('ratings'); ?>:</strong>
                                <?php foreach ($ratings ?? [] as $rating) { ?>
                                    <button type="button"
                                        class="tw-bg-transparent tw-border tw-border-solid tw-border-neutral-300 tw-shadow-sm tw-py-1 tw-px-2 tw-rounded-lg tw-text-sm hover:tw-bg-neutral-200/60 tw-text-neutral-600 hover:tw-text-neutral-600 focus:tw-text-neutral-600 text-left deals-rating-filter"
                                        data-rating-id="<?php echo e($rating['id']); ?>">
                                        <span class="tw-font-medium"><?php echo e($rating['name']); ?> (<?php echo e($rating['score']); ?>)</span>
                                    </button>
                                <?php } ?>
                            </div>
                            <!-- Selected Filters Display -->
                            <div class="tw-mb-2" id="active-filters-container" style="display:none;">
                                <strong><?php echo _l('active_filters'); ?>:</strong>
                                <span id="active-filters-list"></span>
                                <button type="button" class="btn btn-default btn-sm tw-ml-2" id="clear-filters-btn">
                                    <?php echo _l('reset'); ?>
                                </button>
                            </div>
                        </div>
                        <!-- View Toggle -->
                        <div class="tw-flex tw-items-center tw-space-x-2">
                            <button id="view-table-btn" class="btn btn-primary"><i class="fa fa-table"></i> <?php echo _l('table_view'); ?></button>
                            <button id="view-kanban-btn" class="btn btn-default"><i class="fa fa-grip-vertical"></i> <?php echo _l('deals_kanban'); ?></button>
                        </div>
                    </div>
                </div>

                <div class="_buttons tw-mb-2">
                    <div class="tw-flex tw-items-center tw-justify-between tw-space-x-2 rtl:tw-space-x-reverse">
                        <div class="tw-flex tw-items-center tw-space-x-1 rtl:tw-space-x-reverse">
                            <a href="<?php echo admin_url('deals/create'); ?>" class="btn btn-primary">
                                <i class="fa-regular fa-plus"></i>
                                <?php echo _l('new_deal'); ?>
                            </a>
                            <a href="<?php echo admin_url('deals/import'); ?>" class="hidden-xs btn btn-default">
                                <i class="fa-solid fa-upload tw-mr-1"></i>
                                <?php echo _l('import_deals'); ?>
                            </a>
							
							<!-- TEAM GROUP DROPDOWN -->
							<select id="filter_team_group"
								class="selectpicker"
								data-width="200px"
								data-live-search="true"
								multiple
								title="Team Group">
								<?php foreach ($all_team_groups ?? [] as $g) { ?>
									<option value="<?php echo $g['id']; ?>">
										<?php echo e($g['name']); ?>
									</option>
								<?php } ?>
							</select>

							<!-- TEAM SUB GROUP DROPDOWN -->
							<select id="filter_team_sub_group"
								class="selectpicker"
								data-width="220px"
								data-live-search="true"
								multiple
								title="Team Sub Group">
								<?php foreach ($all_team_sub_groups ?? [] as $sg) { ?>
									<option value="<?php echo $sg['id']; ?>"
										data-group-id="<?php echo $sg['team_group_id']; ?>">
										<?php echo e($sg['sub_group_name']); ?>
									</option>
								<?php } ?>
							</select>

                        </div>
                        <div class="tw-inline">
                            <app-filters id="<?php echo App_table::find('deals')->id(); ?>" view="<?php echo App_table::find('deals')->viewName(); ?>"
                                :rules="extra.dealsRules || defaultDealsRules"
                                :saved-filters="<?php echo App_table::find('deals')->filtersJs(); ?>"
                                :available-rules="<?php echo App_table::find('deals')->rulesJs(); ?>">
                            </app-filters>
                            <?php echo form_hidden('sort_type'); ?>
                            <?php echo form_hidden('sort', ''); ?>
                        </div>
                    </div>
                </div>

                <div class="panel_s">
                    <div class="panel-body">
                        <!-- Table View -->
                        <div class="row" id="deals-table" style="display: block;">
                            <div class="col-md-12">
                                <!-- Bulk Actions Modal -->
                                <div class="modal fade bulk_actions" id="deals_bulk_actions" tabindex="-1" role="dialog">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                                <h4 class="modal-title"><?php echo _l('bulk_actions'); ?></h4>
                                            </div>
                                            <div class="modal-body">
                                                <div class="checkbox checkbox-danger">
                                                    <input type="checkbox" name="mass_delete" id="mass_delete">
                                                    <label for="mass_delete"><?php echo _l('mass_delete'); ?></label>
                                                </div>
                                                <hr class="mass_delete_separator" />
                                                <div id="bulk_change">
                                                    <div class="form-group">
                                                        <label for="move_to_pipeline_bulk"><?php echo _l('move_to_pipeline'); ?></label>
                                                        <select name="move_to_pipeline_bulk" id="move_to_pipeline_bulk" class="selectpicker" data-width="100%">
                                                            <option value=""><?php echo _l('select_pipeline'); ?></option>
                                                            <?php foreach ($pipelines ?? [] as $pipeline) { ?>
                                                                <option value="<?php echo $pipeline['id']; ?>">
                                                                    <?php echo $pipeline['name']; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                                                <a href="#" class="btn btn-primary" onclick="deals_bulk_action(this); return false;"><?php echo _l('confirm'); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Deals Table -->
                                <div class="panel-table-full">
                                    <?php
                                    // Build columns for server-side datatable (must match server output order)
                                    $table_data = [];
                                    $_table_data = [
                                        '<div class="checkbox mass_select_all_wrap"><input type="checkbox" id="mass_select_all" data-to-table="deals"><label></label></div>',
                                        [
                                            'name' => _l('the_number_sign'),
                                            'th_attrs' => ['class' => 'toggleable', 'id' => 'th-number'],
                                        ],
                                        [
                                            'name' => _l('deal_name'),
                                            'th_attrs' => ['class' => 'toggleable', 'id' => 'th-name'],
                                        ],
                                        [
                                            'name' => _l('company'),
                                            'th_attrs' => ['class' => 'toggleable', 'id' => 'th-company'],
                                        ],
										[
											'name' => _l('email'),
											'th_attrs' => ['class' => 'toggleable', 'id' => 'th-email'],
										],
										[
											'name' => _l('phonenumber'),
											'th_attrs' => ['class' => 'toggleable', 'id' => 'th-phonenumber'],
										],
                                        [
                                            'name' => _l('pipelines') . ' / ' . _l('stage') . ' / ' . _l('score'),
                                            'th_attrs' => ['class' => 'toggleable', 'id' => 'th-pipelines-all'],
                                        ],
                                        [
                                            'name' => _l('deal_value'),
                                            'th_attrs' => ['class' => 'toggleable', 'id' => 'th-deal-value'],
                                        ],
                                        [
                                            'name' => _l('assigned_to'),
                                            'th_attrs' => ['class' => 'toggleable', 'id' => 'th-assigned'],
                                        ],
                                        [
                                            'name' => _l('status'),
                                            'th_attrs' => ['class' => 'toggleable', 'id' => 'th-status'],
                                        ],
                                        [
                                            'name' => _l('dateadded'),
                                            'th_attrs' => ['class' => 'date-created toggleable', 'id' => 'th-date-created'],
                                        ],
                                    ];

                                    foreach ($_table_data as $_t) {
                                        array_push($table_data, $_t);
                                    }

                                    // Add custom fields if any (keeps parity with leads table)
                                    $custom_fields = get_custom_fields('deals', ['show_on_table' => 1]);
                                    foreach ($custom_fields as $field) {
                                        array_push($table_data, [
                                            'name' => $field['name'],
                                            'th_attrs' => ['data-type' => $field['type'], 'data-custom-field' => 1],
                                        ]);
                                    }

                                    $table_data = hooks()->apply_filters('deals_table_columns', $table_data);

                                    render_datatable($table_data, 'deals', ['customizable-table number-index-2'], [
                                        'id' => 'deals',
                                        'data-last-order-identifier' => 'deals',
                                        'data-default-order' => get_table_last_order('deals'),
                                    ]);
                                    ?>
                                </div>
                            </div>
                        </div>
                        <!-- Kanban View -->
                        <div class="row kanban-wrapper" id="deals-kanban" style="display: none;">
                            <div class="col-md-12">
                                <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                                    <h4 class="tw-m-0"><?php echo _l('deals_kanban'); ?></h4>
                                    <select id="pipeline-filter" class="selectpicker" data-width="200px">
                                        <?php foreach ($pipelines as $pipeline) { ?>
                                            <option value="<?php echo e($pipeline['id']); ?>" <?php echo $pipeline['id'] == ($this->input->get('pipeline_id') ?: $pipelines[0]['id']) ? 'selected' : ''; ?>>
                                                <?php echo html_entity_decode($pipeline['name']); ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <hr class="hr-panel-heading" />
                                <div id="kanban-columns"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>
<script src="<?php echo module_dir_url('deals', 'assets/js/deals_kanban.js'); ?>"></script>
<script>
    // NOTE: avoid overriding global DataTables methods here. Overriding core $.fn.dataTable
    // can break other scripts (colReorder, app global inits, etc). Instead, deals table
    // initialization below guards against double-init and retries if DataTables isn't loaded yet.

    // Data for filters (from PHP)
    var pipelineStages = <?php echo json_encode(array_map(function($pipeline) {
        return [
            'id' => $pipeline['id'],
            'name' => $pipeline['name'],
            'stages' => $this->deals_model->get_stages($pipeline['id']) ?? []
        ];
    }, $pipelines ?? [])) ?: '[]'; ?>;
    var statuses = <?php echo json_encode($statuses ?? []) ?: '[]'; ?>;
    var businessCategories = <?php echo json_encode($business_categories ?? []) ?: '[]'; ?>;
    var sources = <?php echo json_encode($sources ?? []) ?: '[]'; ?>;
    var ratings = <?php echo json_encode($ratings ?? []) ?: '[]'; ?>;

    // State
    var selectedPipelines = [];
    var activeFilters = [];
    var viewMode = 'table'; // 'table' or 'kanban'

    // Helper to update the active filters display
    function renderActiveFilters() {
        var $container = document.getElementById('active-filters-container');
        var $list = document.getElementById('active-filters-list');
        $list.innerHTML = '';
        if (activeFilters.length === 0) {
            $container.style.display = 'none';
            return;
        }
        $container.style.display = '';
        activeFilters.forEach(function(filter) {
            var span = document.createElement('span');
            span.className = 'label label-primary tw-mr-1';
            span.textContent = filter.name + ' ';
            var icon = document.createElement('i');
            icon.className = 'fa fa-times tw-ml-1 tw-cursor-pointer';
            icon.style.cursor = 'pointer';
            icon.onclick = function() {
                removeFilter(filter.id);
            };
            span.appendChild(icon);
            $list.appendChild(span);
        });
    }

    // Helper to update the stage filters display
    function renderStageFilters() {
        var $container = document.getElementById('stage-filters-container');
        var $inner = document.getElementById('stage-filters-inner');
        $inner.innerHTML = '';
        if (selectedPipelines.length === 0) {
            $container.style.display = 'none';
            return;
        }
        $container.style.display = '';
        selectedPipelines.forEach(function(pipeline) {
            var div = document.createElement('div');
            div.className = 'tw-mt-1';
            var label = document.createElement('span');
            label.className = 'tw-font-semibold tw-mr-2';
            label.textContent = pipeline.name + ':';
            div.appendChild(label);
            (pipeline.stages || []).forEach(function(stage) {
                var btn = document.createElement('button');
                btn.type = 'button';
                btn.className = 'tw-bg-transparent tw-border tw-border-solid tw-border-neutral-300 tw-shadow-sm tw-py-1 tw-px-2 tw-rounded-lg tw-text-sm hover:tw-bg-neutral-200/60 tw-text-neutral-600 hover:tw-text-neutral-600 focus:tw-text-neutral-600 text-left deals-stage-filter';
                btn.setAttribute('data-pipeline-id', pipeline.id);
                btn.setAttribute('data-stage-id', stage.id);
                btn.innerHTML = '<span class="tw-font-medium">' + stage.name + '</span>';
                btn.addEventListener('click', function() {
                    setDealsStageFilter(pipeline.id, stage.id);
                });
                div.appendChild(btn);
            });
            $inner.appendChild(div);
        });
    }

    // Toggle view
    function toggleView(mode) {
        viewMode = mode;
        $('#deals-table').toggle(mode === 'table');
        $('#deals-kanban').toggle(mode === 'kanban');
        $('#view-table-btn').toggleClass('btn-primary', mode === 'table').toggleClass('btn-default', mode !== 'table');
        $('#view-kanban-btn').toggleClass('btn-primary', mode === 'kanban').toggleClass('btn-default', mode !== 'kanban');
        // Hide filters in kanban view
        $('#deals-filter-buttons').toggle(mode === 'table');
        $('.tw-inline').toggle(mode === 'table'); // Hide app-filters in kanban
        if (mode === 'kanban') {
            refreshKanban();
        } else {
            reloadDealsTable();
        }
    }

    // Add filter
    function addFilter(id, name, type, value, pipelineId) {
        if (!activeFilters.some(function(f) { return f.id === id; })) {
            activeFilters.push({ id: id, name: name, type: type, value: value, pipelineId: pipelineId });
        }
        renderActiveFilters();
        if (viewMode === 'kanban' || type === 'pipeline' || type === 'stage') {
            toggleView('kanban');
        } else {
            reloadDealsTable();
        }
    }

    // Remove filter
    function removeFilter(filterId) {
        activeFilters = activeFilters.filter(function(f) { return f.id !== filterId; });
        if (filterId.startsWith('stage_')) {
            var pipelineId = filterId.split('_')[1];
            if (!activeFilters.some(function(f) { return f.pipelineId == pipelineId && f.type === 'stage'; })) {
                selectedPipelines = selectedPipelines.filter(function(p) { return p.id != pipelineId; });
                renderStageFilters();
                toggleView('table');
            }
        }
        if (filterId.startsWith('pipeline_')) {
            var pipelineId = filterId.split('_')[1];
            selectedPipelines = selectedPipelines.filter(function(p) { return p.id != pipelineId; });
            activeFilters = activeFilters.filter(function(f) { return !(f.type === 'stage' && f.pipelineId == pipelineId); });
            renderStageFilters();
            toggleView('table');
        }
        renderActiveFilters();
        if (viewMode === 'kanban') {
            refreshKanban();
        } else {
            reloadDealsTable();
        }
    }

    // Clear all filters
    function clearFilters() {
        activeFilters = [];
        selectedPipelines = [];
        renderActiveFilters();
        renderStageFilters();
        toggleView('table');
        reloadDealsTable();
    }

    // Pipeline filter
    function setDealsPipelineFilter(pipelineId) {
        var pipeline = pipelineStages.find(function(p) { return p && p.id == pipelineId; });
        if (!pipeline) return;
        if (!selectedPipelines.some(function(p) { return p.id == pipelineId; })) {
            selectedPipelines = [pipeline];
            activeFilters = activeFilters.filter(function(f) { return f.type !== 'pipeline' && f.type !== 'stage'; });
            addFilter('pipeline_' + pipelineId, pipeline.name, 'pipeline', pipelineId);
            renderStageFilters();
            toggleView('kanban');
        }
    }

    // Stage filter
    function setDealsStageFilter(pipelineId, stageId) {
        var pipeline = pipelineStages.find(function(p) { return p && p.id == pipelineId; });
        if (!pipeline) return;
        var stage = (pipeline.stages || []).find(function(s) { return s && s.id == stageId; });
        if (!stage) return;
        addFilter('stage_' + pipelineId + '_' + stageId, stage.name, 'stage', stageId, pipelineId);
        toggleView('kanban');
    }

    // Status filter
    function setDealsStatusFilter(statusId) {
        var status = statuses.find(function(s) { return s && s.id == statusId; });
        if (!status) return;
        addFilter('status_' + statusId, status.name, 'status', statusId);
    }

    // Category filter
    function setDealsCategoryFilter(categoryId) {
        var category = businessCategories.find(function(c) { return c && c.id == categoryId; });
        if (!category) return;
        addFilter('category_' + categoryId, category.name, 'business_category', categoryId);
    }

    // Source filter
    function setDealsSourceFilter(sourceId) {
        var source = sources.find(function(s) { return s && s.id == sourceId; });
        if (!source) return;
        addFilter('source_' + sourceId, source.name, 'source', sourceId);
    }

    // Rating filter
    function setDealsRatingFilter(ratingId) {
        var rating = ratings.find(function(r) { return r && r.id == ratingId; });
        if (!rating) return;
        addFilter('rating_' + ratingId, rating.name + ' (' + rating.score + ')', 'rating', ratingId);
    }

    // Refresh Kanban view
    function refreshKanban() {
        var pipeline_id = selectedPipelines.length > 0 ? selectedPipelines[0].id : '<?php echo e($pipelines[0]["id"] ?? ""); ?>';
        if (!pipeline_id) {
            toggleView('table');
            return;
        }
        // Get CSRF token name and value from meta tags or global JS variable
        var csrfName = (typeof csrfData !== 'undefined' && csrfData.token_name) ? csrfData.token_name : (typeof app !== 'undefined' && app.csrf_token_name ? app.csrf_token_name : '<?php echo $this->security->get_csrf_token_name(); ?>');
        var csrfHash = (typeof csrfData !== 'undefined' && csrfData.hash) ? csrfData.hash : (typeof app !== 'undefined' && app.csrf_token ? app.csrf_token : '<?php echo $this->security->get_csrf_hash(); ?>');

        var getData = {
            pipeline_id: pipeline_id,
            filters: JSON.stringify(activeFilters)
        };
        getData[csrfName] = csrfHash;

        $.get(admin_url + 'deals/kanban', getData, function(response) {
            $('#kanban-columns').html($(response).find('#kanban-columns').html());
            $('.selectpicker').selectpicker('refresh');
            $('.deals-stage.sortable').sortable({
                items: 'li:not(.not-sortable)',
                connectWith: '.deals-stage.sortable',
                helper: function(e, li) {
                    return $(li).clone().addClass('kanban-drag');
                },
                update: function(event, ui) {
                    if (this === ui.item.parent()[0]) {
                        var deal_id = ui.item.data('deal-id');
                        var stage_id = $(this).data('stage-id');
                        var pipeline_id = $('#pipeline-filter').val() || (selectedPipelines.length > 0 ? selectedPipelines[0].id : '<?php echo e($pipelines[0]["id"] ?? ""); ?>');
                        // Add CSRF token to POST data
                        var postData = {
                            deal_id: deal_id,
                            stage_id: stage_id,
                            pipeline_id: pipeline_id
                        };
                        postData[csrfName] = csrfHash;
                        $.post(admin_url + 'deals/update_stage', postData).done(function(response) {
                            response = JSON.parse(response);
                            if (!response.success) {
                                alert_float('danger', response.message || '<?php echo _l('error_updating_stage'); ?>');
                            }
                            updateKanbanTotals();
                        });
                    }
                }
            });
            updateKanbanTotals();
        });
    }

    // Update Kanban totals
    function updateKanbanTotals() {
        $('.kan-ban-col').each(function() {
            var total = $(this).find('li.deal-kan-ban').length;
            $(this).find('.total-deals').text(total);
            $(this).find('.kanban-empty').toggleClass('hide', total > 0);
        });
    }

    // Pipeline filter change
    $('#pipeline-filter').on('change', function() {
        var pipelineId = $(this).val();
        setDealsPipelineFilter(pipelineId);
    });

    // Attach event listeners
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.deals-pipeline-filter').forEach(function(btn) {
            btn.addEventListener('click', function() {
                setDealsPipelineFilter(this.getAttribute('data-pipeline-id'));
            });
        });
        document.querySelectorAll('.deals-status-filter').forEach(function(btn) {
            btn.addEventListener('click', function() {
                setDealsStatusFilter(this.getAttribute('data-status-id'));
            });
        });
        document.querySelectorAll('.deals-category-filter').forEach(function(btn) {
            btn.addEventListener('click', function() {
                setDealsCategoryFilter(this.getAttribute('data-category-id'));
            });
        });
        document.querySelectorAll('.deals-source-filter').forEach(function(btn) {
            btn.addEventListener('click', function() {
                setDealsSourceFilter(this.getAttribute('data-source-id'));
            });
        });
        document.querySelectorAll('.deals-rating-filter').forEach(function(btn) {
            btn.addEventListener('click', function() {
                setDealsRatingFilter(this.getAttribute('data-rating-id'));
            });
        });
        document.getElementById('clear-filters-btn').addEventListener('click', function() {
            clearFilters();
        });
        document.getElementById('view-table-btn').addEventListener('click', function() {
            toggleView('table');
        });
        document.getElementById('view-kanban-btn').addEventListener('click', function() {
            toggleView('kanban');
        });

        // Initialize DataTable (without depending on Vue)
        initDealsTable();

        // Listen for app-filters component events and refresh table
        function onAppFiltersUpdated(e) {
            try {
                var incoming = (e && e.detail) ? e.detail : [];
                // Normalize to array of {id,name,type,value}
                if (Array.isArray(incoming)) {
                    activeFilters = incoming;
                } else if (incoming && typeof incoming === 'object' && Array.isArray(incoming.filters)) {
                    activeFilters = incoming.filters;
                }
            } catch (err) { /* noop */ }
            renderActiveFilters();
            if (viewMode === 'kanban') { refreshKanban(); }
            else { reloadDealsTable(); }
        }
        window.addEventListener('app:filters:updated', onAppFiltersUpdated);
        window.addEventListener('app:filters:apply', onAppFiltersUpdated);
        window.addEventListener('app:filters:change', onAppFiltersUpdated);
        window.addEventListener('app:filters:clear', function(){ activeFilters=[]; renderActiveFilters(); if (viewMode === 'table') { reloadDealsTable(); } else { refreshKanban(); } });
        // jQuery-style custom events fallback
        if (window.jQuery) {
            $(document).on('app:filters:updated app:filters:apply app:filters:change', function(e, payload){
                onAppFiltersUpdated({ detail: payload });
            });
            $(document).on('app:filters:clear', function(){ activeFilters=[]; renderActiveFilters(); if (viewMode === 'table') { reloadDealsTable(); } else { refreshKanban(); } });
        }
    });

    // Lightweight delegates: initialization and reload are delegated to module JS which
    // initializes the table via initDataTable and stores the API on window.dealsTable.
    function initDealsTable(attemptsLeft) {
        attemptsLeft = typeof attemptsLeft === 'number' ? attemptsLeft : 10;
        if (typeof window.dealsTable !== 'undefined') return;

        if (typeof initDataTable !== 'undefined') {
            try {
                // mirror the server-side setup used in module JS
                var serverParams = {};
                serverParams['custom_filters'] = function(data) {
                    if (typeof window.dealsFilters !== 'undefined') {
                        data.custom_filters = JSON.stringify(window.dealsFilters);
                    }
                };
                window.dealsTable = initDataTable('.table-deals', admin_url + 'deals/table', [0], [], serverParams, [1, 'desc']);
                console.log('initDealsTable: delegated to initDataTable');
                return;
            } catch (err) {
                console.warn('initDealsTable: delegate failed', err);
            }
        }

        // Retry later if needed
        if (attemptsLeft > 0) {
            setTimeout(function() { initDealsTable(attemptsLeft - 1); }, 200);
            return;
        }
        console.warn('initDealsTable: could not initialize deals table');
    }

    // Helper to reload/redraw DataTable with current filters. Safe for both serverSide and client-side tables.
    function reloadDealsTable() {
        if (window.dealsTable && window.dealsTable.ajax && typeof window.dealsTable.ajax.reload === 'function') {
            try { window.dealsTable.ajax.reload(null, false); } catch (e) { console.warn('reloadDealsTable: ajax.reload failed', e); }
            return;
        }
        if (window.dealsTable && typeof window.dealsTable.draw === 'function') {
            try { window.dealsTable.draw(false); } catch (e) { console.warn('reloadDealsTable: draw failed', e); }
            return;
        }
        // Fallback: attempt to init
        initDealsTable();
    }
	
	// TEAM GROUP DROPDOWN FILTER
	$('#filter_team_group').on('changed.bs.select', function () {
		let groups = $(this).val() || [];

		// Clear old filters of this type
		activeFilters = activeFilters.filter(f => f.type !== 'team_group');

		groups.forEach(id => {
			let text = $('#filter_team_group option[value="' + id + '"]').text().trim();
			addFilter('team_group_' + id, text, 'team_group', id);
		});

		reloadDealsTable();
	});

	// TEAM SUB GROUP DROPDOWN FILTER
	$('#filter_team_sub_group').on('changed.bs.select', function () {
		let subs = $(this).val() || [];

		activeFilters = activeFilters.filter(f => f.type !== 'team_sub_group');

		subs.forEach(id => {
			let text = $('#filter_team_sub_group option[value="' + id + '"]').text().trim();
			addFilter('team_sub_group_' + id, text, 'team_sub_group', id);
		});

		reloadDealsTable();
	});

</script>