<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_call_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <?php echo form_open(admin_url('deals/add_deal_call/' . $deal_id), ['id' => 'add_call_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('log_call'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="call_type" class="control-label"><?php echo _l('call_type'); ?> <span class="text-danger">*</span></label>
                    <select name="call_type" id="call_type" class="form-control" required>
                        <option value="incoming"><?php echo _l('incoming'); ?></option>
                        <option value="outgoing"><?php echo _l('outgoing'); ?></option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="outcome" class="control-label"><?php echo _l('outcome'); ?> <span class="text-danger">*</span></label>
                    <select name="outcome" id="outcome" class="form-control" required>
                        <option value="completed"><?php echo _l('completed'); ?></option>
                        <option value="missed"><?php echo _l('missed'); ?></option>
                        <option value="scheduled"><?php echo _l('scheduled'); ?></option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="call_duration" class="control-label"><?php echo _l('call_duration'); ?></label>
                    <input type="number" name="call_duration" id="call_duration" class="form-control" min="0">
                </div>
                <div class="form-group">
                    <label for="call_notes" class="control-label"><?php echo _l('call_notes'); ?></label>
                    <textarea name="call_notes" id="call_notes" class="form-control" rows="3"></textarea>
                </div>
                <div class="form-group">
                    <label for="call_date" class="control-label"><?php echo _l('call_date'); ?> <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <input type="text" name="call_date" id="call_date" class="form-control datetimepicker"
                            value="<?php echo date('Y-m-d H:i:s'); ?>" required>
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('log_call'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    appValidateForm($('#add_call_form'), {
        call_type: 'required',
        outcome: 'required',
        call_date: 'required'
    });



    $('#add_call_modal').on('hidden.bs.modal', function() {
        $('#add_call_form')[0].reset();
        $('#call_date').val('<?php echo date('Y-m-d H:i:s'); ?>');
        $('#call_type').val('incoming');
        $('#outcome').val('completed');
    });

    // Initialize datetimepicker
    if (typeof($.fn.datetimepicker) !== 'undefined') {
        $('#call_date').datetimepicker({
            format: 'YYYY-MM-DD HH:mm:ss'
        });
    }
});
</script>
