<?php
defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'tbl_deals.id',
    'tbl_deals.name',
    'tbl_deals.company',
    '(SELECT GROUP_CONCAT(tbl_deals_pipelines.name) FROM tbl_deals_pipeline_relations 
      JOIN tbl_deals_pipelines ON tbl_deals_pipelines.id = tbl_deals_pipeline_relations.pipeline_id 
      WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id) as pipeline_names',
    '(SELECT GROUP_CONCAT(tbl_deals_stages.name) FROM tbl_deals_pipeline_relations 
      JOIN tbl_deals_stages ON tbl_deals_stages.id = tbl_deals_pipeline_relations.stage_id 
      WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id) as stage_names',
    '(SELECT GROUP_CONCAT(CONCAT(tbl_deals_pipelines.name, " - ", tbl_deals_stages.name, 
      IF(tbl_deals_pipeline_relations.score IS NOT NULL, CONCAT(" (", tbl_deals_pipeline_relations.score, ")"), "")) 
      FROM tbl_deals_pipeline_relations 
      JOIN tbl_deals_pipelines ON tbl_deals_pipelines.id = tbl_deals_pipeline_relations.pipeline_id 
      JOIN tbl_deals_stages ON tbl_deals_stages.id = tbl_deals_pipeline_relations.stage_id 
      WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id) as pipeline_relations',
    'tbl_deals.deal_value',
    'tbl_deals.assigned',
    'tbl_deals.status_final',
    'tbl_deals.dateadded'
];

$sIndexColumn = 'id';
$sTable = 'tbl_deals';
$join = [];
$where = [];

$filters = $this->input->post('filters');
if ($filters) {
    $filters = json_decode($filters, true);
    foreach ($filters as $filter) {
        if ($filter['type'] === 'pipeline') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                JOIN tbl_deals_pipelines ON tbl_deals_pipelines.id = tbl_deals_pipeline_relations.pipeline_id 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipelines.id = ' . $this->db->escape($filter['value']) . ')';
        } elseif ($filter['type'] === 'stage') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                JOIN tbl_deals_stages ON tbl_deals_stages.id = tbl_deals_pipeline_relations.stage_id 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_stages.id = ' . $this->db->escape($filter['value']) . '
                AND tbl_deals_pipeline_relations.pipeline_id = ' . $this->db->escape($filter['pipelineId']) . ')';
        } elseif ($filter['type'] === 'status') {
            $where[] = 'tbl_deals.status_final = ' . $this->db->escape($filter['value']);
        } elseif ($filter['type'] === 'business_category') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipeline_relations.business_category_id = ' . $this->db->escape($filter['value']) . ')';
        } elseif ($filter['type'] === 'source') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipeline_relations.source_id = ' . $this->db->escape($filter['value']) . ')';
        } elseif ($filter['type'] === 'rating') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipeline_relations.rating_id = ' . $this->db->escape($filter['value']) . ')';
        }
    }
}

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'tbl_deals.id',
    'tbl_deals.name',
    'tbl_deals.company',
    'tbl_deals.deal_value',
    'tbl_deals.assigned',
    'tbl_deals.status_final',
    'tbl_deals.dateadded'
]);

$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    $row[] = '<input type="checkbox" class="individual" data-to-table="deals" value="' . $aRow['id'] . '">';
    $row[] = '#' . $aRow['id'];
    $row[] = '<a href="' . admin_url('deals/view/' . $aRow['id']) . '">' . html_entity_decode($aRow['name']) . '</a><div class="row-options"><a href="' . admin_url('deals/view/' . $aRow['id']) . '">' . _l('view') . '</a> | <a href="' . admin_url('deals/edit/' . $aRow['id']) . '">' . _l('edit') . '</a> | <a href="' . admin_url('deals/delete/' . $aRow['id']) . '" class="text-danger _delete">' . _l('delete') . '</a></div>';
    $row[] = html_entity_decode($aRow['company']);
    
    // Primary pipeline and stage (first relation)
    $pipeline_names = explode(',', $aRow['pipeline_names']);
    $stage_names = explode(',', $aRow['stage_names']);
    $row[] = !empty($pipeline_names[0]) ? $pipeline_names[0] : '-';
    $row[] = !empty($stage_names[0]) ? $stage_names[0] : '-';
    
    // All pipeline relations
    $row[] = !empty($aRow['pipeline_relations']) ? str_replace(',', '<br>', $aRow['pipeline_relations']) : '-';
    
    $row[] = app_format_money((float)$aRow['deal_value'], get_base_currency());
    $row[] = !empty($aRow['assigned']) ? $aRow['assigned'] : '-';
    $row[] = '<span class="label label-' . ($aRow['status_final'] == 'won' ? 'success' : ($aRow['status_final'] == 'lost' ? 'danger' : 'default')) . '">' . ucfirst($aRow['status_final']) . '</span>';
    $row[] = _dt($aRow['dateadded']);
    
    $output['aaData'][] = $row;
}

echo json_encode($output);
die();