<?php
/**
 * Module Name: Lead Campaigns
 * Description: Custom module to manage form builder, lead forms, statuses, and profiles.
 * Version: 1.0
 * Author: CodeSynergiX
 */

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Register activation hook
 */
hooks()->add_action('app_admin_init', 'lead_campaigns_module_init_menu_items');
hooks()->add_action('admin_init', 'lead_campaigns_permissions');
hooks()->add_filter('module_lead_campaigns_action_links', 'lead_campaigns_module_action_links');

/**
 * Load module helper
 */
$CI = &get_instance();
$CI->load->helper(LEAD_CAMPAIGNS_MODULE_NAME . '/lead_campaigns');

/**
 * Register menu
 */
function lead_campaigns_module_init_menu_items()
{
    $CI = &get_instance();
    if (has_permission('lead_campaigns', '', 'view')) {
        $CI->app_menu->add_sidebar_menu_item('lead_campaigns', [
            'slug'     => 'lead_campaigns',
            'name'     => _l('lead_campaigns'),
            'icon'     => 'fa fa-rocket',
            'position' => 30,
            'href'     => admin_url('leadcampaigns'),
        ]);
    }
}

/**
 * Add permissions
 */
function lead_campaigns_permissions()
{
    $capabilities = [];
    $capabilities['capabilities'] = [
        'view'   => _l('permission_view') . ' (' . _l('permission_global') . ')',
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];

    register_staff_capabilities('lead_campaigns', $capabilities, _l('lead_campaigns'));
}

/**
 * Action links
 */
function lead_campaigns_module_action_links($actions)
{
    $actions[] = '<a href="' . admin_url('leadcampaigns') . '">' . _l('lead_campaigns') . '</a>';
    return $actions;
}
