<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Leadcampaigns extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('leadcampaigns_model');
    }

    public function index()
    {
        $data['title'] = _l('lead_campaigns');
        $data['forms'] = $this->leadcampaigns_model->get_forms();
        $this->load->view('leadcampaigns/index', $data);
    }

    public function formbuilder($id = '')
    {
        if ($this->input->post()) {
            $formData = $this->input->post();
            if ($id == '') {
                $insert_id = $this->leadcampaigns_model->add_form($formData);
                if ($insert_id) {
                    set_alert('success', _l('added_successfully', _l('form')));
                }
            } else {
                $success = $this->leadcampaigns_model->update_form($formData, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('form')));
                }
            }
            redirect(admin_url('leadcampaigns'));
        }

        $data['title'] = $id ? _l('edit_form') : _l('create_form');
        $data['form'] = $id ? $this->leadcampaigns_model->get_form($id) : null;
        $this->load->view('leadcampaigns/formbuilder', $data);
    }

    public function delete_form($id)
    {
        if (!$id) {
            redirect(admin_url('leadcampaigns'));
        }

        $response = $this->leadcampaigns_model->delete_form($id);
        if ($response) {
            set_alert('success', _l('deleted', _l('form')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('form')));
        }
        redirect(admin_url('leadcampaigns'));
    }

    public function import()
    {
        if ($this->input->post()) {
            $imported = $this->leadcampaigns_model->import_data($this->input->post());
            if ($imported) {
                set_alert('success', _l('data_imported_successfully'));
            } else {
                set_alert('warning', _l('data_import_failed'));
            }
            redirect(admin_url('leadcampaigns'));
        }

        $data['title'] = _l('import_leads');
        $this->load->view('leadcampaigns/import', $data);
    }

    public function manage_statuses()
    {
        $data['title'] = _l('lead_statuses');
        $data['statuses'] = $this->leadcampaigns_model->get_statuses();
        $this->load->view('leadcampaigns/manage_statuses', $data);
    }

    public function status()
    {
        $data = $this->input->post();
        if ($data['id'] == '') {
            $id = $this->leadcampaigns_model->add_status($data);
            if ($id) {
                set_alert('success', _l('added_successfully', _l('lead_status')));
            }
        } else {
            $success = $this->leadcampaigns_model->update_status($data['id'], $data);
            if ($success) {
                set_alert('success', _l('updated_successfully', _l('lead_status')));
            }
        }

        redirect(admin_url('leadcampaigns/manage_statuses'));
    }

    public function delete_status($id)
    {
        $deleted = $this->leadcampaigns_model->delete_status($id);
        if ($deleted) {
            set_alert('success', _l('deleted', _l('lead_status')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('lead_status')));
        }
        redirect(admin_url('leadcampaigns/manage_statuses'));
    }
}
