<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Lead Campaigns module install script
 */
$CI = &get_instance();

// 1. Create table if not exists
if (!$CI->db->table_exists(db_prefix() . 'leadcampaigns')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "leadcampaigns` (
      `id` INT(11) NOT NULL AUTO_INCREMENT,
      `name` VARCHAR(191) NOT NULL,
      `description` TEXT DEFAULT NULL,
      `status` TINYINT(1) DEFAULT 1,
      `start_date` DATE DEFAULT NULL,
      `end_date` DATE DEFAULT NULL,
      `created_by` INT(11) DEFAULT NULL,
      `date_created` DATETIME DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

// 2. Add permissions for admin/staff roles
$capabilities = [
    'view',
    'create',
    'edit',
    'delete',
];

foreach ($capabilities as $capability) {
    if (row_exists(db_prefix() . 'permissions', ['feature' => 'leadcampaigns', 'capability' => $capability]) === false) {
        $CI->db->insert(db_prefix() . 'permissions', [
            'feature'    => 'leadcampaigns',
            'capability' => $capability,
        ]);
    }
}

// 3. Assign permissions to all admin roles by default
$staff_roles = $CI->db->get(db_prefix() . 'roles')->result();
foreach ($staff_roles as $role) {
    foreach ($capabilities as $cap) {
        $exists = total_rows(db_prefix() . 'role_permissions', [
            'role_id'    => $role->roleid,
            'feature'    => 'leadcampaigns',
            'capability' => $cap,
        ]);
        if ($exists == 0) {
            $CI->db->insert(db_prefix() . 'role_permissions', [
                'role_id'    => $role->roleid,
                'feature'    => 'leadcampaigns',
                'capability' => $cap,
            ]);
        }
    }
}
