<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s lead-kan-ban kan-ban-col" data-col-status-id="<?= $status['id']; ?>">
    <div class="panel-heading">
        <?= e($status['name']); ?>
        <span class="tw-text-sm">(
            <?= count($leadcampaigns); ?>
            )</span>
    </div>
    <ul class="kan-ban-content sortable"
        data-lead-status-id="<?= $status['id']; ?>">
        <?php foreach ($leadcampaigns as $campaign) {
            $url = admin_url('leadcampaigns/campaign/' . $campaign['id']);
        ?>
        <li class="kan-ban-card" data-lead-id="<?= $campaign['id']; ?>">
            <div class="panel-body">
                <a href="<?= $url; ?>" class="tw-font-medium"><?= e($campaign['name']); ?></a>
                <p class="tw-text-sm text-muted"><?= _l('lead_value'); ?>:
                    <?= app_format_money($campaign['lead_value'], $base_currency->id); ?></p>
                <p class="tw-text-sm text-muted"><?= _l('lead_add_edit_email'); ?>:
                    <?= e($campaign['email']); ?></p>
                <p class="tw-text-xs text-muted"><?= _l('leads_dt_datecreated'); ?>:
                    <?= time_ago($campaign['dateadded']); ?></p>
            </div>
        </li>
        <?php } ?>
        <?php if (count($leadcampaigns) == 0) { ?>
        <li class="text-center empty"><?= _l('no_lead_campaigns_found'); ?></li>
        <?php } ?>
    </ul>
</div>
