<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel_s">
    <div class="panel-body">
        <?= form_open(admin_url('lead_campaigns/save/' . (isset($campaign) ? $campaign->id : '')), ['id' => 'lead_campaign_form']); ?>

        <h4 class="tw-font-semibold tw-text-xl mbot15">
            <?= isset($campaign) ? _l('edit_lead_campaign') : _l('add_lead_campaign'); ?>
        </h4>
        <hr class="hr-panel-heading" />

        <div class="form-group">
            <?= render_input('name', 'lead_campaign_name', isset($campaign) ? $campaign->name : ''); ?>
        </div>

        <div class="form-group">
            <?= render_textarea('description', 'lead_campaign_description', isset($campaign) ? $campaign->description : '', ['rows' => 4]); ?>
        </div>

        <div class="form-group">
            <?php
            $status_selected = isset($campaign) ? $campaign->status_id : '';
            echo render_select('status_id', $statuses, ['id', 'name'], 'lead_campaign_status', $status_selected);
            ?>
        </div>

        <div class="form-group text-right">
            <button type="submit" class="btn btn-primary">
                <i class="fa-regular fa-floppy-disk"></i> <?= _l('submit'); ?>
            </button>
            <a href="<?= admin_url('lead_campaigns'); ?>" class="btn btn-default">
                <?= _l('cancel'); ?>
            </a>
        </div>

        <?= form_close(); ?>
    </div>
</div>
