<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (isset($statuses) && is_array($statuses)) { ?>
<div class="row" id="kan-ban">
    <div class="kan-ban-content-wrapper">
        <div class="kan-ban-content">
            <?php foreach ($statuses as $status) { ?>
            <ul class="kan-ban-campaigns sortable"
                data-status-id="<?= $status['id']; ?>"
                data-status-order="<?= $status['statusorder']; ?>">
                <li class="kan-ban-title">
                    <span class="tw-font-medium" style="color:<?= $status['color']; ?>">
                        <?= $status['name']; ?>
                    </span>
                    <span class="pull-right"><?= total_rows(db_prefix() . 'lead_campaigns', ['status' => $status['id']]); ?></span>
                </li>
                <?php foreach ($this->Leadcampaigns_model->get_campaigns_by_status($status['id']) as $campaign) { ?>
                <li class="kan-ban-card" data-campaign-id="<?= $campaign['id']; ?>">
                    <div class="panel-body">
                        <h5 class="tw-font-semibold"><?= $campaign['name']; ?></h5>
                        <small class="tw-text-gray-500"><?= _l('created') . ': ' . _dt($campaign['datecreated']); ?></small>
                        <?php if (!empty($campaign['description'])) { ?>
                        <div class="tw-mt-2">
                            <?= character_limiter(strip_tags($campaign['description']), 100); ?>
                        </div>
                        <?php } ?>
                        <div class="tw-mt-3">
                            <a href="<?= admin_url('lead_campaigns/view/' . $campaign['id']); ?>" class="btn btn-sm btn-default">
                                <?= _l('view'); ?>
                            </a>
                            <a href="<?= admin_url('lead_campaigns/edit/' . $campaign['id']); ?>" class="btn btn-sm btn-info">
                                <?= _l('edit'); ?>
                            </a>
                        </div>
                    </div>
                </li>
                <?php } ?>
            </ul>
            <?php } ?>
        </div>
    </div>
</div>
<?php } else { ?>
<p class="text-center tw-text-gray-500"><?= _l('no_campaign_statuses_found'); ?></p>
<?php } ?>
