<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="campaign_status" tabindex="-1" role="dialog">
   <div class="modal-dialog">
      <?= form_open(admin_url('lead_campaigns/status'), ['id' => 'lead-campaign-status-form']); ?>
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">
               <span class="edit-title"><?= _l('edit_status'); ?></span>
               <span class="add-title"><?= _l('new_campaign_status'); ?></span>
            </h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div id="additional"></div>
                  <?= render_input('name', 'status_name'); ?>
                  <?= render_color_picker('color', _l('status_color')); ?>
                  <?= render_input('statusorder', 'status_order', total_rows(db_prefix() . 'lead_campaign_statuses') + 1, 'number'); ?>
               </div>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
            <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
         </div>
      </div>
      <?= form_close(); ?>
   </div>
</div>

<script>
  $(function () {
    appValidateForm($('#lead-campaign-status-form'), {
        name: 'required'
    }, manage_campaign_statuses);

    $('#campaign_status').on("hidden.bs.modal", function () {
        $('#additional').html('');
        $('#campaign_status input[name="name"]').val('');
        $('#campaign_status input[name="color"]').val('');
        $('#campaign_status input[name="statusorder"]').val('');
        $('.add-title').removeClass('hide');
        $('.edit-title').removeClass('hide');
        $('#campaign_status input[name="statusorder"]').val($('table tbody tr').length + 1);
    });
  });

  function new_status() {
      $('#campaign_status').modal('show');
      $('.edit-title').addClass('hide');
  }

  function edit_status(invoker, id) {
      $('#additional').append(hidden_input('id', id));
      $('#campaign_status input[name="name"]').val($(invoker).data('name'));
      $('#campaign_status .colorpicker-input').colorpicker('setValue', $(invoker).data('color'));
      $('#campaign_status input[name="statusorder"]').val($(invoker).data('order'));
      $('#campaign_status').modal('show');
      $('.add-title').addClass('hide');
  }

  function manage_campaign_statuses(form) {
      var data = $(form).serialize();
      var url = form.action;
      $.post(url, data).done(function (response) {
          window.location.reload();
      });
      return false;
  }
</script>
