<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="lead_campaign_modal" tabindex="-1" role="dialog">
   <div class="modal-dialog">
      <?php echo form_open(admin_url('leadcampaigns/save'), ['id' => 'lead-campaign-form']); ?>
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">
               <span class="edit-title"><?php echo _l('edit_lead_campaign'); ?></span>
               <span class="add-title"><?php echo _l('new_lead_campaign'); ?></span>
            </h4>
         </div>
         <div class="modal-body">
            <div id="additional"></div>
            <div class="form-group">
               <label for="name" class="control-label"><?php echo _l('campaign_name'); ?></label>
               <input type="text" name="name" id="name" class="form-control" required>
            </div>
            <div class="form-group">
               <label for="status" class="control-label"><?php echo _l('status'); ?></label>
               <select name="status" id="status" class="form-control">
                  <option value="active"><?php echo _l('active'); ?></option>
                  <option value="inactive"><?php echo _l('inactive'); ?></option>
               </select>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
         </div>
      </div>
      <?php echo form_close(); ?>
   </div>
</div>

<script>
   function new_campaign() {
      $('#lead_campaign_modal').modal('show');
      $('.edit-title').addClass('hide');
      $('#lead-campaign-form').trigger('reset');
      $('#additional').html('');
   }

   function edit_campaign(invoker, id) {
      $('#lead_campaign_modal').modal('show');
      $('.add-title').addClass('hide');
      $('#additional').html('<input type="hidden" name="id" value="' + id + '">');
      $('#lead-campaign-form input[name="name"]').val($(invoker).data('name'));
      $('#lead-campaign-form select[name="status"]').val($(invoker).data('status'));
   }

   $(function () {
      appValidateForm($('#lead-campaign-form'), {
         name: 'required'
      });
   });
</script>
