<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="lead-campaign-wrapper<?= $openEdit == true ? ' open-edit' : ''; ?>">
    <?php if (isset($campaign)) { ?>
        <div class="tw-flex tw-items-center tw-justify-end tw-space-x-1.5">
            <div class="lead-campaign-edit<?= isset($campaign) ? ' hide' : ''; ?>">
                <button type="button" class="btn btn-primary lead-campaign-save-btn"
                    onclick="document.getElementById('lead-campaign-form-submit').click();">
                    <?= _l('submit'); ?>
                </button>
            </div>
            <a href="#" campaign-edit data-toggle="tooltip"
                data-title="<?= _l('edit'); ?>"
                class="btn btn-default lead-campaign-top-btn !tw-px-3">
                <i class="fa-regular fa-pen-to-square"></i>
            </a>
        </div>
    <?php } ?>

    <div class="clearfix no-margin"></div>

    <?= form_open((isset($campaign) ? admin_url('lead_campaigns/campaign/' . $campaign->id) : admin_url('lead_campaigns/campaign')), ['id' => 'lead_campaign_form']); ?>
    <div class="row">
        <div class="lead-campaign-view<?= ! isset($campaign) ? ' hide' : ''; ?>" id="leadCampaignViewWrapper">
            <div class="col-md-6 col-xs-12">
                <h4><?= _l('lead_campaign_info'); ?></h4>
                <dl>
                    <dt><?= _l('campaign_name'); ?></dt>
                    <dd><?= isset($campaign) && $campaign->name != '' ? e($campaign->name) : '-' ?></dd>

                    <dt><?= _l('campaign_description'); ?></dt>
                    <dd><?= isset($campaign) && $campaign->description != '' ? e($campaign->description) : '-' ?></dd>

                    <dt><?= _l('campaign_start_date'); ?></dt>
                    <dd><?= isset($campaign) && $campaign->start_date ? _d($campaign->start_date) : '-' ?></dd>

                    <dt><?= _l('campaign_end_date'); ?></dt>
                    <dd><?= isset($campaign) && $campaign->end_date ? _d($campaign->end_date) : '-' ?></dd>

                    <dt><?= _l('created_at'); ?></dt>
                    <dd><?= isset($campaign) && $campaign->created_at ? _dt($campaign->created_at) : '-' ?></dd>
                </dl>
            </div>
        </div>

        <div class="lead-campaign-edit<?= isset($campaign) ? ' hide' : ''; ?>">
            <div class="col-md-6">
                <?= render_input('name', 'campaign_name', isset($campaign) ? $campaign->name : ''); ?>
                <?= render_textarea('description', 'campaign_description', isset($campaign) ? $campaign->description : ''); ?>
                <?= render_date_input('start_date', 'campaign_start_date', isset($campaign) ? $campaign->start_date : ''); ?>
                <?= render_date_input('end_date', 'campaign_end_date', isset($campaign) ? $campaign->end_date : ''); ?>
            </div>
        </div>
    </div>

    <div class="lead-campaign-edit<?= isset($campaign) ? ' hide' : ''; ?>">
        <hr class="-tw-mx-5 tw-border-neutral-200" />
        <button type="submit" class="btn btn-primary pull-right lead-campaign-save-btn" id="lead-campaign-form-submit">
            <?= _l('submit'); ?>
        </button>
        <button type="button" class="btn btn-default pull-right mright5" data-dismiss="modal">
            <?= _l('close'); ?>
        </button>
    </div>
    <div class="clearfix"></div>
    <?= form_close(); ?>
</div>
