<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (isset($campaign)) { ?>
<div class="panel_s">
    <div class="panel-body">
        <h4 class="tw-font-semibold tw-text-xl">
            <?= e($campaign->name); ?>
        </h4>
        <hr class="hr-panel-heading" />

        <div class="row">
            <div class="col-md-6">
                <p><strong><?= _l('lead_campaign_description'); ?>:</strong><br>
                    <?= !empty($campaign->description) ? nl2br(e($campaign->description)) : _l('not_available'); ?>
                </p>
                <p><strong><?= _l('lead_campaign_status'); ?>:</strong><br>
                    <?php
                    if (isset($campaign->status_data)) {
                        echo '<span class="label" style="background:' . e($campaign->status_data->color) . ';">' . e($campaign->status_data->name) . '</span>';
                    } else {
                        echo _l('not_available');
                    }
                    ?>
                </p>
            </div>
            <div class="col-md-6">
                <p><strong><?= _l('lead_campaign_created_by'); ?>:</strong><br>
                    <?= get_staff_full_name($campaign->addedfrom); ?>
                </p>
                <p><strong><?= _l('lead_campaign_created_date'); ?>:</strong><br>
                    <?= _dt($campaign->datecreated); ?>
                </p>
                <?php if (!empty($campaign->lastupdated)) { ?>
                <p><strong><?= _l('lead_campaign_last_updated'); ?>:</strong><br>
                    <?= _dt($campaign->lastupdated); ?>
                </p>
                <?php } ?>
            </div>
        </div>

        <hr />
        <div class="text-right">
            <a href="<?= admin_url('lead_campaigns/edit/' . $campaign->id); ?>" class="btn btn-info">
                <i class="fa-regular fa-pen-to-square"></i> <?= _l('edit'); ?>
            </a>
            <a href="<?= admin_url('lead_campaigns'); ?>" class="btn btn-default">
                <?= _l('go_back'); ?>
            </a>
        </div>
    </div>
</div>
<?php } else { ?>
<p class="text-danger"><?= _l('lead_campaign_not_found'); ?></p>
<?php } ?>
