<?php

// UPDATED: The entire function is replaced with new logic for multiple file handling.
function handle_product_upload($product_id)
{
    $CI = &get_instance();
    // UPDATED: Load the model to get/update DB
    $CI->load->model('products_model');

    // 1. Get existing images from DB
    $product = $CI->products_model->get_by_id_product($product_id);
    $existing_images = [];
    if (!empty($product->product_image)) {
        // UPDATED: Decode images from JSON string
        $decoded_images = @json_decode($product->product_image);
        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded_images)) {
            $existing_images = $decoded_images;
        } elseif (!empty($product->product_image)) {
            // UPDATED: Handle legacy single-image string
            $existing_images = [$product->product_image];
        }
    }

    $path = get_upload_path_by_type('products');
    _maybe_create_upload_path($path);

    // 2. Process deletions
    // UPDATED: Check for 'remove_images' array from the form
    $images_to_remove = $CI->input->post('remove_images');
    $images_updated = false; // Flag to track if we need to update the DB
    
    if ($images_to_remove && is_array($images_to_remove)) {
        foreach ($images_to_remove as $remove_filename) {
            // Find the image in our array
            if (($key = array_search($remove_filename, $existing_images)) !== false) {
                // Remove from array
                unset($existing_images[$key]);
                
                // Delete file from server
                $fullPath = $path . $remove_filename;
                if (file_exists($fullPath) && !is_dir($fullPath)) {
                    unlink($fullPath);
                }
                $images_updated = true;
            }
        }
        // Re-index array after unsetting
        $existing_images = array_values($existing_images);
    }

    // 3. Process new uploads
    // UPDATED: Check for the 'product' file array
    if (isset($_FILES['product']['name']) && is_array($_FILES['product']['name']) && !empty($_FILES['product']['name'][0])) {
        $total_files = count($_FILES['product']['name']);

        // UPDATED: Loop through each uploaded file
        for ($i = 0; $i < $total_files; $i++) {
            
            // Check for upload errors
            if ($_FILES['product']['error'][$i] === UPLOAD_ERR_OK) {
                
                $tmpFilePath = $_FILES['product']['tmp_name'][$i];
                
                if (!empty($tmpFilePath) && $tmpFilePath != '') {
                    
                    $path_parts = pathinfo($_FILES['product']['name'][$i]);
                    $extension = strtolower($path_parts['extension']);
                    $allowed_extensions = ['png', 'jpg', 'jpeg', 'gif']; // Define allowed extensions

                    if (in_array($extension, $allowed_extensions)) {
                        
                        // UPDATED: Create a unique filename to prevent overwrites
                        $filename = 'product_' . $product_id . '_' . uniqid() . '.' . $extension;
                        $newFilePath = $path . $filename;

                        if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                            // UPDATED: Add new filename to our array
                            $existing_images[] = $filename;
                            $images_updated = true;
                        }
                    }
                }
            }
        }
    }

    // 4. Save the final array to the database
    if ($images_updated) {
        // UPDATED: Only update if there was a change (new upload or deletion)
        // Encode the final array as JSON
        $new_image_data = json_encode($existing_images);
        
        // Use edit_product to save the new JSON string
        $CI->products_model->edit_product(['product_image' => $new_image_data], $product_id);
        return true;
    }

    return false;
}
/*function handle_product_upload($product_id)
{
    $CI = &get_instance();
    if (isset($_FILES['product']['name']) && '' != $_FILES['product']['name']) {
        $path        = get_upload_path_by_type('products');
        $tmpFilePath = $_FILES['product']['tmp_name'];
        if (!empty($tmpFilePath) && '' != $tmpFilePath) {
            $path_parts  = pathinfo($_FILES['product']['name']);
            $extension   = $path_parts['extension'];
            $extension   = strtolower($extension);
            $filename    = 'product_'.$product_id.'.'.$extension;
            $newFilePath = $path.$filename;
            _maybe_create_upload_path($path);
            if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                $CI->products_model->edit_product(['product_image' => $filename], $product_id);

                return true;
            }
        }
    }

    return false;
}*/

function get_coupon_used_times($coupon_id)
{
    $CI = &get_instance();

    $coupon_used_times = $CI->coupons_model->get_used_times($coupon_id);
    return $coupon_used_times;
}

function get_product_variations($product_id)
{
    $CI = &get_instance();

    $product_variations = $CI->products_model->get_by_id_variations($product_id);

    $variations = '';
    foreach ($product_variations as $product_variation)
    {
        $variations .= '<span class="label label-danger">' . $product_variation->variation_name . '</span>';
    }

    return $variations;
}

function get_product_variation_price($product_id)
{
    $CI = &get_instance();

    $base_currency = $CI->currencies_model->get_base_currency();
    $product_variations = $CI->products_model->get_by_id_variations($product_id);
    $min_price = 0; $max_price = 0;
    foreach ($product_variations as $product_variation)
    {
        if (!$min_price) $min_price = $product_variation->rate;
        if (!$max_price) $max_price = $product_variation->rate;
        if ($min_price > $product_variation->rate) $min_price = $product_variation->rate;
        if ($max_price < $product_variation->rate) $max_price = $product_variation->rate;
    }

    $variation_price = app_format_money($min_price, $base_currency->name);
    if ($min_price != $max_price) {
        if ($base_currency->placement == 'before') {
            $variation_price .= ' - ' . str_replace($base_currency->symbol, '', str_replace($base_currency->name, '', app_format_money($max_price, $base_currency->name)));
        } else {
            $variation_price = str_replace($base_currency->symbol, '', str_replace($base_currency->name, '', $variation_price));
            $variation_price .= ' - ' . app_format_money($max_price, $base_currency->name);
        }
    }

    return $variation_price;
}

function get_product_variation_values($product_id)
{
    $CI = &get_instance();

    $product_variation_values = $CI->products_model->get_by_id_variation_values($product_id);

    $variation = '';
    $variation_values = '';
    foreach ($product_variation_values as $product_variation_value)
    {
        if ($variation != $product_variation_value->variation_name) {
            $variation = $product_variation_value->variation_name;
            if ($variation_values) {
                $variation_values .= '</div>';
            }
            $variation_values .= '<div>' . $product_variation_value->variation_name . ' - ';
        }
        $variation_values .= '<span class="label label-danger">' . $product_variation_value->variation_value . '</span>';
    }
    $variation_values .= '</div>';

    return $variation_values;
}

function get_variation_values($variation_id)
{
    $CI = &get_instance();

    $variation_values = $CI->variations_model->get_values($variation_id);

    $values = '';
    foreach ($variation_values as $variation_value)
    {
        $values .= '<span class="label label-danger">' . $variation_value['value'] . '</span>';
    }

    return $values;
}

function toPlainArray($arr)
{
    $output = "['";
    foreach ($arr as $val) {
        $output .= $val."', '";
    }
    $plain_array = substr($output, 0, -3).']';

    return $plain_array;
}


// UPDATED: Handle review image uploads (based on handle_product_upload logic)
	function handle_review_uploads($product_id)
    {
        $upload_path = FCPATH . 'modules/products/uploads/reviews/';

        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0755, true);
        }

        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        $uploaded_files = [];

        if (isset($_FILES['reviews']) && isset($_FILES['reviews']['name'])) {
            foreach ($_FILES['reviews']['name'] as $key => $filename) {
                if (!empty($filename) && isset($_FILES['reviews']['tmp_name'][$key])) {
                    $tmp = $_FILES['reviews']['tmp_name'][$key];
                    $error = $_FILES['reviews']['error'][$key];
                    if ($error === UPLOAD_ERR_OK && file_exists($tmp)) {
                        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                        if (in_array($ext, $allowed_extensions)) {
                            $unique_name = 'review_' . $product_id . '_' . uniqid() . '.' . $ext;
                            $dest = $upload_path . $unique_name;
                            if (move_uploaded_file($tmp, $dest)) {
                                $uploaded_files[] = $unique_name;
                            }
                        }
                    }
                }
            }
        }

        return $uploaded_files;
    }
