<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s " id="TableData">
          <div class="panel-body">
            <?php if (has_permission('products', '', 'create')) { ?>
            <a href="<?php echo admin_url('products/add_product'); ?>" class="btn btn-info pull-left display-block">
              <?php echo _l('new_product'); ?>
            </a>
            <?php } ?>
          </div>  
        </div>
        <div class="row">
          <div class="col-md-12" id="panel">
           <div class="panel_s">
              <div class="panel-body">
                <?php
                $table_data = [
                    _l('product_name'),
                    _l('product_image'),
                    _l('product_variations'),
                    _l('product_description'),
                    _l('products_categories'),
                    _l('invoice_item_add_edit_rate_currency'),
                    _l('quantity'),
                    _l('tax'),
                  ];
                  render_datatable($table_data, ($class ?? 'products')); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
  <?php init_tail(); ?>
<!-- <script type="text/javascript">
  $(function(){
    initDataTable('.table-products', window.location.href,'undefined','undefined','');
  });
</script> -->
<div class="modal fade" id="productImagesListModal" tabindex="-1" role="dialog" aria-labelledby="productImagesListModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="productImagesListModalLabel"><?php echo _l('product_images'); ?></h4>
            </div>
            <div class="modal-body">
                <div id="product-images-modal-content" class="row">
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- 🔍 Full Image Zoom Modal -->
<div class="modal fade" id="fullImageModal" tabindex="-1" role="dialog" aria-labelledby="fullImageModalLabel">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" style="background: #000;">
            <div class="modal-body text-center" style="padding: 0;">
                <img id="fullImageView" src="" alt="Full Image" style="max-width:100%; max-height:90vh; object-fit:contain;">
            </div>
            <div class="modal-footer" style="border: none;">
                <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
  $(function(){
    initDataTable('.table-products', window.location.href,'undefined','undefined','');

    var imagesModal = $('#productImagesListModal');
    var imagesContainer = $('#product-images-modal-content');
    var uploadPath = '<?php echo module_dir_url('products', 'uploads'); ?>/';

    // Handle image list modal population
    $('body').on('click', '.view-product-images', function() {
        imagesContainer.html('');
        var images = $(this).data('images');

        if (images && images.length > 0) {
            $.each(images, function(index, imageFile) {
                var imageHtml = `
                    <div class="col-md-3 col-sm-4 col-xs-6 text-center">
                        <img src="${uploadPath + imageFile}" 
                             class="img img-responsive img-thumbnail product-thumb" 
                             style="margin-bottom: 15px; cursor:pointer;"
                             data-full="${uploadPath + imageFile}">
                    </div>`;
                imagesContainer.append(imageHtml);
            });
        } else {
            imagesContainer.html('<p class="text-center">No images found for this product.</p>');
        }
    });

    // 🖼️ Handle click on thumbnail → open full image modal
    $('body').on('click', '.product-thumb', function() {
        var fullImageUrl = $(this).data('full');
        $('#fullImageView').attr('src', fullImageUrl);
        $('#fullImageModal').modal('show');
    });

    // Clear content on close
    imagesModal.on('hidden.bs.modal', function () {
        imagesContainer.html('');
    });
    $('#fullImageModal').on('hidden.bs.modal', function () {
        $('#fullImageView').attr('src', '');
    });
  });
</script>