<?php

defined('BASEPATH') or exit('No direct script access allowed');
$aColumns = [
    'product_name',
    'product_description',
    'p_category_name',
    'rate',
    'quantity_number',
    'product_image',
    'taxes',
];
$sIndexColumn = 'id';
$sTable       = db_prefix().'product_master';
$filter       = [];
$where        = [];
$statusIds    = [];
$join         = [
    'LEFT JOIN '.db_prefix().'product_categories ON '.db_prefix().'product_categories.p_category_id='.db_prefix().'product_master.product_category_id',
];
$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['id','is_digital','is_variation']);
$output  = $result['output'];
$rResult = $result['rResult'];
$CI      = &get_instance();

$CI->load->model(['currencies_model']);
$base_currency = $CI->currencies_model->get_base_currency();
//\modules\products\core\Apiinit::ease_of_mind('products');
//\modules\products\core\Apiinit::the_da_vinci_code('products');

foreach ($rResult as $aRow) {
    $row        = [];
    $outputName = '<a href="#">'.$aRow['product_name'].'</a>';
    $outputName .= '<div class="row-options">';
    if (has_permission('products', '', 'delete')) {
        $outputName .= ' <a href="'.admin_url('products/view/'.$aRow['id']).'" class="_view">'._l('view').'</a>';
        $outputName .= '| <a href="'.admin_url('products/edit/'.$aRow['id']).'" class="_edit">'._l('edit').'</a>';
        $outputName .= '| <a href="'.admin_url('products/delete/'.$aRow['id']).'" class="text-danger _delete">'._l('delete').'</a>';
    }
    $outputName .= '</div>';
    $row[]        = $outputName;

    // UPDATED: START - Logic for handling single/multiple images
    $image_html = '';
    $images = @json_decode($aRow['product_image']);
    $upload_path = module_dir_url('products', 'uploads');
    $placeholder_image = $upload_path . "/image-not-available.png";
    // Define a consistent style for thumbnail images
    $default_image_style = 'style="width: 50px; height: 50px; object-fit: cover;"';

    // Handle legacy single-image strings or bad JSON
    if (json_last_error() !== JSON_ERROR_NONE || !is_array($images)) {
        $images = [$aRow['product_image']]; // Treat it as an array with one item
    }

    // Clean out empty/null values from the array (e.g., [""] or [])
    $images = array_filter($images);
    $image_count = count($images);

    if ($image_count == 0) {
        // Case 1: No images
        $image_html = '<img src="' . $placeholder_image . '" class="img-thumbnail img-responsive zoom" ' . $default_image_style . '>';
    } elseif ($image_count == 1) {
        // Case 2: One image
        $first_image = reset($images); // Get the first (and only) image
        $image_html = '<img src="' . $upload_path . '/' . htmlspecialchars($first_image) . '" class="img-thumbnail img-responsive zoom" ' . $default_image_style . ' onerror="this.src=\'' . $placeholder_image . '\'">';
    } else {
        // Case 3: Multiple images
        // Pass the image array to the button via data attribute
        $images_json = htmlspecialchars(json_encode(array_values($images)), ENT_QUOTES, 'UTF-8');
        
        // Add data-toggle and data-target to trigger the modal
        $image_html = '<button type="button" class="btn btn-primary btn-sm view-product-images" data-toggle="modal" data-target="#productImagesListModal" data-images="' . $images_json . '">';
        // Note: You may need to add 'view_images' to your language file
        $image_html .= _l('view_images', 'View Images') . ' (' . $image_count . ')';
        $image_html .= '</button>';
    }

    $row[] = $image_html;
    // UPDATED: END - Logic for handling single/multiple images

    $row[]        = get_product_variation_values($aRow['id']);
    //$row[]        = $aRow['product_description'];
	$description = strip_tags($aRow['product_description']); // remove HTML tags
	if (strlen($description) > 50) {
		$description = substr($description, 0, 50) . '...';
	}
	$row[] = htmlspecialchars($description);

    $row[]        = $aRow['p_category_name'];
    $row[]        = $aRow['is_variation'] ?  get_product_variation_price($aRow['id']) : app_format_money($aRow['rate'], $base_currency->name);
    $row[]        = ($aRow['is_digital'] == 0) ? $aRow['quantity_number'] : _l('digital_product');
    $row[]        = (!empty($aRow['taxes'])) ? print_taxes($aRow['taxes']) : '';
    $row['DT_RowClass'] = 'has-row-options';
    $output['aaData'][] = $row;
}

function print_taxes($taxes): string
{
    $unserialize_taxes = unserialize($taxes);
    if (is_array($unserialize_taxes) && !empty($unserialize_taxes)) {
        return implode(' ', $unserialize_taxes);
    }
    // UPDATED: Return an empty string if taxes are not valid
    return '';
}

/*defined('BASEPATH') or exit('No direct script access allowed');
$aColumns = [
    'product_name',
    'product_description',
    'p_category_name',
    'rate',
    'quantity_number',
    'product_image',
    'taxes',
];
$sIndexColumn = 'id';
$sTable       = db_prefix().'product_master';
$filter       = [];
$where        = [];
$statusIds    = [];
$join         = [
    'LEFT JOIN '.db_prefix().'product_categories ON '.db_prefix().'product_categories.p_category_id='.db_prefix().'product_master.product_category_id',
];
$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['id','is_digital','is_variation']);
$output  = $result['output'];
$rResult = $result['rResult'];
$CI      = &get_instance();

$CI->load->model(['currencies_model']);
$base_currency = $CI->currencies_model->get_base_currency();
//\modules\products\core\Apiinit::ease_of_mind('products');
//\modules\products\core\Apiinit::the_da_vinci_code('products');

foreach ($rResult as $aRow) {
    $row        = [];
    $outputName = '<a href="#">'.$aRow['product_name'].'</a>';
    $outputName .= '<div class="row-options">';
    if (has_permission('products', '', 'delete')) {
		$outputName .= ' <a href="'.admin_url('products/view/'.$aRow['id']).'" class="_view">'._l('view').'</a>';
        $outputName .= '| <a href="'.admin_url('products/edit/'.$aRow['id']).'" class="_edit">'._l('edit').'</a>';
        $outputName .= '| <a href="'.admin_url('products/delete/'.$aRow['id']).'" class="text-danger _delete">'._l('delete').'</a>';
    }
    $outputName .= '</div>';
    $row[]              = $outputName;
    $row[]              = "<img src='".module_dir_url('products', 'uploads')."/{$aRow['product_image']}' class='img-thumbnail img-responsive zoom' onerror=\"this.src='".module_dir_url('products', 'uploads')."/image-not-available.png'\">";
    $row[]              = get_product_variation_values($aRow['id']);
    $row[]              = $aRow['product_description'];
    $row[]              = $aRow['p_category_name'];
    $row[]              = $aRow['is_variation'] ?  get_product_variation_price($aRow['id']) : app_format_money($aRow['rate'], $base_currency->name);
    $row[]              = ($aRow['is_digital'] == 0) ? $aRow['quantity_number'] : _l('digital_product');
    $row[]              = (!empty($aRow['taxes'])) ? print_taxes($aRow['taxes']) : '';
    $row['DT_RowClass'] = 'has-row-options';
    $output['aaData'][] = $row;
}

function print_taxes($taxes): string
{
    $unserialize_taxes = unserialize($taxes);
    if (is_array($unserialize_taxes) && !empty($unserialize_taxes)) {
        return implode(' ', $unserialize_taxes);
    }
} */
