<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <h4 class="tw-mt-0 tw-font-bold tw-text-lg tw-text-neutral-700">
                    <?php echo _l('view_product'); ?> - <?php echo htmlspecialchars($product->product_name); ?>
                </h4>
                <div class="horizontal-scrollable-tabs">
                    <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                    <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                    <div class="horizontal-tabs">
                        <ul class="nav nav-tabs nav-tabs-segmented nav-tabs-horizontal tw-mb-3" role="tablist">
                            <li role="presentation" class="active">
                                <a href="#tab_product_general" aria-controls="tab_product_general" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-info menu-icon"></i>
                                    <?php echo _l('general_information'); ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#tab_product_widget" aria-controls="tab_product_widget" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-code menu-icon"></i>
                                    <?php echo _l('product_single_widget'); ?> <!-- Add lang key: product_single_widget = "Single Product Widget" -->
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#tab_product_grid" aria-controls="tab_product_grid" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-th menu-icon"></i>
                                    <?php echo _l('product_grid_widget'); ?> <!-- Add lang key: product_grid_widget = "Products Grid Widget" -->
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="tab-content">
                            <!-- General Tab: Product Details -->
                            <div role="tabpanel" class="tab-pane active" id="tab_product_general">
                                <div class="row">
                                    <!-- Left Column: Basic Info -->
                                    <div class="col-md-6">
                                        <div class="card mb-4">
                                            <div class="card-header bg-primary text-white">
                                                <h5 class="card-title mb-0 font-weight-bold">
                                                    <i class="fa fa-info-circle"></i> <?php echo _l('basic_information'); ?>
                                                </h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('product_name'); ?></label>
                                                    <p class="form-control-static font-weight-bold text-primary fs-5"><?php echo htmlspecialchars($product->product_name); ?></p>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('product_short_description'); ?></label>
                                                    <p class="form-control-static text-muted"><?php echo htmlspecialchars($product->product_short_description); ?></p>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('product_description'); ?></label>
                                                    <div id="description-container">
                                                        <?php
                                                        $full_description = html_entity_decode($product->product_description);
                                                        $truncated_description = strlen($full_description) > 50 ? substr($full_description, 0, 50) . '...' : $full_description;
                                                        $escaped_full = addslashes($full_description);
                                                        $escaped_truncated = addslashes($truncated_description);
                                                        ?>
                                                        <p id="description-text" class="text-muted mb-0 <?php echo strlen($full_description) > 50 ? 'truncated' : ''; ?>">
                                                            <?php echo $truncated_description; ?>
                                                        </p>
                                                        <?php if (strlen($full_description) > 50): ?>
                                                            <button type="button" class="btn btn-link p-0 mt-1 show-more-btn" data-full="<?php echo htmlspecialchars($full_description, ENT_QUOTES, 'UTF-8'); ?>">
                                                                <i class="fa fa-chevron-down"></i> <?php echo _l('show_more'); ?>
                                                            </button>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('products_categories'); ?></label>
                                                    <p class="form-control-static">
                                                        <span class="badge badge-primary"><?php echo htmlspecialchars($product->p_category_name ?? 'N/A'); ?></span>
                                                    </p>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('invoice_item_add_edit_rate_currency'); ?></label>
                                                    <p class="form-control-static font-weight-bold text-success fs-5"><?php echo app_format_money($product->rate, $base_currency->name); ?></p>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('quantity'); ?></label>
                                                    <p class="form-control-static">
                                                        <span class="badge badge-info"><?php echo ($product->is_digital == 1) ? _l('digital_product') : $product->quantity_number; ?></span>
                                                    </p>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('tax'); ?></label>
                                                    <p class="form-control-static"><?php echo (!empty($product->taxes)) ? print_taxes($product->taxes) : '<span class="text-muted">N/A</span>'; ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Right Column: Media & Additional Info -->
                                    <div class="col-md-6">
                                        <div class="card mb-4">
                                            <div class="card-header bg-primary text-white">
                                                <h5 class="card-title mb-0 font-weight-bold">
                                                    <i class="fa fa-image"></i> <?php echo _l('media_and_variations'); ?>
                                                </h5>
                                            </div>
                                            <div class="card-body">
                                                <?php
                                                // Fetch multiple images: Decode JSON from $product->product_image, fallback to single string
                                                $images = [];
                                                if (!empty($product->product_image)) {
                                                    $decoded = @json_decode($product->product_image);
                                                    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                                                        $images = array_filter($decoded); // Remove any nulls
                                                    } else {
                                                        // Legacy single image
                                                        $images = [$product->product_image];
                                                    }
                                                }
                                                ?>
                                                <?php if (!empty($images)): ?>
                                                    <div class="form-group">
                                                        <label class="form-label font-weight-semibold"><?php echo _l('product_image'); ?></label>
                                                        <div class="row">
                                                            <?php foreach ($images as $image): ?>
                                                                <div class="col-md-6 col-sm-6 col-xs-12 mb-3">
                                                                    <div class="position-relative">
                                                                        <img src="<?php echo base_url('modules/products/uploads/' . $image); ?>" class="img-fluid rounded shadow-sm" style="width: 100%; height: 150px; object-fit: cover;">
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="form-group">
                                                        <label class="form-label font-weight-semibold"><?php echo _l('product_image'); ?></label>
                                                        <p class="form-control-static text-muted"><i class="fa fa-image"></i> <?php echo _l('no_images_uploaded'); ?></p>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('product_variations'); ?></label>
                                                    <p class="form-control-static text-muted"><?php echo get_product_variation_values($product->id); ?></p>
                                                </div>
                                                <div class="form-group">
                                                    <label class="form-label font-weight-semibold"><?php echo _l('product_recurring'); ?></label>
                                                    <span class="badge badge-<?php echo $product->recurring ? 'success' : 'secondary'; ?> fs-6">
                                                        <?php echo $product->recurring ? _l('yes') : _l('no'); ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Product Reviews Section -->
                                        <div class="card">
                                            <div class="card-header bg-warning text-dark">
                                                <h5 class="card-title mb-0 font-weight-bold">
                                                    <i class="fa fa-star"></i> <?php echo _l('product_reviews'); ?>
                                                </h5>
                                            </div>
                                            <div class="card-body">
                                                <?php
												// ✅ UPDATED: Reviews section enhanced to show customer image + name + star + review text
												if (!empty($product->reviews)) {
													$decoded_reviews = json_decode($product->reviews, true);
													if (json_last_error() === JSON_ERROR_NONE && is_array($decoded_reviews) && count($decoded_reviews) > 0) {
														echo '<div class="reviews-container" style="max-height:300px; overflow-y:auto;">';
														foreach ($decoded_reviews as $r_index => $review) {
															$stars = (int)($review['review_star'] ?? 0);
															$stars_html = str_repeat('<i class="fa fa-star text-warning"></i>', $stars);
															$stars_html .= str_repeat('<i class="fa fa-star-o text-muted"></i>', 5 - $stars);

															$customer_name = htmlspecialchars($review['customer_name'] ?? 'Anonymous');
															$customer_image = !empty($review['customer_image']) 
																? base_url('modules/products/uploads/reviews/' . $review['customer_image'])
																: base_url('assets/images/default_avatar.png'); // ✅ Default fallback image

															echo '<div class="review-item mb-3 p-3 bg-light rounded shadow-sm">';
															echo '  <div class="d-flex align-items-start">';
															echo '    <div class="review-avatar me-3">';
															echo '      <img src="' . $customer_image . '" alt="' . $customer_name . '" class="rounded-circle border" style="width:60px; height:60px; object-fit:cover;">';
															echo '    </div>';
															echo '    <div class="review-content flex-grow-1">';
															echo '      <div class="d-flex justify-content-between align-items-center mb-1">';
															echo '        <span class="font-weight-bold text-dark">' . $customer_name . '</span>';
															echo '        <div>' . $stars_html . '</div>';
															echo '      </div>';
															echo '      <p class="text-muted mb-0">' . nl2br(htmlspecialchars($review['review_details'] ?? '')) . '</p>';
															echo '    </div>';
															echo '  </div>';
															echo '</div>';
														}
														echo '</div>';
													} else {
														echo '<p class="text-muted text-center py-3"><i class="fa fa-comment-o"></i> ' . _l('no_reviews_found') . '</p>';
													}
												} else {
													echo '<p class="text-muted text-center py-3"><i class="fa fa-comment-o"></i> ' . _l('no_reviews_found') . '</p>';
												}

                                                /*if (!empty($product->reviews)) {
                                                    $decoded_reviews = json_decode($product->reviews, true);
                                                    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded_reviews) && count($decoded_reviews) > 0) {
                                                        echo '<div class="reviews-container" style="max-height:300px; overflow-y:auto;">';
                                                        foreach ($decoded_reviews as $r_index => $review) {
                                                            $stars = (int)($review['review_star'] ?? 0);
                                                            $stars_html = str_repeat('<i class="fa fa-star text-warning"></i>', $stars);
                                                            $stars_html .= str_repeat('<i class="fa fa-star-o text-muted"></i>', 5 - $stars);
                                                            echo '<div class="review-item mb-3 p-3 bg-light rounded">';
                                                            echo '<div class="d-flex justify-content-between align-items-center mb-2">';
                                                            echo '<span class="font-weight-bold">Review #' . ($r_index + 1) . '</span>';
                                                            echo '<div>' . $stars_html . '</div>';
                                                            echo '</div>';
                                                            echo '<p class="text-muted mb-0">' . nl2br(htmlspecialchars($review['review_details'] ?? '')) . '</p>';
                                                            echo '</div>';
                                                        }
                                                        echo '</div>';
                                                    } else {
                                                        echo '<p class="text-muted text-center py-3"><i class="fa fa-comment-o"></i> ' . _l('no_reviews_found') . '</p>';
                                                    }
                                                } else {
                                                    echo '<p class="text-muted text-center py-3"><i class="fa fa-comment-o"></i> ' . _l('no_reviews_found') . '</p>';
                                                }*/
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-right mt-4">
                                    <a href="<?php echo admin_url('products'); ?>" class="btn btn-secondary mr-2"><?php echo _l('back_to_list'); ?></a>
                                    <a href="<?php echo admin_url('products/edit/' . $product->id); ?>" class="btn btn-primary"><?php echo _l('edit'); ?></a>
                                </div>
                            </div>
                            <!-- Single Product Widget Tab -->
                            <div role="tabpanel" class="tab-pane" id="tab_product_widget">
                                <p><?php echo _l('product_widget_embed_help'); ?> <!-- Add lang key: product_widget_embed_help = "Embed this single product widget anywhere on your site or external projects." --></p>
                                <textarea class="form-control" rows="3" readonly><iframe width="400" height="600" src="<?php echo site_url('products/widget_single/' . $product->id); ?>" frameborder="0" sandbox="allow-top-navigation allow-forms allow-scripts allow-same-origin allow-popups" allowfullscreen></iframe></textarea>
                                <h4 class="tw-my-5 bold"><?php echo _l('share_direct_link'); ?></h4>
                                <p>
                                    <span class="label label-default">
                                        <a href="<?php echo site_url('products/widget_single/' . $product->id . '?styled=1'); ?>" target="_blank"  style="color: white">
                                            <?php echo site_url('products/widget_single/' . $product->id . '?styled=1'); ?>
                                        </a>
                                    </span>
                                    <br /><br />
                                    <span class="label label-default">
                                        <a href="<?php echo site_url('products/widget_single/' . $product->id . '?styled=1&with_logo=1'); ?>" target="_blank"  style="color: white">
                                            <?php echo site_url('products/widget_single/' . $product->id . '?styled=1&with_logo=1'); ?>
                                        </a>
                                    </span>
                                </p>
                                <hr />
                                <p class="bold mtop15"><?php echo _l('iframe_protocol_note'); ?> <!-- Add lang key --></p>
                                <p class="<?php echo strpos(site_url(), 'http://') !== false ? 'bold text-success' : ''; ?>">
                                    1. If the protocol of your installation is http use a http page inside the iframe.
                                </p>
                                <p class="<?php echo strpos(site_url(), 'https://') !== false ? 'bold text-success' : ''; ?>">
                                    2. If the protocol of your installation is https use a https page inside the iframe.
                                </p>
                                <p>None SSL installation will need to place the link in non ssl eq. landing page and backwards.</p>
                            </div>
                            <!-- Grid Widget Tab -->
                            <div role="tabpanel" class="tab-pane" id="tab_product_grid">
                                <p><?php echo _l('product_grid_widget_help'); ?> <!-- Add lang key: "Embed a grid of products (e.g., by category) anywhere." --></p>
                                <div class="form-group">
                                    <label for="grid_category_select"><?php echo _l('select_category_for_grid'); ?></label> <!-- Add lang key -->
                                    <select id="grid_category_select" class="form-control" multiple>
                                        <option value=""><?php echo _l('all_products'); ?></option>
                                        <?php foreach ($categories as $cat): ?>
                                            <option value="<?php echo $cat['p_category_id']; ?>">
                                                <?php echo htmlspecialchars($cat['p_category_name']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <textarea class="form-control" rows="3" id="grid_iframe_code" readonly><iframe width="800" height="600" src="<?php echo site_url('products/widget_grid'); ?>" frameborder="0" sandbox="allow-top-navigation allow-forms allow-scripts allow-same-origin allow-popups" allowfullscreen></iframe></textarea>
                                <h4 class="tw-my-5 bold"><?php echo _l('share_direct_link'); ?></h4>
                                <p id="grid_links">
                                    <!-- JS will populate -->
                                </p>
                                <!-- Reuse protocol notes from above tab -->
                                <hr />
                                <p class="bold mtop15"><?php echo _l('iframe_protocol_note'); ?></p>
                                <!-- ... same as above ... -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(function() {
    // Handle description show more/less toggle
    $('.show-more-btn').on('click', function() {
        var $btn = $(this);
        var $text = $('#description-text');
        var fullText = $btn.data('full');
        var isTruncated = $text.hasClass('truncated');
        
        if (isTruncated) {
            $text.html(fullText).removeClass('truncated');
            $btn.html('<i class="fa fa-chevron-up"></i> <?php echo addslashes(_l('show_less')); ?>');
        } else {
            var truncatedText = '<?php echo addslashes($truncated_description); ?>';
            $text.html(truncatedText).addClass('truncated');
            $btn.html('<i class="fa fa-chevron-down"></i> <?php echo addslashes(_l('show_more')); ?>');
        }
    });

    // Handle grid category change for dynamic iframe code
    $('#grid_category_select').on('change', function() {
        var selected = $(this).val(); // Could be single value or array
        var baseUrl = '<?php echo site_url('products/widget_grid'); ?>';
        var iframeSrc = baseUrl;
        if (selected && selected.length > 0) {
            if (Array.isArray(selected)) {
                iframeSrc += '?category_id[]=' + selected.join('&category_id[]=');
            } else {
                iframeSrc += '?category_id=' + selected;
            }
        }
        $('#grid_iframe_code').val('<iframe width="800" height="600" src="' + iframeSrc + '" frameborder="0" sandbox="allow-top-navigation allow-forms allow-scripts allow-same-origin allow-popups" allowfullscreen></iframe>');
        var styledUrl = iframeSrc + (iframeSrc.includes('?') ? '&' : '?') + 'styled=1';
        var styledLogoUrl = styledUrl + '&with_logo=1';
        $('#grid_links').html(
            '<span class="label label-default"><a href="' + styledUrl + '" target="_blank"  style="color: white">' + styledUrl + '</a></span><br /><br />' +
            '<span class="label label-default"><a href="' + styledLogoUrl + '" target="_blank"  style="color: white">' + styledLogoUrl + '</a></span>'
        );
    }).trigger('change');
});
</script>
<style>
.card {
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
}
.card-header {
    padding: 0.75rem 1.25rem;
    border-bottom: 1px solid rgba(0, 0, 0, 0.125);
}
.card-header.bg-primary {
    background-color: #007bff !important;
    color: #fff !important;
}
.card-header.bg-warning {
    background-color: #ffc107 !important;
    color: #212529 !important;
}
.card-title {
    font-size: 1.1rem;
    font-weight: 600;
    margin: 0;
}
.card-body{
    padding-left: 20px;
    padding-top: 10px;
}
.form-label {
    font-weight: 600;
    color: #495057;
    font-size: 0.95rem;
}
.font-weight-semibold {
    font-weight: 600;
}
.fs-5 {
    font-size: 1.25rem;
}
.fs-6 {
    font-size: 0.875rem;
}
.reviews-container {
    border: 1px solid #dee2e6;
    border-radius: 0.25rem;
}
.review-item {
    border-left: 4px solid #007bff;
}
.show-more-btn {
    font-size: 0.875rem;
    color: #007bff;
}
.show-more-btn:hover {
    text-decoration: none;
    color: #0056b3;
}
.badge {
    font-size: 0.8rem;
    padding: 0.5em 0.75em;
}
</style>
<?php
// Define print_taxes if not global
if (!function_exists('print_taxes')) {
    function print_taxes($taxes): string
    {
        $unserialize_taxes = unserialize($taxes);
        if (is_array($unserialize_taxes) && !empty($unserialize_taxes)) {
            return implode(' ', $unserialize_taxes);
        }
        return '';
    }
}
?>