//------------------------------------------------------
//  MILESTONES JS with Attachment + Preview Support
//------------------------------------------------------

function new_milestone() {
    $("#milestone").modal("show");
    $("#milestone .edit-title").addClass("hide");

    $("#additional_milestone").html("");
    $("#milestone_attachments").html("");
    $("#new_file_preview").html("");

    $('#milestone input[name="file[]"]').val("");
    $("#milestone_files").val("");
    $('.btn-file :file').parents('.input-group').find(':text').val("");
}

function edit_milestone(invoker, id) {
    var description_visible_to_customer = $(invoker).data("description-visible-to-customer"),
        hide_from_customer = $(invoker).data("hide-from-customer");

    $('input[name="description_visible_to_customer"]').prop("checked", description_visible_to_customer == 1);
    $('input[name="hide_from_customer"]').prop("checked", hide_from_customer == 1);

    // Using .html() instead of .append() prevents duplicate hidden IDs on multiple edits
    $("#additional_milestone").html(hidden_input("id", id));

    $('#milestone input[name="name"]').val($(invoker).data("name"));
    $('#milestone input[name="start_date"]').val($(invoker).data("start_date"));
    $('#milestone input[name="due_date"]').val($(invoker).data("due_date"));
    $('#milestone input[name="milestone_order"]').val($(invoker).data("order"));
    $('#milestone textarea[name="description"]').val($(invoker).data("description"));

    // Custom Fields Population
    $('input[name="target_geo"]').val($(invoker).data('geo'));
    $('textarea[name="target_urls"]').val($(invoker).data('urls'));
    $('textarea[name="keyword_list"]').val($(invoker).data('keyword'));
    $('textarea[name="notes_goals"]').val($(invoker).data('notes'));

    // Clear previous new file selections & preview
    $("#milestone_files").val("");
    $('#milestone input[name="file[]"]').val("");
    $('.btn-file :file').parents('.input-group').find(':text').val("");
    $("#new_file_preview").html("");

    // Load Existing Attachments via AJAX
    $('#milestone_attachments').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading files...</div>');
    $.get(admin_url + 'restoration/projects/get_milestone_attachments/' + id, function(response) {
        $('#milestone_attachments').html(response);
    });

    $("#milestone").modal("show");
    $("#milestone .add-title").addClass("hide");
}

function delete_milestone_attachment(id) {
    if (confirm('Are you sure you want to delete this file?')) {
        $.get(admin_url + 'restoration/projects/delete_milestone_attachment/' + id, function(response) {
            if (response.success == true) {
                $('.attachment-wrapper-' + id).fadeOut(function() { $(this).remove(); });
            } else {
                alert('Failed to delete file');
            }
        }, 'json');
    }
}

// Custom handler for form submission with Files using FormData
function milestone_form_handler(form) {
    // Disable submit button to prevent double click
    $(form).find('button[type="submit"]').prop('disabled', true);

    var formData = new FormData($(form)[0]);
    var action = form.action;

    $.ajax({
        url: action,
        type: 'POST',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function (response) {
			
            if (typeof response === "string") {
				try {
					response = JSON.parse(response);
				} catch (e) {
					console.error("JSON Parse Error:", e, response);
					alert_float("danger", "Invalid JSON Response");
					return;
				}
			}
            if (response.success === true || response.success == 'true') {
                alert_float("success", response.message);
                setTimeout(function(){
                    window.location.reload();
                }, 1000);
            } else {
                alert_float("danger", response.message);
                $(form).find('button[type="submit"]').prop('disabled', false);
            }
        },
        error: function() {
            alert_float("danger", "Server Error");
            $(form).find('button[type="submit"]').prop('disabled', false);
        }
    });
    return false;
}

function milestones_kanban_update(ui, object) {
    if (object === ui.item.parent()[0]) {
        let data = {};
        data.order = [];
        data.milestone_id = $(ui.item.parent()[0])
            .parents(".milestone-column")
            .data("col-status-id");

        data.task_id = $(ui.item).data("task-id");

        var tasks = $(ui.item.parent()[0])
            .parents(".milestone-column")
            .find(".task");

        var i = 0;
        $.each(tasks, function () {
            data.order.push([$(this).data("task-id"), i]);
            i++;
        });

        check_kanban_empty_col("[data-task-id]");

        setTimeout(function () {
            $.post(admin_url + "projects/update_task_milestone", data);
        }, 50);
    }
}

function milestones_kanban() {
    init_kanban(
        "restoration/projects/milestones_kanban",
        milestones_kanban_update,
        ".project-milestone",
        400,
        360,
        after_milestones_kanban
    );
}

function after_milestones_kanban() {
    $("#kan-ban").sortable({
        helper: "clone",
        item: ".kan-ban-col",
        cancel: ".milestone-not-sortable",
        update: function (event, ui) {
            var uncategorized_is_after = $(ui.item)
                .next('ul.kan-ban-col[data-col-status-id="0"]');

            if (uncategorized_is_after.length) {
                $(this).sortable("cancel");
                return false;
            }

            var data = {};
            data.order = [];

            var status = $(".kan-ban-col");
            var i = 0;

            $.each(status, function () {
                data.order.push([$(this).data("col-status-id"), i]);
                i++;
            });

            $.post(admin_url + "projects/update_milestones_order", data);
        }
    });

    for (let i = -10; i < $(".task-phase").not(".color-not-auto-adjusted").length / 2; i++) {
        let r = 120, g = 169, b = 56;
        $(".task-phase:eq(" + (i + 10) + ")")
            .not(".color-not-auto-adjusted")
            .css("background", color(r - i * 13, g - i * 13, b - i * 13))
            .css("border", "1px solid " + color(r - i * 12, g - i * 12, b - i * 12));
    }
}

function _maybe_remove_task_from_project_milestone(task_id) {
    var $milestonesTasksWrappers = $(".milestone-column");
    if ($("body").hasClass("project") && $milestonesTasksWrappers.length > 0) {
        if ($("#exclude_completed_tasks").prop("checked") == true) {
            $milestonesTasksWrappers.find('[data-task-id="' + task_id + '"]').remove();
        }
    }
}

function milestones_switch_view() {
    $("#milestones-table").toggleClass("hide");
    $(".project-milestones-kanban").toggleClass("hide");

    if (!$.fn.DataTable.isDataTable(".table-milestones")) {
        // Assuming project_id is available in the hidden input on the page
        var pid = $('input[name="project_id"]').val();
        initDataTable(
            ".table-milestones",
            admin_url + "restoration/projects/milestones/" + pid
        );
    }
}

// Helper to guess icon based on extension
function getFileIcon(filename) {
    let ext = filename.split('.').pop().toLowerCase();
    switch (ext) {
        case "pdf": return "fa fa-file-pdf-o text-danger";
        case "csv": return "fa fa-file-excel-o text-success";
        case "xls":
        case "xlsx": return "fa fa-file-excel-o text-success";
        case "doc":
        case "docx": return "fa fa-file-word-o text-primary";
        case "zip":
        case "rar": return "fa fa-file-archive-o text-warning";
        default: return "fa fa-file-o";
    }
}

$(function () {
    // 1. File Input Visual Logic (existing)
    $(document).on('change', '.btn-file :file', function() {
        var input = $(this),
            numFiles = input.get(0).files ? input.get(0).files.length : 1,
            label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
        input.trigger('fileselect', [numFiles, label]);
    });

    $('.btn-file :file').on('fileselect', function(event, numFiles, label) {
        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;
        if (input.length) {
            input.val(log);
        }
    });

    // 2. New: Preview newly selected files (create + edit)
    $(document).on("change", "#milestone_files", function () {
        let previewBox = $("#new_file_preview");
        previewBox.html(""); // Clear old previews

        let files = this.files;

        if (!files.length) {
            previewBox.html("<p class='text-muted'>No files selected.</p>");
            return;
        }

        $.each(files, function (i, file) {
            let fileType = file.type.toLowerCase();
            let fileName = file.name;
            let item = $("<div class='mbottom10'></div>");

            if (fileType.includes("image")) {
                let reader = new FileReader();
                reader.onload = function (e) {
                    item.html(
                        '<div class="row">' +
                            '<div class="col-md-2">' +
                                '<img src="' + e.target.result + '" class="img-responsive img-thumbnail" style="max-height:80px;">' +
                            '</div>' +
                            '<div class="col-md-10">' +
                                '<strong>' + fileName + '</strong>' +
                                '<p class="text-muted small">' + fileType + '</p>' +
                            '</div>' +
                        '</div><hr>'
                    );
                    previewBox.append(item);
                };
                reader.readAsDataURL(file);
            } else {
                item.html(
                    '<div class="row">' +
                        '<div class="col-md-1">' +
                            '<i class="' + getFileIcon(fileName) + ' fa-2x"></i>' +
                        '</div>' +
                        '<div class="col-md-11">' +
                            '<strong>' + fileName + '</strong>' +
                            '<p class="text-muted small">' + fileType + '</p>' +
                        '</div>' +
                    '</div><hr>'
                );
                previewBox.append(item);
            }
        });
    });

    $("body").on("shown.bs.modal", "#milestone", function () {
        $("#milestone").find('input[name="name"]').focus();
    });

    $("#milestone").on("hidden.bs.modal", function () {
        $("#additional_milestone").html("");
        $('#milestone input[name="due_date"]').val("");
        $('#milestone input[name="name"]').val("");

        // Reset order logic
        var currentRows = $(".table-milestones tbody tr").length;
        $('#milestone input[name="milestone_order"]').val(currentRows + 1);

        $('#milestone textarea[name="description"]').val("");

        // Reset Custom Fields
        $('input[name="target_geo"]').val('');
        $('textarea[name="target_urls"]').val('');
        $('textarea[name="keyword_list"]').val('');
        $('textarea[name="notes_goals"]').val('');

        // Reset Files
        $("#milestone_files").val("");
        $('#milestone input[name="file[]"]').val("");
        $('.btn-file :file').parents('.input-group').find(':text').val("");
        $('#milestone_attachments').html("");
        $('#new_file_preview').html("");

        $('#milestone input[name="description_visible_to_customer"]').prop("checked", false);
        $('#milestone input[name="hide_from_customer"]').prop("checked", false);

        $("#milestone .add-title").removeClass("hide");
        $("#milestone .edit-title").removeClass("hide");
    });

    // 3. Validate Form with CUSTOM SUBMIT HANDLER for Files
    appValidateForm(
        $("#milestone_form"),
        {
            name: "required",
            start_date: "required",
            due_date: "required",
        },
        milestone_form_handler // Pass our custom function here
    );

    var milestone_form = $("#milestone_form");
    var milestone_start_date = milestone_form.find("#start_date");

    milestone_start_date.on("changed.bs.select", function () {
        milestone_form
            .find("#due_date")
            .data("data-date-min-date", milestone_start_date.val());
    });

    // Color picker logic
    $("body").on("click", ".milestone-column .cpicker, .milestone-column .reset_milestone_color", function (e) {
        e.preventDefault();
        var color = $(this).data("color");
        var invoker = $(this);
        var milestone_id = invoker.parents(".milestone-column").data("col-status-id");

        $.post(admin_url + "projects/change_milestone_color", {
            color: color,
            milestone_id: milestone_id,
        }).done(function () {
            if (color == "") {
                window.location.reload();
            } else {
                var $parent = invoker.parents(".milestone-column");
                $parent.find(".reset_milestone_color").removeClass("hide");
                $parent.find(".panel-heading").addClass("color-white").removeClass("task-phase");
                $parent.find(".edit-milestone-phase").addClass("color-white");
            }
        });
    });

    milestones_kanban();
});


function viewMilestoneAttachments(id) {

    $("#milestoneAttachmentModal").modal("show");

    $("#milestoneAttachmentContent").html(
        '<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</div>'
    );

    $.get(admin_url + "restoration/projects/get_milestone_attachments/" + id, function(response) {

        if ($.trim(response) === "") {
            $("#milestoneAttachmentContent").html("<p class='text-muted'>No attachments found.</p>");
        } else {
            $("#milestoneAttachmentContent").html(response);

            // Make links open in new tab
            $("#milestoneAttachmentContent a").attr("target", "_blank");
        }

    });
}
