<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Template extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('restoration/template_model');
        $this->load->model('restoration/template_table_model');
        $this->load->model('restoration/category_model');
		$this->load->model('restoration/sub_category_model');
    }

    public function index()
    {

        if ($this->input->is_ajax_request()) {

            $select = [
                RESTORATION_TABLE_TEMPLATE.'.title as title',
                RESTORATION_TABLE_CATEGORY.'.title as category',
				RESTORATION_TABLE_SUB_CATEGORY.'.title as sub_category',
            ];
            
            $where = [];
            // $where[] = 'AND item_type = "' . $itemType . '" ';
            // if($this->input->post('item_title')){
            //     $where[] = 'AND item_title LIKE "%' . $this->input->post('item_title') . '%" ';    
            // }

            $aColumns = $select;
            $aAdditionalSelect = [RESTORATION_TABLE_TEMPLATE.'.id' , RESTORATION_TABLE_TEMPLATE.'.created_at' ];
            $sIndexColumn = 'id';
            $sTable = RESTORATION_TABLE_TEMPLATE;
            $join = [];
            $join[] = 'LEFT JOIN '.RESTORATION_TABLE_CATEGORY.' ON '.RESTORATION_TABLE_CATEGORY.'.id='.RESTORATION_TABLE_TEMPLATE.'.category';
			$join[] = 'LEFT JOIN '.RESTORATION_TABLE_SUB_CATEGORY.' ON '.RESTORATION_TABLE_SUB_CATEGORY.'.id='.RESTORATION_TABLE_TEMPLATE.'.sub_category';
			$order_by = 'ORDER BY ' . RESTORATION_TABLE_TEMPLATE . '.id DESC';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $aAdditionalSelect,$order_by);

            //print_r($result);die;

            $output = $result['output'];
            $rResult = $result['rResult'];
				
            foreach ($rResult as $aRow) {
                $row = [];
                $rowOption = [];
                $rowOption[] = '<a href="'.admin_url('restoration/template/add_edit/'.$aRow['id']).'" >' . _l('restoration_edit') . '</a>';
                $rowOption[] = '<a href="'.admin_url('restoration/template/builder/'.$aRow['id']).'"  class="text-success">' . _l('restoration_builder') . '</a>';
                $rowOption[] = '<a href="'.admin_url('restoration/template/view/'.$aRow['id']).'"  class="text-success">' . _l('View') . '</a>';
                $rowOption[] = '<a href="!#" onclick="delete_task(\'' . $aRow['id'] . '\'); return false;" class="text-danger">' . _l('restoration_delete') . '</a>';

                $row[] = $aRow['title'];
                $row[] = $aRow['category'];
				$row[] = $aRow['sub_category'];
				$row[] = date('d-m-Y H:i:s', strtotime($aRow['created_at']));
                $row[] = implode(' | ', $rowOption);
                $output['aaData'][] = $row;
            }
		
            echo json_encode($output);
            die();
        }


        $data = [];
        $data['title'] = _l('restoration_task');
        $data['icon'] = 'fa-users';
        
        $this->load->view('restoration/template/index', $data);
    }

    public function add_edit(int $id = 0): void
    {
       $id = (int)$id;

        if ($this->input->post()) {

            $data = $this->input->post();
            try {
                $success = true;
              
				$data['assigned'] = isset($template->assignees) ? json_decode($template->assignees) : [];
				$data['followers_selected'] = isset($template->followers) ? $template->followers : '';

				$template_data = [
					'title'       => $data['title'],
					'category'    => $data['category'],
					'sub_category' => $data['sub_category'],
				//	'assignees'   => $assignees,
				//	'followers'   => $follower,
				//	'start_date'  => to_sql_date($data['start_date']),
				//	'due_date'    => to_sql_date($data['due_date']),
				];
				//$data['assigned'] = [];
				//$data['followers_selected'] = '';

				if ($id) {
					//$data['template'] = $this->template_model->get($id);

					//if (!empty($data['template']->assignees)) {
					//	$data['assigned'] = json_decode($data['template']->assignees, true);
					//}

					//$data['followers_selected'] = $data['template']->followers ?? '';

					$this->template_model->update($id, $template_data);
					$template_id = $id;
					$message = _l('restoration_task') . _l('restoration_updated_successfully');
				} else {
					$template_id = $this->template_model->add($template_data);
					$message = _l('restoration_task') . _l('restoration_added_successfully');
				}

                if($data['field_label']){
                    foreach ($data['field_label'] as $key => $value) {
													
                        $template_table_arr = array(
                            "template_id" => $template_id,
                            "field_label" => $value,
                            "field_type" => $data['field_type'][$key],
                            "table_column" => ($data['field_type'][$key]=='table')?$data['table_column'][$key]:NULL,
                            "table_row" => ($data['field_type'][$key]=='table')?$data['table_row'][$key]:NULL,
                            "column_data" => ($data['field_type'][$key]=='table')?json_encode($data['column_data'][$key]):NULL,
                            'is_visible_label' => $data['is_visible_label'][$key] ?? 0,
                        );
			
                        if(!empty($data['table_id'][$key])){
                            $this->template_table_model->update($data['table_id'][$key], $template_table_arr);
                        }else{
                            $this->template_table_model->add($template_table_arr);
                        }
                    }
			
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }

            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);

            die;
        }

        $data = [];
		$sub_categories = [];
		
        if ($id > 0) {
            $data['template'] = $this->template_model->get($id);
			
			if($data['template']->category) {
                 $this->db->where('restoration_category_id', $data['template']->category);
                 $sub_categories = $this->sub_category_model->get_for_dropdown(); 
            }
			
            $template_table = $this->template_table_model->all(["template_id" => $id]);

            foreach ($template_table as $key => $value) {
                $template_table[$key]["column_data"] = !is_null($value["column_data"])?json_decode($value["column_data"], true):[];
            }
            $data['template_table'] = $template_table;
            $title = _l('edit') . ' ' . $data['template']->title;
        } else {
            $title = _l('add_new');
        }

        $data['id'] = $id;
        $data['category'] = $this->category_model->all();
		$data['sub_category'] = $sub_categories;
		$data['staff']   = $this->staff_model->get('', ['active' => 1]);
        $data['title'] = _l('restoration_task');
        $data['icon'] = 'fa-pencil';
        $this->load->view('template/add_edit', $data);
    }

	public function get_sub_categories_by_parent($parent_id)
    {
        if ($this->input->is_ajax_request()) {
            $this->db->where('restoration_category_id', $parent_id);
            $sub_categories = $this->sub_category_model->get_for_dropdown();
            echo json_encode($sub_categories);
        }
    }
	
    function tablecolumn() {
        if ($this->input->post()) {
            $data = [];
            $data['no_of_column'] = $this->input->post('column');
            $data['index'] = $this->input->post('index');
            try {
                $success = true;
                $html = $this->load->view('restoration/template/tablecolumn', $data, true);
                $message = "success";
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }

            echo json_encode([
                'success' => $success,
                'message' => $message,
                'index' => $data['index'],
                'html' => $html
            ]);

            die;
        }
    }

    function delete($id){
        $id = (int)$id;
        if ($this->input->is_ajax_request() && $id) {
            $success = false;
            $message = _l('restoration_something_went_wrong');
            try {
                $total_rows = $this->template_model->get($id);
                if($total_rows){
                    $this->template_model->delete($id);
                    $success = true;
                    $message = _l('restoration_deleted_successfully', _l('restoration_task'));
                }
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
            ]);
            die;
        }
    }

    function builder($id) {
    $id = (int)$id;
    if ($this->input->post() && $id) {
        $postdata = $this->input->post(NULL, FALSE);
        
        $success = false;
        $message = _l('restoration_something_went_wrong');
        try {
            $this->template_table_model->update_value_data($postdata, $_FILES);
            $success = true;
            $message = _l('restoration_updated_successfully', _l('restoration_task'));
            set_alert('success', _l('restoration_updated_successfully', _l('restoration_task')));
        } catch (\Exception $e) {
            $success = false;
            $message = _l('restoration_server_error');
            set_alert('success', _l('restoration_server_error'));
        }
        redirect(admin_url('restoration/template'));
        echo json_encode([
            'success' => $success,
            'message' => $message,
        ]);
        die;
    }
    $template_table = $this->template_table_model->all(["template_id" => $id]);
    foreach ($template_table as $key => $value) {
        $template_table[$key]["column_data"] = !is_null($value["column_data"]) ? json_decode($value["column_data"], true) : [];
        $template_table[$key]["row_data"] = !is_null($value["row_data"]) ? json_decode($value["row_data"], true) : '';
        $template_table[$key]["value_data"] = !is_null($value["value_data"]) ? json_decode($value["value_data"], true) : '';
    }
    $data = [];
    $data['id'] = $id;
    $data['table_id'] = $id;
    $data['title'] = _l('restoration_task_template_builder');
    $data['icon'] = 'fa-pencil';
    $data['template_table'] = $template_table;
    // Fetch template data to get the title
    $data['template'] = $this->template_model->get($id);
    $this->load->view('template/builder', $data);
}

    function view($id){
        $id = (int)$id;
        $template_table = $this->template_table_model->all(["template_id" => $id]);
		
        foreach ($template_table as $key => $value) {
            $template_table[$key]["column_data"] = !is_null($value["column_data"])?json_decode($value["column_data"], true):[];
            $template_table[$key]["row_data"] = !is_null($value["row_data"])?json_decode($value["row_data"], true):'';
            $template_table[$key]["value_data"] = !is_null($value["value_data"])?json_decode($value["value_data"], true):'';
        }
        $data = [];
        $data['id'] = $id;
        $data['table_id'] = $id;
        $data['title'] = _l('View Template');
        $data['icon'] = 'fa-pencil';
        $data['template_table'] = $template_table;
		
        $this->load->view('template/view', $data);
    }

    function newcomponent() {
        if ($this->input->post()) {
            $data = $this->input->post();
            try {
                $success = true;
                $html = $this->load->view('restoration/template/newcomponent', $data, true);
                $message = "success";
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
                'html' => $html
            ]);

            die;
        }
    }

    function tablecomponent() {
        if ($this->input->post()) {
            $data = [];
            try {
                $success = true;
                $html = $this->load->view('restoration/template/tablecomponent', $data, true);
                $message = "success";
            } catch (\Exception $e) {
                $success = false;
                $message = _l('restoration_server_error');
            }
            echo json_encode([
                'success' => $success,
                'message' => $message,
                'html' => $html
            ]);

            die;
        }
    }
	
	public function deletecomponent() {
		if ($this->input->post()) {
			$id = $this->input->post('id');
			if ($id) {
				$this->load->model('template_table_model');
				$success = $this->template_table_model->delete_component($id);
				if ($success) {
					echo json_encode(['success' => true, 'message' => 'Component deleted successfully']);
				} else {
					echo json_encode(['success' => false, 'message' => 'Failed to delete component']);
				}
			} else {
				echo json_encode(['success' => false, 'message' => 'Invalid component ID']);
			}
		} else {
			echo json_encode(['success' => false, 'message' => 'Invalid request']);
		}
	}

}