<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Restoration Module
Description: Perfex CRM Restoration Module
Version: 1.0.1
Author: Alex Parker
Author URI: https://www.google.com
Requires at least: 2.3.*
*/

define('RESTORATION_MODULE_NAME', 'restoration');
define('RESTORATION_ASSETS_PATH', 'modules/restoration/assets');

$CI = &get_instance();
require_once __DIR__ . '/constants.php';
require_once __DIR__ . '/models/Rest_Base_Model.php';
hooks()->add_action('app_admin_head', 'restoration_styles');

function restoration_styles() {
    echo '<link href="' . module_dir_url('restoration', 'assets/css/style.css') . '" rel="stylesheet" type="text/css">';
}

hooks()->add_action('admin_init', 'restoration_module_menu_admin_items');

function restoration_module_menu_admin_items()
{
  $CI = &get_instance();
  $CI->app_menu->add_sidebar_menu_item('restoration-module-menu-master', [
      'name'     => _l('restoration'),
      'href'     => 'javascript:void(0);',
      'position' => 10,
      'icon'     => 'fa fa-trash-restore menu-icon',
  ]);

  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_category'),
    'href'     => admin_url('restoration/category'),
    'position' => 1,
    'slug'     => 'task-category',
  ]);
	
  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_sub_category'),
    'href'     => admin_url('restoration/sub_category'),
    'position' => 1,
    'slug'     => 'task-sub-category',
  ]);
	
  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_report_type'),
    'href'     => admin_url('restoration/report_type'),
    'position' => 1,
    'slug'     => 'task-report-type',
  ]);

  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_task'),
    'href'     => admin_url('restoration/template'),
    'position' => 2,
    'slug'     => 'task-template',
  ]);

  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_project'),
    'href'     => admin_url('restoration/projects'),
    'position' => 3,
    'slug'     => 'task-project',
  ]);

  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_image_category'),
    'href'     => admin_url('restoration/imagecategory'),
    'position' => 4,
    'slug'     => 'task-image_category',
  ]);

  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_file_category'),
    'href'     => admin_url('restoration/filecategory'),
    'position' => 5,
    'slug'     => 'task-file_category',
  ]);

  $CI->app_menu->add_sidebar_children_item('restoration-module-menu-master', [
    'name'     => _l('restoration_settings'),
    'href'     => admin_url('restoration/settings'),
    'position' => 6,
    'slug'     => 'task-settings',
  ]);

}

$CI->load->helper(RESTORATION_MODULE_NAME.'/restoration');

/**
 * Register activation module hook
 */
register_activation_hook(RESTORATION_MODULE_NAME, 'restoration_module_activation_hook');

function restoration_module_activation_hook()
{
  $CI = &get_instance();
  require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(RESTORATION_MODULE_NAME, [RESTORATION_MODULE_NAME]);

hooks()->add_action('clients_init', 'my_module_clients_area_menu_items');

function my_module_clients_area_menu_items()
{   
    // Show menu item only if client is logged in
    if (is_client_logged_in()) {
        add_theme_menu_item('unique-logged-in-item-id', [
                    'name'     => 'Restoration Projects',
                    'href'     => site_url('restoration/client/index'),
                    'position' => 15,
        ]);
    }
}