<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php 
    $is_edit = (isset($report) && $report); 
    $form_title = $is_edit ? 'Edit Report' : 'Add Report';
    $val_name = $is_edit ? $report->report_name : '';
    $val_type = $is_edit ? $report->report_type : '';
    $val_detail = $is_edit ? $report->report_detail : '';
    $selected_tasks = (isset($selected_tasks) && is_array($selected_tasks)) ? $selected_tasks : [];
?>

<div class="col-md-4 text-left">
    <a href="#" onclick="cancel_add_report(); return false;" class="btn btn-default">
        <i class="fa fa-arrow-left"></i> Back to Reports
    </a>
</div>

<h3><?= $form_title; ?></h3>
<hr>

<?= form_open(admin_url('restoration/projects/save_report'), ['id' => 'form_add_project_report']); ?>

<input type="hidden" name="project_id" value="<?= $project_id; ?>">

<?php if($is_edit): ?>
    <input type="hidden" name="report_id" value="<?= $report->id; ?>">
<?php endif; ?>

<div class="row">
    <div class="col-md-6">
        <?= render_input('report_name', 'Report Name', $val_name); ?>
    </div>
    <div class="col-md-6">
        <?php 
            // Pass $val_type as the selected value
            echo render_select('report_type', $report_types, ['id', 'title'], 'Report Type', $val_type); 
        ?>
    </div>
    <div class="col-md-12">
        <?= render_textarea('report_detail', 'Details/Conclusion', $val_detail); ?>
    </div>
</div>

<div class="row">
    <div class="col-md-12"><hr/><h4>Filter Tasks to Select</h4></div>
	<div class="col-md-3">
        <?php echo render_select('milestone_filter', $milestones, ['id', 'name'], 'Milestone', '', ['data-live-search' => true]); ?>
    </div>

    <div class="col-md-4">
        <?php echo render_select('category_filter', $category, ['id', 'title'], 'Category', '', ['data-live-search' => true]); ?>
    </div>
    <div class="col-md-4">
        <?php echo render_select('sub_category_filter', [], ['id', 'title'], 'Sub Category', '', ['data-live-search' => true]); ?>
    </div>
    <div class="col-md-4">
        <?php echo render_input('name_filter', 'Template Name Search', ''); ?>
    </div>
    <div class="col-md-12 text-right">
        <button type="button" id="btn_filter_tasks" class="btn btn-info" style="margin-top:10px;">Apply Filter</button>
    </div>
</div>

<div class="row">
    <div class="col-md-12"><hr/></div>
    <div class="col-md-12" id="task_list_container">
        <h4>Select Tasks</h4><hr>
        <?php if(isset($tasks) && $tasks): ?>
            <?php foreach($tasks as $t): ?>
                <?php 
                    // Check if this task was previously saved
                    $checked = in_array($t['id'], $selected_tasks) ? 'checked' : ''; 
                ?>
                <div class="checkbox">
                    <input type="checkbox" id="task_<?= $t['id']; ?>" name="task_list[]" value="<?= $t['id']; ?>" <?= $checked; ?>>
                    <label for="task_<?= $t['id']; ?>">
                        <?= $t['task_title']; ?>
						<?php if(isset($t['milestone_name']) && $t['milestone_name']) { echo '<small class="text-muted"> (' . $t['milestone_name'] . ')</small>'; } ?>
                    </label>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="text-muted">No eligible tasks found for this project.</p>
        <?php endif; ?>
    </div>
</div>

<hr>
<div class="text-right">
    <button type="button" class="btn btn-default" onclick="cancel_add_report()">Cancel</button>
    <button type="submit" class="btn btn-primary"><?= $is_edit ? 'Update Report' : 'Save Report'; ?></button>
</div>

<?= form_close(); ?>

<script>
// We don't need $(function(){}) because this script runs immediately when injected via AJAX
// 1. Handle Sub Category Dropdown
$('select[name="category_filter"]').on('change', function () {
    let catID = $(this).val();
    let $subCat = $('select[name="sub_category_filter"]');
    
    $subCat.html('<option value=""></option>');
    $subCat.selectpicker('refresh');

    if (!catID) return;

    $.ajax({
        url: admin_url + 'restoration/tasks/get_sub_categories', 
        type: 'POST',
        data: { category_id: catID },
        dataType: 'json',
        success: function(res) {
            if(typeof res === 'string') { try { res = JSON.parse(res); } catch(e){} }
            $.each(res, function(i, row){
                $subCat.append('<option value="'+ row.id +'">'+ row.title +'</option>');
            });
            $subCat.selectpicker('refresh');
        }
    });
});

// 2. Handle Filter Button
$('#btn_filter_tasks').on('click', function() {
    let project_id = $('input[name="project_id"]').val();
	let milestone    = $('select[name="milestone_filter"]').val();
    let category = $('select[name="category_filter"]').val();
    let sub_category = $('select[name="sub_category_filter"]').val();
    let name = $('input[name="name_filter"]').val();

    $('#task_list_container').css('opacity', '0.5');

    $.ajax({
        url: admin_url + 'restoration/projects/get_filtered_tasks_html',
        type: 'POST',
        data: {
            project_id: project_id,
			milestone_id: milestone,
            category: category,
            sub_category: sub_category,
            name: name
        },
        dataType: 'json',
        success: function(response) {
            $('#task_list_container').html(response.html);
            $('#task_list_container').css('opacity', '1');
        },
        error: function() {
            alert('Error fetching tasks');
            $('#task_list_container').css('opacity', '1');
        }
    });
});

// 3. Optional: Handle Form Submit via AJAX (to prevent page reload)
// If you want to keep simple redirect, keep standard form submit. 
// If you want to stay on tab, use this:
$('#form_add_project_report').on('submit', function(e) {
    // e.preventDefault(); 
    // For now, let's allow standard submit as per your controller logic (redirects to view?group=project_reports)
    // This works fine.
});
</script>