<?php defined('BASEPATH') or exit('No direct script access allowed');

foreach ($milestones as $milestone) {
    // 1. Logic to fetch tasks (Updated to use your custom restoration model logic from previous step)
    // Note: Ensure your controller is passing 'tasks' inside $milestone, or use the query below if using standard logic
    // $milestonesTasksWhere = [];
    // if ($milestones_exclude_completed_tasks) {
    //    $milestonesTasksWhere['status !='] = Tasks_model::STATUS_COMPLETE;
    // }
    
    // Assuming the controller passes the tasks in $milestone['tasks'] based on previous conversation
    // If not, revert to the original $this->projects_model->do_milestones_kanban_query...
    $tasks = isset($milestone['tasks']) ? $milestone['tasks'] : [];
    $total_tasks = count($tasks);
    $total_pages = 1; // Simplified for custom view, or calculate based on count

    // 2. Prepare Color Picker HTML
    $cpicker = '';
    if (staff_can('edit_milestones', 'projects') && $milestone['id'] != 0) {
        foreach (get_system_favourite_colors() as $color) {
            $color_selected_class = 'cpicker-small';
            $cpicker .= "<div class='kanban-cpicker cpicker " . $color_selected_class . "' data-color='" . $color . "' style='background:" . $color . ';border:1px solid ' . $color . "'></div>";
        }
    }

    // 3. Determine Background Color
    $milestone_color = '';
    if (!empty($milestone['color']) && !is_null($milestone['color'])) {
        $milestone_color = ' style="background:' . $milestone['color'] . ';border:1px solid ' . $milestone['color'] . '"';
    }

    if ($milestone['id'] == 0 && count($tasks) == 0) {
        continue;
    } 
?>
<ul class="kan-ban-col milestone-column<?php if (staff_cant('edit_milestones', 'projects') || $milestone['id'] == 0) { echo ' milestone-not-sortable'; } ?>"
    data-col-status-id="<?= e($milestone['id']); ?>"
    data-total-pages="<?= e($total_pages); ?>">
    
    <li class="kan-ban-col-wrapper">
        <div class="border-right panel_s">
            
            <div class="panel-heading <?php if ($milestone_color != '') { echo 'color-not-auto-adjusted color-white '; } ?><?php if ($milestone['id'] != 0) { echo 'task-phase'; } else { echo 'bg-info'; } ?>" <?= $milestone_color; ?>>
                
                <div class="tw-flex tw-justify-between tw-items-center">
                    <span class="bold heading tw-max-w-[150px] tw-truncate tw-inline-block">
                        <?= e($milestone['name']); ?>
                        <?php if($milestone['id'] != 0) { ?>
                            <span class="tw-text-xs tw-opacity-80">
                                <br>
                                <?= _d($milestone['start_date']) . ' - ' . _d($milestone['due_date']); ?>
                            </span>
                        <?php } ?>
                    </span>

                    <?php if ($milestone['id'] != 0) { ?>
                        <div class="dropdown">
                            <a href="#" class="dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="color:inherit;">
                                <i class="fa-solid fa-ellipsis-vertical fa-lg"></i>
                            </a>
                            
                            <ul class="dropdown-menu dropdown-menu-right">
                                
                                <?php if (staff_can('edit_milestones', 'projects')) { ?>
                                    <li>
                                        <a href="#" 
                                           data-hide-from-customer="<?= e($milestone['hide_from_customer']); ?>"
                                           data-description-visible-to-customer="<?= e($milestone['description_visible_to_customer']); ?>"
                                           data-description="<?= $milestone['description'] ? htmlspecialchars(clear_textarea_breaks($milestone['description'])) : ''; ?>"
                                           data-name="<?= e($milestone['name']); ?>"
                                           data-start_date="<?= _d($milestone['start_date']); ?>"
                                           data-due_date="<?= _d($milestone['due_date']); ?>"
                                           data-order="<?= e($milestone['milestone_order']); ?>"
                                           data-geo="<?= e($milestone['target_geo']); ?>"
                                           data-urls="<?= htmlspecialchars(clear_textarea_breaks($milestone['target_urls'])); ?>"
                                           data-keyword="<?= htmlspecialchars(clear_textarea_breaks($milestone['keyword_list'])); ?>"
                                           data-notes="<?= htmlspecialchars(clear_textarea_breaks($milestone['notes_goals'])); ?>"
                                           onclick="edit_milestone(this,<?= e($milestone['id']); ?>); return false;">
                                            <i class="fa-regular fa-pen-to-square tw-mr-2"></i> <?= _l('edit_milestone'); ?>
                                        </a>
                                    </li>
                                <?php } ?>

                                <?php if (staff_can('create', 'tasks')) { ?>
                                    <li>
                                        <a href="<?= admin_url('restoration/projects/task/' . $project_id); ?>">
                                            <i class="fa-solid fa-plus tw-mr-2"></i> <?= _l('new_task'); ?>
                                        </a>
                                    </li>
                                <?php } ?>

                                <?php if (staff_can('edit_milestones', 'projects') && $cpicker != '') { ?>
                                    <li role="separator" class="divider"></li>
                                    <li class="dropdown-header"><?= _l('milestone_color'); ?></li>
                                    <li>
                                        <div class="kan-ban-settings cpicker-wrapper tw-px-4 tw-py-2">
                                            <?= $cpicker; ?>
                                        </div>
                                    </li>
                                    <li>
                                        <a href="#" class="reset_milestone_color <?php if ($milestone_color == '') { echo 'hide'; } ?>" data-color="">
                                            <?= _l('reset_to_default_color'); ?>
                                        </a>
                                    </li>
                                <?php } ?>

                            </ul>
                        </div>
                    <?php } ?>
                </div>

                <?php if (staff_can('create', 'tasks')) { 
                    // Note: Your custom table might not have total_logged_time, remove if causing errors
                    if(isset($milestone['total_logged_time'])){ ?>
                        <p class="tw-text-sm tw-mb-0 tw-mt-2">
                            <?= e(_l('milestone_total_logged_time') . ': ' . seconds_to_time_format($milestone['total_logged_time'])); ?>
                        </p>
                <?php } 
                } ?>
            </div>

            <div class="kan-ban-content-wrapper">
                <div class="kan-ban-content">
                    <ul class="status project-milestone milestone-tasks-wrapper sortable relative"
                        data-task-status-id="<?= e($milestone['id']); ?>">
                        
                        <?php
                        foreach ($tasks as $task) {
                            $this->load->view('restoration/projects/_milestone_kanban_card', ['task' => $task, 'milestone' => $milestone['id']]);
                        } 
                        ?>
                        
                        <?php if ($total_tasks > 0 && isset($total_pages) && $total_pages > 1) { ?>
                            <li class="text-center not-sortable kanban-load-more" data-load-status="<?= e($milestone['id']); ?>">
                                <a href="#" class="btn btn-default btn-block" data-page="1"
                                   onclick="kanban_load_more(<?= e($milestone['id']); ?>,this,'projects/milestones_kanban_load_more',320,360); return false;">
                                    <?= _l('load_more'); ?>
                                </a>
                            </li>
                        <?php } ?>

                        <li class="text-center not-sortable mtop30 kanban-empty<?php if ($total_tasks > 0) { echo ' hide'; } ?>">
                            <h4>
                                <i class="fa-solid fa-circle-notch" aria-hidden="true"></i><br /><br />
                                <?= _l('no_tasks_found'); ?>
                            </h4>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </li>
</ul>
<?php } ?>