<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="row">
    <!-- File Upload Form -->
    <?= form_open_multipart(admin_url('projects/upload_file/' . $project->id), ['class' => 'dropzone', 'id' => 'project-images-dropzone']); ?>
    <div class="col-md-4">
        <?= render_select('category_id', $category, ['id', 'title'], 'Category', '', ['id' => 'image_category_id']); ?>
    </div>
    <div class="col-md-12 mtop15">
        <input type="file" name="file" multiple accept="image/*" />
        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>" />
        <input type="hidden" name="project_image" value="project_image" />
        <input type="hidden" name="rel_type" value="restoration" />
    </div>
    <?= form_close(); ?>

    <!-- Visibility Toggle -->
    <span class="tw-mt-4 tw-inline-block tw-text-sm"><?= _l('project_file_visible_to_customer'); ?></span><br />
    <div class="onoffswitch">
        <input type="checkbox" name="visible_to_customer" id="pf_visible_to_customer" class="onoffswitch-checkbox">
        <label class="onoffswitch-label" for="pf_visible_to_customer"></label>
    </div>

    <!-- External File Picker Buttons -->
    <div class="tw-flex tw-justify-end tw-items-center tw-space-x-2">
        <button class="gpicker" data-on-pick="projectFileGoogleDriveSave">
            <i class="fa-brands fa-google" aria-hidden="true"></i>
            <?= _l('choose_from_google_drive'); ?>
        </button>
        <div id="dropbox-chooser"></div>
    </div>
    <div class="clearfix"></div>
    <div class="mtop20"></div>

    <!-- Bulk Actions Modal -->
    <div class="modal fade bulk_actions" id="project_images_bulk_actions" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?= _l('bulk_actions'); ?></h4>
                </div>
                <div class="modal-body">
                    <?php if (is_admin()) { ?>
                    <div class="checkbox checkbox-danger">
                        <input type="checkbox" name="mass_delete" id="mass_delete">
                        <label for="mass_delete"><?= _l('mass_delete'); ?></label>
                    </div>
                    <hr class="mass_delete_separator" />
                    <?php } ?>
                    <div id="bulk_change">
                        <div class="form-group">
                            <label class="mtop5"><?= _l('project_file_visible_to_customer'); ?></label>
                            <div class="onoffswitch">
                                <input type="checkbox" name="bulk_visible_to_customer" id="bulk_pf_visible_to_customer" class="onoffswitch-checkbox">
                                <label class="onoffswitch-label" for="bulk_pf_visible_to_customer"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                    <a href="#" class="btn btn-primary" onclick="project_images_bulk_action(this); return false;"><?= _l('confirm'); ?></a>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->

    <!-- Bulk Actions and Download All Buttons -->
    <a href="#" data-toggle="modal" data-target="#project_images_bulk_actions" class="bulk-actions-btn table-btn hide" data-table=".table-project-images">
        <?= _l('bulk_actions'); ?>
    </a>
    <a href="#" onclick="window.location.href = '<?= admin_url('projects/download_all_files/' . $project->id); ?>'; return false;" class="table-btn hide" data-table=".table-project-images">
        <?= _l('download_all'); ?>
    </a>
    <div class="clearfix"></div>

    <!-- Images Table -->
    <div class="panel_s panel-table-full">
        <div class="panel-body">
            <table class="table dt-table table-project-images" data-order-col="7" data-order-type="desc">
                <thead>
                    <tr>
                        <th data-orderable="false"><span class="hide"> - </span>
                            <div class="checkbox mass_select_all_wrap"><input type="checkbox" id="mass_select_all" data-to-table="project-images"><label></label></div>
                        </th>
                        <th><?= _l('project_file_filename'); ?></th>
                        <th><?= _l('project_file__filetype'); ?></th>
                        <th><?= _l('project_discussion_last_activity'); ?></th>
                        <th><?= _l('project_discussion_total_comments'); ?></th>
                        <th><?= _l('project_file_visible_to_customer'); ?></th>
                        <th><?= _l('project_file_uploaded_by'); ?></th>
                        <th><?= _l('project_file_dateadded'); ?></th>
                        <th><?= _l('options'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
				
					foreach ($project_images as $image) {
                        $path = get_upload_path_by_type('project') . $project->id . '/' . $image['file_name'];
                    ?>
                    <tr>
                        <td>
                            <div class="checkbox"><input type="checkbox" value="<?= e($image['id']); ?>"><label></label></div>
                        </td>
                        <td data-order="<?= e($image['file_name']); ?>">
                            <a href="#" onclick="view_project_image(<?= e($image['id']); ?>,<?= e($image['project_id']); ?>); return false;">
                                <?php if (is_image(PROJECT_ATTACHMENTS_FOLDER . $project->id . '/' . $image['file_name']) || (!empty($image['external']) && !empty($image['thumbnail_link']))) {
                                    echo '<div class="text-left"><i class="fa fa-spinner fa-spin mtop30"></i></div>';
                                    echo '<img class="project-file-image img-table-loading" src="#" data-orig="' . e(project_file_url($image, true)) . '" width="100">';
                                    echo '</div>';
                                }
                                echo $image['subject'] ?: $image['file_name']; ?>
                            </a>
                        </td>
                        <td data-order="<?= e($image['filetype']); ?>">
                            <?= e($image['filetype']); ?>
                        </td>
                        <td data-order="<?= e($image['last_activity']); ?>">
                            <?php
                            if (!is_null($image['last_activity'])) { ?>
                                <span class="text-has-action" data-toggle="tooltip" data-title="<?= e(_dt($image['last_activity'])); ?>">
                                    <?= e(time_ago($image['last_activity'])); ?>
                                </span>
                            <?php } else {
                                echo _l('project_discussion_no_activity');
                            } ?>
                        </td>
                        <?php $total_image_comments = total_rows(db_prefix() . 'projectdiscussioncomments', ['discussion_id' => $image['id'], 'discussion_type' => 'file']); ?>
                        <td data-order="<?= e($total_image_comments); ?>">
                            <?= e($total_image_comments); ?>
                        </td>
                        <td data-order="<?= e($image['visible_to_customer']); ?>">
                            <?php
                            $checked = ($image['visible_to_customer'] == 1) ? 'checked' : '';
                            ?>
                            <div class="onoffswitch">
                                <input type="checkbox" data-switch-url="<?= admin_url(); ?>projects/change_file_visibility" id="<?= e($image['id']); ?>" data-id="<?= e($image['id']); ?>" class="onoffswitch-checkbox" value="<?= e($image['id']); ?>" <?= e($checked); ?>>
                                <label class="onoffswitch-label" for="<?= e($image['id']); ?>"></label>
                            </div>
                        </td>
                        <td>
                            <?php if ($image['staffid'] != 0) {
                                $_data = '<a href="' . admin_url('staff/profile/' . $image['staffid']) . '">' . staff_profile_image($image['staffid'], ['staff-profile-image-small']) . '</a>';
                                $_data .= ' <a href="' . admin_url('staff/member/' . $image['staffid']) . '">' . e(get_staff_full_name($image['staffid'])) . '</a>';
                                echo $_data;
                            } else {
                                echo '<img src="' . e(contact_profile_image_url($image['contact_id'], 'thumb')) . '" class="client-profile-image-small mrigh5">
                                    <a href="' . admin_url('clients/client/' . get_user_id_by_contact_id($image['contact_id']) . '?contactid=' . $image['contact_id']) . '">' . e(get_contact_full_name($image['contact_id'])) . '</a>';
                            } ?>
                        </td>
                        <td data-order="<?= e($image['dateadded']); ?>">
                            <?= e(_dt($image['dateadded'])); ?>
                        </td>
                       
                        <td>
                            <div class="tw-flex tw-items-center tw-space-x-2">
                                <?php if (empty($image['external'])) {
                                    $file_name = $image['original_file_name'] != '' ? $image['original_file_name'] : $image['file_name']; ?>
                                    <a href="#" data-toggle="modal" data-original-file-name="<?= e($file_name); ?>" data-filetype="<?= e($image['filetype']); ?>" data-file-name="<?= e($image['original_file_name']); ?>" data-path="<?= PROJECT_ATTACHMENTS_FOLDER . $project->id . '/' . $image['file_name']; ?>" data-target="#send_file" class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 tw-mt-1">
                                        <i class="fa-regular fa-envelope fa-lg"></i>
                                    </a>
                                <?php } ?>
                                <?php if ($image['staffid'] == get_staff_user_id() || staff_can('delete', 'projects')) { ?>
                                    <a href="<?= admin_url('restoration/projects/remove_images/' . $project->id . '/' . $image['id']); ?>" class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                        <i class="fa-regular fa-trash-can fa-lg"></i>
                                    </a>
                                <?php } ?>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal for Viewing Image -->
    <div id="project_image_data"></div>
</div>

<?php include_once APPPATH . 'views/admin/clients/modals/send_file_modal.php'; ?>