<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel_s">
    <div class="panel-body">

        <div id="project_reports_list_area">
            <div class="row mb-3">
                <div class="col-md-12 text-right">
                    <button onclick="load_add_report_form(); return false;" class="btn btn-primary">
                        Add Report
                    </button> 
                </div>
            </div>
            <hr>

            <div class="table-responsive">
                <table class="table table-striped table-project_reports">
                    <thead>
                        <tr>
                            <th>Sr No.</th>
                            <th>Report Name</th>
                            <th>Report Type</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        </tbody>
                </table>
            </div>
        </div>

        <div id="project_add_report_area" class="hide">
            <div class="text-center p-5">
                <i class="fa fa-spinner fa-spin fa-2x"></i> Loading form...
            </div>
        </div>
		
		<div id="project_view_report_area" class="hide">
            <div class="text-center p-5">
                <i class="fa fa-spinner fa-spin fa-2x"></i> Loading form...
            </div>
        </div>

    </div>
</div>

<?php init_tail(); ?>
<script>
$(function(){
    // Init Table
    initDataTable(
        '.table-project_reports',
        admin_url + 'restoration/projects/reports_table/' + <?= $project->id ?>,
        undefined, 
        undefined, 
        'undefined', 
        [0, 'desc']
    );
});

// Function to fetch and show the Add Report form
function load_add_report_form() {
    var url = admin_url + 'restoration/projects/add_report/<?= $project->id; ?>';
    
    // Show loading
    $('#project_reports_list_area').addClass('hide');
    $('#project_add_report_area').removeClass('hide');

    // Fetch Content
    $.get(url, function(response) {
        $('#project_add_report_area').html(response);
        // Re-initialize any necessary plugins (selectpicker, etc) for the new content
        init_selectpicker();
        init_datepicker();
    }).fail(function() {
        alert('Failed to load form.');
        cancel_add_report();
    });
}

/* EDIT EXISTING (NEW FUNCTION) */
function load_edit_report(project_id, report_id) {
    $('#project_reports_list_area').addClass('hide');
    $('#project_add_report_area').removeClass('hide').html('<div class="text-center p-5"><i class="fa fa-spinner fa-spin"></i> Loading Edit Form...</div>');
    
    // Call with both IDs
    $.get(admin_url + 'restoration/projects/add_report/' + project_id + '/' + report_id, function(response) {
        $('#project_add_report_area').html(response);
        init_selectpicker();
    });
}
	
// Function to go back to the list
function cancel_add_report() {
    $('#project_add_report_area').addClass('hide').html(''); // Clear content to reset state
    $('#project_reports_list_area').removeClass('hide');
    $('.table-project_reports').DataTable().ajax.reload(); // Optional: reload table
}
	
/* --- VIEW REPORT LOGIC (NEW) --- */
function load_view_report(report_id) {
    $('#project_reports_list_area').addClass('hide');
    $('#project_view_report_area').removeClass('hide').html('<div class="text-center p-5"><i class="fa fa-spinner fa-spin"></i> Loading Report...</div>');

    $.get(admin_url + 'restoration/projects/view_report_detail/' + report_id, function(response) {
        $('#project_view_report_area').html(response);
    });
}

function cancel_view_report() {
    $('#project_view_report_area').addClass('hide').html('');
    $('#project_reports_list_area').removeClass('hide');
}
</script>