<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12 mb-4">
                                <h3 class="no-margin font-bold"><i class="fa <?php echo $icon ?>" aria-hidden="true"></i> <?php echo $title; ?></h3>
                            </div>
                            <div class="col-md-12"><hr/></div>
                            <?= form_open(admin_url('restoration/tasks/getcategory'), ['id' => 'form_template_by_category']); ?>
                                <div class="col-md-4">
                                <?php
                                    echo render_select('category', $category, ['id', 'title'], 'Category', '', ['data-live-search' => true], [], '', '', true);
                                ?>
                                </div>
							    <div class="col-md-4">
								<?php
									echo render_select('sub_category', $sub_category, ['id', 'title'], 'Sub Category', '', ['data-live-search' => true],[],'','',true);
								?>
								</div>
                                <div class="col-md-4">
                                <?php
                                    echo render_input('name', 'Name', '');
                                ?>
                                </div>
                                <div class="col-md-4">
                                    <button type="submit" class="btn btn-primary" style="margin-top: 25px;"><?php echo _l('Search'); ?></button>
                                </div>
                            <?= form_close(); ?>
                            <div class="col-md-12"><hr/></div>
                            <div class="col-md-12">
                            <?= form_open(admin_url('restoration/projects/add_tasks/'), ['id' => 'form_template_add_edit_task']); ?>
                            <?= form_hidden('project_id', $id); ?>
								<div class="row">
									<div class="col-md-6">
										<div class="form-group">
											<label for="milestone_id">Select Milestone (Optional)</label>
											<select name="milestone_id" id="milestone_id" class="form-control selectpicker" data-live-search="true">
												<option value="">-- All Project Tasks --</option>
												<?php foreach($milestones as $m) { ?>
													<option value="<?= $m['id']; ?>"><?= $m['name']; ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="col-md-12"><hr/></div>
								</div>
                                <div class="row" id="category_list">
                                    <?php
                                    if($category){
                                        foreach ($category as $cat_key => $cat_value) {
                                            $template = $cat_value["template"];
                                            ?>
                                            <div class="col-md-12">
                                                <div class="row">
                                                <div class="col-md-12"><h5><?= $cat_value["title"]; ?></h5></div>
                                                <?php
                                                if($template){
                                                    foreach ($template as $key => $value) {
                                                    ?>
                                                    <div class="col-md-4">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" name="template[]" value='<?= $value['id']; ?>' <?= (in_array($value['id'], $tasks)?'checked':''); ?> id="template-<?= $value['id']; ?>">
                                                            <label class="form-check-label" for="template-<?= $value['id']; ?>">
                                                                <?= $value['title']; ?>
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    }
                                                } else {
                                                ?>
                                                <div class="col-md-12">
                                                    No template found
                                                </div>
                                                <?php
                                                }
                                                ?>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 text-right">
                                        <button type="submit" class="btn btn-primary" autocomplete="off" data-loading-text="<?= _l('wait_text'); ?>"><?= _l('submit'); ?></button>
                                    </div>
                                </div>
                            <?= form_close(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
	$('select[name="category"]').on('change', function () {

		let catID = $(this).val();
		let $subCat = $('select[name="sub_category"]');

		$subCat.html('<option value=""></option>').selectpicker('refresh');

		if (!catID) return;

		$.ajax({
			url: admin_url + 'restoration/tasks/get_sub_categories',
			type: 'POST',
			data: { category_id: catID },
			success: function(res) {
				try { res = JSON.parse(res); } catch(e){ return; }

				$.each(res, function(i, row){
					$subCat.append('<option value="'+ row.id +'">'+ row.title +'</option>');
				});

				$subCat.selectpicker('refresh');
			}
		});

	});

    $(function() {
        $("#form_template_add_edit_task").appFormValidator({
            rules:{
                template: 'required',
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo( element.parents(".form-group"));
            },
            submitHandler: function(form) {
                template_add_edit_task_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });

        $("#form_template_by_category").appFormValidator({
            rules:{
                category: 'required',
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo( element.parents(".form-group"));
            },
            submitHandler: function(form) {
                template_by_category_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });
		
		$('#milestone_id').on('change', function() {
			var milestoneId = $(this).val();
			var projectId = $('input[name="project_id"]').val();

			// Show a loader or disable inputs if needed
			$('input[name="template[]"]').prop('disabled', true);

			$.ajax({
				url: admin_url + 'restoration/projects/get_project_task_ids',
				type: 'POST',
				dataType: 'json',
				data: {
					project_id: projectId,
					milestone_id: milestoneId
				},
				success: function(response) {
					// response should be an array of template_ids: ["41", "42"]

					// 1. Uncheck ALL checkboxes first
					$('input[name="template[]"]').prop('checked', false);

					// 2. Check ONLY the ones returned from server
					if(response.length > 0){
						$.each(response, function(index, value) {
							// Check the box with this value
							$('input[name="template[]"][value="' + value + '"]').prop('checked', true);
						});
					}

					// Re-enable inputs
					$('input[name="template[]"]').prop('disabled', false);
				},
				error: function() {
					alert('Error fetching tasks');
					$('input[name="template[]"]').prop('disabled', false);
				}
			});
		});

    });

    function template_add_edit_task_handler(form){
        $("#add_loader").removeClass('d-none');
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            $("#add_loader").addClass('d-none');
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                alert_float('success', response.message);
                window.location = response.redirect_url;
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });
    }

    function template_by_category_handler(form){
        $("#add_loader").removeClass('d-none');
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            $("#add_loader").addClass('d-none');
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                alert_float('success', response.message);
                $("#category_list").html(response.html);
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });
    }

</script>