<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <?= form_hidden('project_id', $project->id) ?>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="-tw-mt-3">
                </div>
            </div>
            <div class="col-md-12">
                <div class="_buttons">
                    <div class="row">
                        <div class="col-md-7 project-heading">
                            <div class="tw-flex tw-flex-wrap tw-items-center">
                                <h3 class="hide project-name">
                                    <?= e($project->name); ?>
                                </h3>
                                <div id="project_view_name"
                                    class="ltr:tw-mr-5 rtl:tw-ml-5 tw-min-w-[250px] tw-max-w-[350px]">
                                    <div class="tw-w-full">
                                        <select class="selectpicker" id="project_top" data-width="100%"
                                            <?php if (count($other_projects) > 6) { ?>
                                            data-live-search="true"
                                            <?php } ?>>
                                            <option
                                                value="<?= e($project->id); ?>"
                                                selected
                                                data-content="<?= e($project->name); ?> - <small><?= e($project->client_data->company); ?></small>">
                                                <?= e($project->client_data->company); ?>
                                                <?= e($project->name); ?>
                                            </option>
                                            <?php foreach ($other_projects as $op) { ?>
                                            <option
                                                value="<?= e($op['id']); ?>"
                                                data-subtext="<?= e($op['company']); ?>">
                                                #<?= e($op['id']); ?>
                                                -
                                                <?= e($op['name']); ?>
                                            </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="visible-xs">
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 text-right tw-space-x-1">
                            <?php if (staff_can('create', 'tasks')) { ?>
                            <a href="<?= admin_url('restoration/projects/task/' . $project->id); ?>" class="btn btn-primary">
                                <i class="fa-regular fa-plus tw-mr-1"></i>
                                <?= _l('new_task'); ?>
                            </a> <?php /* onclick="new_task_from_restoration(<?= $project->id; ?>); return false;" */ ?>
                            
                            <?php } ?>
                            <?php $project_pin_tooltip = _l('pin_project'); ?>
                            <?php if (total_rows(db_prefix() . 'pinned_projects', ['staff_id' => get_staff_user_id(), 'project_id' => $project->id]) > 0) {
                                $project_pin_tooltip = _l('unpin_project');
                            } ?>
                            <div class="btn-group">
                                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                                    aria-haspopup="true" aria-expanded="false">
                                    <?= _l('more'); ?>
                                    <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right width200 project-actions">
                                    <li>
                                        <a
                                            href="<?= admin_url('projects/pin_action/' . $project->id); ?>">
                                            <?= e($project_pin_tooltip); ?>
                                        </a>
                                    </li>
                                    <?php if (staff_can('edit', 'projects')) { ?>
                                    <li>
                                        <a
                                            href="<?= admin_url('projects/project/' . $project->id); ?>">
                                            <?= _l('edit_project'); ?>
                                        </a>
                                    </li>
                                    <?php } ?>
                                    <?php if (staff_can('create', 'projects')) { ?>
                                    <li>
                                        <a href="#" onclick="copy_project(); return false;">
                                            <?= _l('copy_project'); ?>
                                        </a>
                                    </li>
                                    <?php } ?>
                                    <?php if (staff_can('create', 'projects') || staff_can('edit', 'projects')) { ?>
                                    <li class="divider"></li>
                                    <?php foreach ($statuses as $status) {
                                        if ($status['id'] == $project->status) {
                                            continue;
                                        } ?>
                                    <li>
                                        <a href="#"
                                            data-name="<?= _l('project_status_' . $status['id']); ?>"
                                            onclick="project_mark_as_modal(<?= e($status['id']); ?>,<?= e($project->id); ?>, this); return false;"><?= e(_l('project_mark_as', $status['name'])); ?></a>
                                    </li>
                                    <?php } ?>
                                    <?php } ?>
                                    <li class="divider"></li>
                                    <?php if (staff_can('create', 'projects')) { ?>
                                    <li>
                                        <a href="<?= admin_url('projects/export_project_data/' . $project->id); ?>"
                                            target="_blank"><?= _l('export_project_data'); ?></a>
                                    </li>
                                    <?php } ?>
                                    <?php if (is_admin()) { ?>
                                    <li>
                                        <a href="<?= admin_url('restoration/projects/view_project_as_client/' . $project->id . '/' . $project->clientid); ?>"
                                            target="_blank"><?= _l('project_view_as_client'); ?></a>
                                    </li>
                                    <?php } ?>
                                    <?php if (staff_can('delete', 'projects')) { ?>
                                    <li>
                                        <a href="<?= admin_url('projects/delete/' . $project->id); ?>"
                                            class="_delete">
                                            <span
                                                class="text-danger"><?= _l('delete_project'); ?></span>
                                        </a>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="project-menu-panel tw-mt-3 tw-mb-4">
                    <?php hooks()->do_action('before_render_project_view', $project->id); ?>
                    <?php $this->load->view('restoration/projects/project_tabs'); ?>
                </div>
                <?php $this->load->view(($tab ? $tab['view'] : 'admin/projects/project_overview')); ?>
            </div>
        </div>
    </div>
</div>
</div>
</div>

<div class="modal fade" id="add-edit-tasks" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?= form_open(admin_url('restoration/projects/assign_task_project/' . $project->id)); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <?= _l('Assign Tasks'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <?php
                $selected = [];

                /* foreach ($members as $member) {
                    array_push($selected, $member['staff_id']);
                } */
                echo render_select('task_lists[]', $task_list, ['id', 'name'], 'task_lists', $selected, ['multiple' => true, 'data-actions-box' => true], [], '', '', false);
                ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default"
                    data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary" autocomplete="off"
                    data-loading-text="<?= _l('wait_text'); ?>"><?= _l('submit'); ?></button>
            </div>
        </div>
        <!-- /.modal-content -->
        <?= form_close(); ?>
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="add-edit-members" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?= form_open(admin_url('projects/add_edit_members/' . $project->id)); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <?= _l('project_members'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <?php
                $selected = [];

                foreach ($members as $member) {
                    array_push($selected, $member['staff_id']);
                }
                echo render_select('project_members[]', $staff, ['staffid', ['firstname', 'lastname']], 'project_members', $selected, ['multiple' => true, 'data-actions-box' => true], [], '', '', false);
                ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default"
                    data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary" autocomplete="off"
                    data-loading-text="<?= _l('wait_text'); ?>"><?= _l('submit'); ?></button>
            </div>
        </div>
        <!-- /.modal-content -->
        <?= form_close(); ?>
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="assign_restoration_task_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-mg">
        <?= form_open(admin_url('restoration/tasks/submit_task'), ['id' => 'form_template_add_edit_task']); ?>
        <input type="hidden" name="task_id" id="task_id" value="">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <?= _l('Edit Task'); ?>
                </h4>
            </div>
            <div class="modal-body" id="assign_restoration_task_modal_body">
                <div class="form-group">
                    <label for="start_date" class="control-label"><?= _l('Start Date'); ?></label>
                    <input type="text" id="start_date" name="start_date" class="form-control datepicker" autocomplete="off">
                </div>

                <div class="form-group">
                    <label for="due_date" class="control-label"><?= _l('Due Date'); ?></label>
                    <input type="text" id="due_date" name="due_date" class="form-control datepicker" autocomplete="off">
                </div>

                <div class="form-group">
                    <label for="assignees" class="control-label"><?= _l('Assignees'); ?></label>
                    <select id="assignees" name="assignees" class="form-control selectpicker" data-live-search="true">
                        <option value="">Select</option>
                        <?php foreach ($staff as $key => $value): ?>
                            <option value="<?= $value['staffid']; ?>"><?= $value['firstname'].' '.$value['lastname']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="followers" class="control-label"><?= _l('Followers'); ?></label>
                    <select id="followers" name="followers" class="form-control selectpicker" data-live-search="true">
                        <option value="">Select</option>
                        <?php foreach ($staff as $key => $value): ?>
                            <option value="<?= $value['staffid']; ?>"><?= $value['firstname'].' '.$value['lastname']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-default"
                    data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
            </div>
        </div>
        <!-- /.modal-content -->
        <?= form_close(); ?>
    </div>
    <!-- /.modal-dialog -->
</div>



<!-- /.modal -->
<?php if (isset($discussion)) {
    echo form_hidden('discussion_id', $discussion->id);
    echo form_hidden('discussion_user_profile_image_url', $discussion_user_profile_image_url);
    echo form_hidden('current_user_is_admin', $current_user_is_admin);
}
echo form_hidden('project_percent', $percent);
?>
<div id="invoice_project"></div>
<div id="pre_invoice_project"></div>
<?php $this->load->view('restoration/projects/milestone'); ?>
<?php $this->load->view('restoration/projects/copy_settings'); ?>
<?php $this->load->view('restoration/projects/_mark_tasks_finished'); ?>

<!-- Email Modal -->
<div class="modal fade" id="sendEmailModal" tabindex="-1" role="dialog" aria-labelledby="emailModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <?php echo form_open_multipart(admin_url('restoration/projects/email_report_pdf'), ['id' => 'form_email_send']);  ?>
                <?= form_hidden('project_id', $project->id); ?>
                <div class="modal-header">
                    <h4 class="modal-title">Send Email</h4>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <?php
							$default_email = isset($client_email->contact_email) ? $client_email->contact_email : '';
							echo render_input('email', 'Email', $default_email, ''); 
						?>
                    </div>
                    <div class="form-group">
                        <?php $restoration_email_subject = get_option('restoration_email_subject')?get_option('restoration_email_subject'):''; ?>
                        <?php echo render_input('subject', 'Subject', $restoration_email_subject, ''); ?>
                    </div>
                    <div class="form-group">
                        <?php $restoration_email_body = get_option('restoration_email_body')?get_option('restoration_email_body'):''; ?>
                        <?php echo render_textarea('body', 'Body', $restoration_email_body, [], [], '', 'tinymce'); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Send Email</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
    jQuery(document).ready(() => {

        $("#form_email_send").appFormValidator({
            rules: {
                email:{
                    required: true,
                },
                subject: {
                    required: true,
                    minlength: 3
                },
                body: {
                    required: true,
                    minlength: 5
                }
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo(element.parents(".form-group"));
            },
            submitHandler: function(form) {
                event.preventDefault();
                add_edit_form_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });

    });

    function add_edit_form_handler(form){
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                $('#form_email_send')[0].reset();
                $('#sendEmailModal').modal('hide');
                alert_float('success', response.message);
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });
    }

</script>

<!-- For invoices table -->
<script>
    taskid = '<?= $this->input->get('taskid'); ?>';
</script>
<script>
    var gantt_data = {};
    <?php if (isset($gantt_data)) { ?>
    gantt_data = <?= json_encode($gantt_data); ?> ;
    <?php } ?>
    var discussion_id = $('input[name="discussion_id"]').val();
    var discussion_user_profile_image_url = $('input[name="discussion_user_profile_image_url"]').val();
    var current_user_is_admin = $('input[name="current_user_is_admin"]').val();
    var project_id = $('input[name="project_id"]').val();
    if (typeof(discussion_id) != 'undefined') {
        discussion_comments('#discussion-comments', discussion_id, 'regular');
    }
    $(function() {
        var project_progress_color =
            '<?= hooks()->apply_filters('admin_project_progress_color', '#84c529'); ?>';
        var circle = $('.project-progress').circleProgress({
            fill: {
                gradient: [project_progress_color, project_progress_color]
            }
        }).on('circle-animation-progress', function(event, progress, stepValue) {
            $(this).find('strong.project-percent').html(parseInt(100 * stepValue) + '<i>%</i>');
        });
    });

    function discussion_comments(selector, discussion_id, discussion_type) {
        var defaults = _get_jquery_comments_default_config(
            <?= json_encode(get_project_discussions_language_array()); ?>
        );
        var options = {
            // https://github.com/Viima/jquery-comments/pull/169
            wysiwyg_editor: {
                opts: {
                    enable: true,
                    is_html: true,
                    container_id: 'editor-container',
                    comment_index: 0,
                },
                init: function(textarea, content) {
                    var comment_index = textarea.data('comment_index');
                    var editorConfig = _simple_editor_config();
                    editorConfig.setup = function(ed) {
                        initializeTinyMceMentions(ed, function() {
                            return $.getJSON(admin_url + 'projects/get_staff_names_for_mentions/' +
                                project_id)
                        })

                        textarea.data('wysiwyg_editor', ed);

                        ed.on('change', function() {
                            var value = ed.getContent();
                            if (value !== ed._lastChange) {
                                ed._lastChange = value;
                                textarea.trigger('change');
                            }
                        });

                        ed.on('keyup', function() {
                            var value = ed.getContent();
                            if (value !== ed._lastChange) {
                                ed._lastChange = value;
                                textarea.trigger('change');
                            }
                        });

                        ed.on('Focus', function(e) {
                            setTimeout(function() {
                                textarea.trigger('click');
                            }, 500)
                        });

                        ed.on('init', function() {
                            if (content) ed.setContent(content);
                        })
                    }

                    editorConfig.content_style = 'span.mention {\
                     background-color: #eeeeee;\
                     padding: 3px;\
                }';

                    var containerId = this.get_container_id(comment_index);
                    tinyMCE.remove('#' + containerId);

                    setTimeout(function() {
                        init_editor('#' + containerId, editorConfig)
                    }, 100)
                },
                get_container: function(textarea) {
                    if (!textarea.data('comment_index')) {
                        textarea.data('comment_index', ++this.opts.comment_index);
                    }

                    return $('<div/>', {
                        'id': this.get_container_id(this.opts.comment_index)
                    });
                },
                get_contents: function(editor) {
                    return editor.getContent();
                },
                on_post_comment: function(editor, evt) {
                    editor.setContent('');
                },
                get_container_id: function(comment_index) {
                    var container_id = this.opts.container_id;
                    if (comment_index) container_id = container_id + "-" + comment_index;
                    return container_id;
                }
            },
            currentUserIsAdmin: current_user_is_admin,
            getComments: function(success, error) {
                $.get(admin_url + 'projects/get_discussion_comments/' + discussion_id + '/' + discussion_type,
                    function(response) {
                        success(response);
                    }, 'json');
            },
            postComment: function(commentJSON, success, error) {
                $.ajax({
                    type: 'post',
                    url: admin_url + 'projects/add_discussion_comment/' + discussion_id + '/' +
                        discussion_type,
                    data: commentJSON,
                    success: function(comment) {
                        comment = JSON.parse(comment);
                        success(comment)
                    },
                    error: error
                });
            },
            putComment: function(commentJSON, success, error) {
                $.ajax({
                    type: 'post',
                    url: admin_url + 'projects/update_discussion_comment',
                    data: commentJSON,
                    success: function(comment) {
                        comment = JSON.parse(comment);
                        success(comment)
                    },
                    error: error
                });
            },
            deleteComment: function(commentJSON, success, error) {
                $.ajax({
                    type: 'post',
                    url: admin_url + 'projects/delete_discussion_comment/' + commentJSON.id,
                    success: success,
                    error: error
                });
            },
            uploadAttachments: function(commentArray, success, error) {
                var responses = 0;
                var successfulUploads = [];
                var serverResponded = function() {
                    responses++;
                    // Check if all requests have finished
                    if (responses == commentArray.length) {
                        // Case: all failed
                        if (successfulUploads.length == 0) {
                            error();
                            // Case: some succeeded
                        } else {
                            successfulUploads = JSON.parse(successfulUploads);
                            success(successfulUploads)
                        }
                    }
                }
                $(commentArray).each(function(index, commentJSON) {
                    // Create form data
                    var formData = new FormData();
                    if (commentJSON.file.size && commentJSON.file.size > app
                        .max_php_ini_upload_size_bytes) {
                        alert_float('danger',
                            "<?= _l('file_exceeds_max_filesize'); ?>"
                        );
                        serverResponded();
                    } else {
                        $(Object.keys(commentJSON)).each(function(index, key) {
                            var value = commentJSON[key];
                            if (value) formData.append(key, value);
                        });

                        if (typeof(csrfData) !== 'undefined') {
                            formData.append(csrfData['token_name'], csrfData['hash']);
                        }
                        $.ajax({
                            url: admin_url + 'projects/add_discussion_comment/' +
                                discussion_id +
                                '/' + discussion_type,
                            type: 'POST',
                            data: formData,
                            cache: false,
                            contentType: false,
                            processData: false,
                            success: function(commentJSON) {
                                successfulUploads.push(commentJSON);
                                serverResponded();
                            },
                            error: function(data) {
                                var error = JSON.parse(data.responseText);
                                alert_float('danger', error.message);
                                serverResponded();
                            },
                        });
                    }
                });
            }
        }
        var settings = $.extend({}, defaults, options);
        $(selector).comments(settings);
    }

    function new_task_from_restoration(project_id) {
        var url = admin_url + "restoration/projects/templatelist/"+project_id;
        requestGet(url)
        .done(function (response) {
            response = JSON.parse(response);
            console.log(response.html);
            $("#assign_restoration_task_modal_body").html(response.html);
            $("body").find("#assign_restoration_task_modal").modal({
                show: true,
                backdrop: "static",
            });
        })
        .fail(function (error) {
            alert_float("danger", error.responseText);
        });
    }
    $(function() {
        if($('.table-restoration_tasks').length > 0){
            initDataTable('.table-restoration_tasks', admin_url + 'restoration/tasks/table/<?=$project->id;?>', undefined, undefined, {},'');
        }

        $("#form_template_add_edit_task").appFormValidator({
            rules:{
                start_date:{
                    required: true,
                },
                due_date:{
                    required: true,
                },
                assignees:{
                    required: true,
                },
                followers:{
                    required: true,
                },
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo( element.parents(".form-group"));
            },
            submitHandler: function(form) {
                template_add_edit_task_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });
    });

    function delete_task(id){
		if (confirm_delete()) {
			$.post(admin_url + 'restoration/tasks/delete/' +id)
			.done(function (response) {
				response = JSON.parse(response);
				if (response.success === true || response.success == 'true') {
					alert_float('danger', response.message);
					$(".btn-dt-reload").trigger('click');
				} else {
					alert_float('danger', response.message);
				}
			})
			.fail(function (error) {
				alert_float('danger', JSON.parse(error.responseText));
			});
		}
	}

    // Init task modal and get data from server
    /* function init_restoration_task_modal(task_id, comment_id) {
        var queryStr = "";
        var $leadModal = $("#lead-modal");
        var $taskAddEditModal = $("#_task_modal");
        if ($leadModal.is(":visible")) {
            queryStr +=
            "?opened_from_lead_id=" + $leadModal.find('input[name="leadid"]').val();
            $leadModal.modal("hide");
        } else if ($taskAddEditModal.attr("data-lead-id") != undefined) {
            queryStr +=
            "?opened_from_lead_id=" + $taskAddEditModal.attr("data-lead-id");
        }

        requestGet("restoration/tasks/get_task_data/" + task_id + queryStr)
        .done(function (response) {
        _task_append_html(response);
        if (typeof comment_id != "undefined") {
            setTimeout(function () {
            $('[data-task-comment-href-id="' + comment_id + '"]').click();
            }, 1000);
        }
        })
        .fail(function (data) {
            $("#task-modal").modal("hide");
            alert_float("danger", data.responseText);
        });
    } */

    function template_add_edit_task_handler(form){
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                alert_float('success', response.message);
                window.location.reload();
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });
    }

    $('select[name="project_image_category"]').on('change', function () {
        var selected = $(this).val();
        alert('Selected category:', selected);
        // Add your logic here (e.g., AJAX call)
    });
    
    
    $('.table-restoration_tasks').on('click', '.edit-task', function (e) {
        e.preventDefault();
        var taskId = $(this).data('task-id');
        if (taskId) {
            var url = admin_url + "restoration/tasks/taskdetails/";

            $.ajax({
                url: url,
                type: 'POST',
                data: {
                    task_id: taskId // Pass task ID if needed
                },
                success: function (response) {
                    response = JSON.parse(response);
                    var task = response.task;

                    // Set hidden task_id field
                    $('#task_id').val(task.id);

                    // Set start date and due date if present
                    $('#start_date').val(task.startdate ? task.startdate : '');
                    $('#due_date').val(task.duedate ? task.duedate : '');

                    // Set selectpicker values
                    $('#assignees').selectpicker('val', task.assignees !== '0' ? task.assignees : '');
                    $('#followers').selectpicker('val', task.followers !== '0' ? task.followers : '');

                    // Refresh selectpickers to reflect changes
                    $('#assignees, #followers').selectpicker('refresh');
                    
                    $("body").find("#assign_restoration_task_modal").modal({
                        show: true,
                        backdrop: "static",
                    });
                },
                error: function (xhr) {
                    alert_float("danger", xhr.responseText);
                }
            });
        }
    });


</script>
</body>

</html>