<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">Settings</h4>
                        <hr class="hr-panel-heading" />

                        <?php echo form_open_multipart(admin_url('restoration/settings/save_settings'), ['id' => 'form_add_edit']);  ?>
                            <div class="form-group">
                                <label>Project IMO Number label</label>
                                <?php $restoration_imo_number_label = get_option('restoration_imo_number_label')?get_option('restoration_imo_number_label'):''; ?>
                                <input type="text" name="restoration_imo_number_label" class="form-control" required value="<?= $restoration_imo_number_label; ?>">
                            </div>

                            <div class="form-group">
                                <?php $restoration_email_subject = get_option('restoration_email_subject')?get_option('restoration_email_subject'):''; ?>
                                <?php echo render_input('restoration_email_subject', 'Email Subject', $restoration_email_subject, ''); ?>
                            </div>

                            <div class="form-group">
                                <?php $restoration_email_body = get_option('restoration_email_body')?get_option('restoration_email_body'):''; ?>
                                <?php echo render_textarea('restoration_email_body', 'Email Body', $restoration_email_body, [], [], '', 'tinymce'); ?>
                            </div>

                            <button type="submit" class="btn btn-primary">Save</button>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
jQuery(document).ready(() => {

    $("#form_add_edit").appFormValidator({
        rules: {
            email_subject: {
                required: true,
                minlength: 3
            },
            email_body: {
                required: true,
                minlength: 5
            }
        },
        errorPlacement: function(error, element) {
            $(error).addClass('text-danger');
            error.appendTo(element.parents(".form-group"));
        },
        submitHandler: function(form) {
            form.submit(); // proceed with form submission
        },
        highlight: function(element, errorClass) {
            $(element).parents('.form-group').addClass("has-error");
        }
    });

});
</script>
